package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractAsyncService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("outRentContract")
public class OutRentContractBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOutRentContractService outRentContractService;

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IParamConfigApi paramConfigApi;
	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
	@Autowired
	ISignatureCommonApi signatureCommonApi;
	@Autowired
	private IOutRentContractAsyncService outRentContractAsyncService;
	@Autowired
	private IInstoreApi iInstoreApi;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		OutRentContractEntity e = outRentContractService.selectById(billId);

		if(DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) {
			if(null == e.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
			if(!e.getContractFileSyncFlag()) {
				return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
			}
		}



		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		outRentContractService.saveOrUpdate(e,false);

		return CommonResponse.success("合同审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//TODO
		OutRentContractEntity contractEntitiy = outRentContractService.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureState()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		OutRentContractEntity e = outRentContractService.selectById(billId);
		logger.info("审批节点审批中时节点审批前回调:  当前数据-{}", JSONObject.toJSONString(e));
		//线上起草且文件未同步
		if((DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) && !e.getContractFileSyncFlag()) {
			return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
		}

		return CommonResponse.success("审批处理成功！");
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRentContractEntity contractEntity = outRentContractService.selectById(billId);
		logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);

		if (contractEntity != null){

			if((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
				//线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
				contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
             // 线上起草不使用电子签章，并且已经编辑过合同，审批通过后变为已签章履约中
			}else if (DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())
					&& contractEntity.getContractFileId() != null && contractEntity.getContractFileSyncFlag()) {
				//线上起草不使用电子签章合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线上起草不使用电子签章直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
				contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
			}
			if (DraftTypeEnum.线上起草.getCode().toString().equals(contractEntity.getDraftType())
					|| DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())) {
				if (null == contractEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
				}
				if (!contractEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
				}
			}
			if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
				//直审时添加单据提交人等信息
				contractEntity.setCommitDate(new Date());
				contractEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
				contractEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
			}
			this.checkContractFile(contractEntity);
		}
		outRentContractService.saveOrUpdate(contractEntity);
		// 合同水印
		outRentContractAsyncService.asyncWatermarkById(billId);
		// 推送项目池
//		outRentContractService.pushContract(BeanMapper.map(contractEntity, OutRentContractVO.class));
		//不使用电子签章的合同终审后推送合同
		if (DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType()) || (DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())){
			outRentContractService.pushContractToRent(JSONObject.toJSONString(outRentContractService.selectById(billId)),
					OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT);
		}
		return CommonResponse.success("合同审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutRentContractEntity contractEntitiy = outRentContractService.selectById(billId);

//		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureState()))){
//			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
//		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		// 允许撤回后，删除合同池中数据
//		outRentContractService.pushDelContract(BeanMapper.map(contractEntitiy, OutRentContractVO.class));
		//不使用电子签章的合同终审后推送合同
		if (DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntitiy.getDraftType()) || (DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntitiy.getDraftType())){
			outRentContractService.pushContractToRent(JSONObject.toJSONString(contractEntitiy),
					OutRentConstants.PUSH_RENT_OPT_TYPE_DEL, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT);
		}
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		/*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		OutRentContractEntity contractEntity = outRentContractService.selectById(billId);

		//使用电子签章且已有签章流程则不允许撤回
		if(DraftTypeEnum.线上起草.getCode().equals(contractEntity.getDraftType()) || DraftTypeEnum.上传合同.getCode().equals(contractEntity.getDraftType())) {
			if (!statusList.contains(contractEntity.getSignatureState())){
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}
		} else if(SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())) {
			contractEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		//从合同池删除数据
//		outRentContractService.pushDelContract(BeanMapper.map(contractEntity,OutRentContractVO.class));
//		contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		contractEntity.setContractPerformanceState(PerformanceStatusEnum.未签订.getCode());

		// 删除文件中心水印文件
		if(contractEntity.getWatermarkContractFileId() != null) {
			boolean delWatermarkflag = outRentContractService.delWatermarkContractFile(contractEntity.getWatermarkContractFileId());
			if (delWatermarkflag) {
				contractEntity.setWatermarkContractFileId(null);
			}
		}
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()) ||
				BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())) {
			//若合同属于已提交 并且自动归档的，则将其归档状态改为未归档
			if (DraftTypeEnum.线上起草.getCode().equals(contractEntity.getDraftType()) || DraftTypeEnum.上传合同
					.equals(contractEntity.getDraftType())) {
				contractEntity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
			}

		}
		outRentContractService.saveOrUpdate(contractEntity, false);

		return CommonResponse.success("弃审/撤回前校验回调成功！");

	}


	/**
	 * 检查合同文件
	 *
	 * @param contractEntity
	 */
	private void checkContractFile(OutRentContractEntity contractEntity) {
		//查询合同对饮附件是否存在
		CommonResponse<AttachmentVO> attachResp = attachmentApi
				.queryDetail(contractEntity.getContractFileId().toString());
		if (!attachResp.isSuccess() || null == attachResp.getData()) {
//			String sourceType = "proRentContractFile";
//			String billType = "EJCBT202210000034";
			logger.info("合同存储文件Id-{}在文件中心不存在，根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息",
					contractEntity.getContractFileId(), contractEntity.getId(), OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT,
					OutRentConstants.BILL_TYPE_OUT_CONTRACT);
			//合同附件不存在，根据合同Id、业务类型、查询是否存在对应的文件信息，若存在则更新到合同中，否则抛出异常
			CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi
					.queryListBySourceId(contractEntity.getId(), OutRentConstants.BILL_TYPE_OUT_CONTRACT,
							OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT, "desc");

			logger.info("根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息结果：{}",
					contractEntity.getId(), OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT, OutRentConstants.BILL_TYPE_OUT_CONTRACT,
					JSONObject.toJSONString(attachListResp));
			if (attachListResp.isSuccess() || CollectionUtils.isEmpty(attachListResp.getData())) {
				AttachmentVO attachmentVO = attachListResp.getData().get(0);
				logger.info("将合同id-{}对应合同文件Id-{}改为{}", contractEntity.getId(),
						contractEntity.getContractFileId(), attachmentVO.getId());
				contractEntity.setContractFileId(attachmentVO.getId());
//				contractEntity.setContractFilePath(attachmentVO.getTruePath());
			}
			else {
				throw new BusinessException("审批失败，获取合同文件信息失败, 请检查合同文件！");
			}
		}
	}



	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		OutRentContractEntity e = outRentContractService.selectById(billId);
		List<ParamsCheckVO> paramsCheckVO = outRentContractService.historyPriceCtrlContractPrice(BeanMapper.map(e, OutRentContractVO.class));
		JSONObject object = new JSONObject();
		if(paramsCheckVO.size() > 0 && paramsCheckVO.get(0).getDataSource().size() > 0){
			logger.info("单价异常");
			object.put("priceFlag","是");//是单价异常
		}else{
			logger.info("单价正常");
			object.put("priceFlag","否");//否 单价异常
		}
		return CommonResponse.success(object);
	}
}
