package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSONObject;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeAsyncService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("outRentContractChange") 
public class OutRentContractChangeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOutRentContractService outRentContractService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IOutRentContractChangeService outRentContractChangeService;
	@Autowired
    private IOutRentContractChangeAsyncService contractChangeAsyncService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		OutRentContractChangeEntity e = outRentContractChangeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		outRentContractChangeService.saveOrUpdate(e, false);
		return CommonResponse.success("变更回调处理完成！");	}


	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		OutRentContractChangeEntity changeEntity = outRentContractChangeService.selectById(billId);
//		logger.info("变更单终审审批前变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));
//		if (null != changeEntity && !(changeEntity.getBillState().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) || changeEntity.getBillState().equals(BillStateEnum.UNAPPROVED.getBillStateCode()))){
//			return CommonResponse.error("该单据已被修改，请勿重复提交！");
//		}
		return CommonResponse.success("变更单终审审批前回调处理成功！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		/**更新变更的审批时间  begin */
		OutRentContractChangeEntity changeEntity = outRentContractChangeService.selectById(billId);
		OutRentContractEntity contractEntity = outRentContractService.selectById(changeEntity.getContractId());
		if (null != contractEntity && !contractEntity.getContractPerformanceState().equals(PerformanceStatusEnum.履约中.getCode())){
			return CommonResponse.error("当前变更合同所属的主合同状态不是履约中，该变更合同不能进行提交操作！");
		}
		Boolean commitState = false;
		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			commitState = true;
			//直审设置单据提交人信息
			changeEntity.setCommitDate(new Date());
			changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		}

		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			//调用生效回写服务
			CommonResponse<String> rsp = outRentContractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState);
			if (!rsp.isSuccess()) {
				logger.info("合同生效回写失败！失败原因：{}" ,JSONObject.toJSONString(rsp));
				throw new BusinessException("合同审核失败！");
			}
		}else {
			//变更单更新
			if (commitState){
				outRentContractChangeService.saveOrUpdate(changeEntity);
			}

			//回写主合同信息
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			outRentContractService.saveOrUpdate(contractEntity, false);
			outRentContractService.pushContractToRent(JSONObject.toJSONString(changeEntity),
					OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT_CHANGE);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}
		// 生成水印
		contractChangeAsyncService.asyncWatermarkById(billId);
		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return doBpmBack(billId, state, billTypeCode);
	}
	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		OutRentContractChangeEntity changeEntity = outRentContractChangeService.selectById(billId);
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if(!DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType()) && !statusList.contains(changeEntity.getSignatureState())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		} else if(SignatureStatusEnum.已签章.getCode().equals(changeEntity.getSignatureState())) {
			changeEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
		}
		changeEntity.setCommitDate(null);
		changeEntity.setCommitUserCode(null);
		changeEntity.setCommitUserName(null);
		outRentContractChangeService.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		OutRentContractEntity contractEntity = outRentContractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		outRentContractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		outRentContractService.pushContractToRent(JSONObject.toJSONString(changeEntity),
				OutRentConstants.PUSH_RENT_OPT_TYPE_DEL, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT_CHANGE);
		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}



	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		OutRentContractChangeEntity e = outRentContractChangeService.selectById(billId);
		List<ParamsCheckVO> paramsCheckVO = outRentContractChangeService.historyPriceCtrlContractPrice(BeanMapper.map(e, OutRentContractChangeVO.class));
		JSONObject object = new JSONObject();
		if(paramsCheckVO.size() > 0 && paramsCheckVO.get(0).getDataSource().size() > 0){
			logger.info("单价异常");
			object.put("priceFlag","是");//是单价异常
		}else{
			logger.info("单价正常");
			object.put("priceFlag","否");//否 单价异常
		}
		return CommonResponse.success(object);
	}
}
