package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.*;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.*;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractChangeMapper;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractMapper;
import com.ejianc.business.proequipmentcorpout.contract.service.*;
import com.ejianc.business.proequipmentcorpout.contract.utils.MaterialConstant;
import com.ejianc.business.proequipmentcorpout.contract.vo.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 租赁合同变更
 *
 * @author generator
 *
 */
@Service("outRentContractChangeService")
public class OutRentContractChangeServiceImpl extends BaseServiceImpl<OutRentContractChangeMapper, OutRentContractChangeEntity> implements IOutRentContractChangeService {
    @Autowired
    private IOutRentContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractRecordService contractRecordService;
    @Autowired
    private IOutRentContractService outRentContractService;
    @Autowired
    private IOutRentContractRecordService outRentContractRecordService;
    private static final String BILL_CHANGE_CODE = "OutRent_CONTRACT_CHANGE";//此处需要根据实际修改
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IOutRentDayDetailedService outRentDayDetailedService;
    @Autowired
    private IOutRentMonthDetailedService outRentMonthDetailedService;
    @Autowired
    private IOutRentQuantitiesDetailedService outRentQuantitiesDetailedService;
    @Autowired
    private IOutRentOtherDetailedService outRentOtherDetailedService;
//    @Autowired
//    private IOutRentTotalPlanService outRentTotalPlanService;

    @Autowired
    private IOutRentContractClauseService contractClauseService;
    @Autowired
    private OutRentContractMapper outRentContractMapper;
    @Autowired
    private IOutRentContractPaymentClauseService contractPaymentService;
    private final String CONTRACT_RECORD_REFCODE = "proSubContractRecord";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private final String CONTRACT_REFCODE = "proSubContract";
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";

    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
//    @Autowired
//    private IOutRentContractChangeAsyncService contractChangeAsyncService;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886"; // 水印参数

    private static final String CHECK_PARAM_CODE = "P-4i7sNe70";//变更金额控制
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";//设备租赁总计划金额控制

    // 设备公司租出合同-签订、变更、补充协议  【设备历史最高价】控【设备公司租出合同】
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-F2i4L00255";
    // 设备公司租出合同-签订、变更、补充协议  【设备历史最低价】控【设备公司租出合同】
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-qp1uzp0256";


    /**
     *
     * 变更
     * @param outRentContractChangeVO
     */
    @Override
    public OutRentContractChangeVO saveOrUpdates(OutRentContractChangeVO outRentContractChangeVO) {
        OutRentContractEntity outRentContractEntity =contractService.getById(outRentContractChangeVO.getContractId());
        LambdaQueryWrapper<OutRentContractChangeEntity> lambdachange = Wrappers.<OutRentContractChangeEntity>lambdaQuery();
        lambdachange.eq(OutRentContractChangeEntity::getContractId, outRentContractChangeVO.getMainContractId());
        if(outRentContractChangeVO.getId() != null) {
            lambdachange.ne(OutRentContractChangeEntity::getId,outRentContractChangeVO.getId());
        }
        lambdachange.and(l -> l.ne(OutRentContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(OutRentContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if(CollectionUtils.isNotEmpty(outRentContractChangeVO.getAttachIds()) &&  null != outRentContractEntity.getContractFileId()) {
            outRentContractChangeVO.getAttachIds().remove(outRentContractChangeVO.getContractFileId());
        }

        OutRentContractChangeEntity changeEntity = BeanMapper.map(outRentContractChangeVO, OutRentContractChangeEntity.class);
        if (changeEntity.getId() == null){
            changeEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(PerformanceStatusEnum.未签订.getCode());
            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setCode(changeEntity.getCode() + "10" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setCode(changeEntity.getCode() + "1" + changeEntity.getChangeVersion());
            }
            this.clearDetailList(changeEntity);
        }
        changeEntity.setChangeContractName(changeEntity.getContractName());
        super.saveOrUpdate(changeEntity,false);//保存
        saveOrUpdateContract(changeEntity);//回写主表
        outRentContractService.pushContractToRent(JSONObject.toJSONString(changeEntity),
                OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT_CHANGE);
        OutRentContractChangeVO changeVO = BeanMapper.map(changeEntity, OutRentContractChangeVO.class);
        return changeVO;
    }

    /**
     * 查询合同
     * @param contractId
     * @param changeId
     * @return
     */
    @Override
    public OutRentContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        OutRentContractEntity contractEntity = contractService.selectById(contractId);
        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            OutRentContractChangeEntity change = this.selectById(contractEntity.getChangeId());
            OutRentContractChangeVO vo = BeanMapper.map(change, OutRentContractChangeVO.class);
            return vo;
        }
        OutRentContractVO vo =BeanMapper.map(contractEntity,OutRentContractVO.class);
        OutRentContractChangeVO changeVO = BeanMapper.map(vo, OutRentContractChangeVO.class);
        changeVO.setBillState(null);

        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setMainContractId(contractEntity.getId());
        changeVO.setMainContractCode(contractEntity.getCode());
        changeVO.setMainContractName(contractEntity.getContractName());
        changeVO.setBeforeChangeTax(contractEntity.getContractAmountTax());

        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setSignatureState(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        changeVO.setWatermarkContractFileId(null); // 水印设置为null
       /* CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractEntity.getId()), billTypeCode, "attachMgr", String.valueOf(contractEntity.getId()), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));*/
        changeVO.setSignedFileId(null);

        resetSub(changeVO);
        return changeVO;
    }


    /**
     * 更改子表
     * @param changeVO
     */
    public void resetSub(OutRentContractChangeVO changeVO) {
        //日租明细
        List<OutRentChangeDayDetailedVO> dayList = changeVO.getRentDayDetailedList();
        if(CollectionUtils.isNotEmpty(dayList)){
            dayList.forEach(dayDetailed ->{
                dayDetailed.setSrcTblId(dayDetailed.getId());
                dayDetailed.setId(IdWorker.getId());
//                dayDetailed.setSrcTblId(dayDetailed.getId());
                dayDetailed.setBeforeDayRentPrice(dayDetailed.getDayRentPrice());
                dayDetailed.setBeforeRentNum(dayDetailed.getRentNum());
                dayDetailed.setBeforeStopRentPrice(dayDetailed.getStopRentPrice());
                dayDetailed.setRowState("edit");
            });
        }
        //月租明细
        List<OutRentChangeMonthDetailedVO> monthList = changeVO.getRentMonthDetailedList();
        if(CollectionUtils.isNotEmpty(monthList)){
            monthList.forEach(monthDetailed ->{
                monthDetailed.setSrcTblId(monthDetailed.getId());
                monthDetailed.setId(IdWorker.getId());
                monthDetailed.setChangeId(monthDetailed.getId());
                monthDetailed.setBeforeDayTaxPrice(monthDetailed.getDayTaxPrice());
                monthDetailed.setBeforeInsufficientMonthDayRentPrice(monthDetailed.getInsufficientMonthDayRentPrice());
                monthDetailed.setBeforeMonthRentPrice(monthDetailed.getMonthRentPrice());
                monthDetailed.setRowState("add");
            });
        }

        List<OutRentChangeOtherDetailedVO> otherList = changeVO.getRentOtherDetailedList();
        if(CollectionUtils.isNotEmpty(otherList)){
            otherList.forEach(otherDetailed ->{
                otherDetailed.setSrcTblId(otherDetailed.getId());
                otherDetailed.setId(IdWorker.getId());
                otherDetailed.setBeforeNotTaxAmount(otherDetailed.getNotTaxAmount());
                otherDetailed.setBeforeNotTaxPrice(otherDetailed.getNotTaxPrice());
                otherDetailed.setBeforeNum(otherDetailed.getNum());
                otherDetailed.setBeforePrice(otherDetailed.getPrice());
                otherDetailed.setBeforeTax(otherDetailed.getTax());
                otherDetailed.setBeforeTaxAmount(otherDetailed.getTaxAmount());
                otherDetailed.setRowState("edit");
            });
        }
        //工程量
        List<OutRentChangeQuantitiesVO> quantitiesList = changeVO.getRentQuantitiesDetailedList();
        if(CollectionUtils.isNotEmpty(quantitiesList)){
            quantitiesList.forEach(quantities ->{
                quantities.setSrcTblId(quantities.getId());
                quantities.setId(IdWorker.getId());
                quantities.setBeforeQuantitiesNum(quantities.getQuantitiesNum());
                quantities.setBeforeQuantitiesPrice(quantities.getQuantitiesPrice());
                quantities.setBeforeRentNum(quantities.getRentNum());
                quantities.setBeforeTax(quantities.getTax());
                quantities.setRowState("edit");
            });
        }
        //合同条款
        List<OutRentChangeContractClauseVO> contractList = changeVO.getRentContractClauseList();
        if(CollectionUtils.isNotEmpty(contractList)){
            contractList.forEach(item ->{
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }

        //合同支付条款
        List<OutRentChangeContractPaymentVO> paymentList = changeVO.getRentContractPaymentClauseList();
        if(CollectionUtils.isNotEmpty(paymentList)){
            paymentList.forEach(item ->{
                item.setSrcTblId(item.getId());
                item.setRowState("edit");
            });
        }
    }

    /**
     * 变更回写到主合同
     */
    @Transactional
    public void saveOrUpdateContract(OutRentContractChangeEntity changeEntity){
        OutRentContractEntity outRentContractEntity =contractService.getById(changeEntity.getContractId());
        outRentContractEntity.setChangeCode(changeEntity.getCode());
        outRentContractEntity.setChangeDate(changeEntity.getChangeDate());
        outRentContractEntity.setChangeId(changeEntity.getId());
        outRentContractEntity.setChangeStatus(2);//改成变更中
        outRentContractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        outRentContractEntity.setChangeFile(changeEntity.getChangeFile());
        outRentContractEntity.setBeforeChangeMny(outRentContractEntity.getContractMny());
        outRentContractEntity.setAfterChangeMny(changeEntity.getChangeMny());
        outRentContractEntity.setChangeVersion(changeEntity.getChangeVersion());
        outRentContractEntity.setChangingMny((changeEntity.getChangeMny()!= null?changeEntity.getChangeMny():BigDecimal.ZERO).subtract(changeEntity.getChangeTax()!= null?changeEntity.getChangeTax():BigDecimal.ZERO));
        outRentContractEntity.setChangeContractSignatureStatus(Integer.valueOf(changeEntity.getSignatureState()));
        outRentContractEntity.setChangeFile(changeEntity.getChangeFile());
        contractService.saveOrUpdate(outRentContractEntity);
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    @Override
    public OutRentContractChangeVO queryDetailRecord(Long id) {
        OutRentContractEntity contractEntity = contractService.selectById(id);
        OutRentContractChangeVO changeVO = new OutRentContractChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
//        param.getParams().put("contract_performance_state", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("signature_state", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), OutRentContractChangeVO.class));

        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0 ){
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
//        page.findUI('changeBtn').disabled = (data.performanceStatus == "3" ||
//                data.performanceStatus == "4" || data.performanceStatus == "5" ||
//                data.changeStatus == 2 || data.signatureStatus != 3) ? true : false;

        //判断能否新增变更
//        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
//                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
//                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
//                && (!(PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState())))){
//
//            changeVO.setEditFlag(this.editChangeFlag(id));
//        }
        Boolean isEditFlag = null;
        String contractPerformanceState = contractEntity.getContractPerformanceState();
        Integer changeStatus = contractEntity.getChangeStatus();
        String signatureState = contractEntity.getSignatureState();
        if (contractPerformanceState.equals(PerformanceStatusEnum.已终止.getCode()) ||
                contractPerformanceState.equals(PerformanceStatusEnum.已作废.getCode()) ||
                contractPerformanceState.equals(PerformanceStatusEnum.已冻结.getCode()) ||
                changeStatus.equals(ChangeStatusEnum.变更中.getCode()) )
        {
            isEditFlag = true;
        }else {
            isEditFlag = false;
        }
        changeVO.setEditFlag(isEditFlag);

        return changeVO;
    }
    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<OutRentContractChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(OutRentContractChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(OutRentContractChangeEntity::getSignatureState, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(OutRentContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<OutRentContractChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }

    /**
     * 审批通过后调用
     * @param changeBillId
     * @param billTypeCode
     * @param commitState
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        OutRentContractChangeEntity changeEntity = this.selectById(changeBillId);

        // 原合同数据
        OutRentContractVO contractVO = outRentContractService.queryDetail(changeEntity.getContractId());

        // 回写记录表数据
        writeBackRecord(changeEntity, contractVO);

        // 回写原合同数据
        OutRentContractEntity outRentContractEntity = writeBackContract(changeEntity, contractVO);

        // 设置变更合同生效状态
        changeEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
        changeEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
        changeEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.已签章.getCode()));
        changeEntity.setCommitDate(new Date());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        // 变更单更新
        contractChangeService.saveOrUpdate(changeEntity);


        outRentContractService.pushContractToRent(JSONObject.toJSONString(changeEntity),
                OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, OutRentConstants.PUSH_RENT_OPT_BILL_CONTRACT_CHANGE);
        // 推送合同池
//        contractService.pushContract(BeanMapper.map(outRentContractEntity, OutRentContractVO.class));

        return CommonResponse.success("变更单生效，回写合同成功！");

    }

    /**
     * 回写记录表数据
     * @param changeEntity
     * @param contractVO
     */
    public void writeBackRecord(OutRentContractChangeEntity changeEntity, OutRentContractVO contractVO) {
        // 同步原合同到记录表
        OutRentContractRecordEntity recordEntity = BeanMapper.map(contractVO, OutRentContractRecordEntity.class);
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())){
            recordEntity.getRentDayDetailedList().forEach(vo -> {
//                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())){
            recordEntity.getRentMonthDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())){
            recordEntity.getRentQuantitiesDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentOtherDetailedList())){
            recordEntity.getRentOtherDetailedList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())){
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        if(CollectionUtils.isNotEmpty(recordEntity.getRentContractPaymentClauseList())){
            recordEntity.getRentContractPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        contractRecordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");

        // 原合同附件、起草附件同步到记录单据中
        logger.info("同步附件");
//        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
//                String.valueOf(contractVO.getId()), "EJCBT202210000034", "proOutRentContract",
//                String.valueOf(recordEntity.getId()), "EJCBT202204000017", "proOutRentContractRecord");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT_ATT,
                String.valueOf(recordEntity.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT_RECORD, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT_RECORD_ATT);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        logger.info("同步附件");
        CommonResponse<String> response2 = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(contractVO.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT,
                String.valueOf(recordEntity.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT_RECORD, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT_RECORD);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response2));



    }
    public OutRentContractEntity writeBackContract(OutRentContractChangeEntity changeEntity, OutRentContractVO contractVO) {
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        OutRentContractEntity contractEntity = BeanMapper.map(contractVO, OutRentContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setPartyId(changeEntity.getPartyId());
        contractEntity.setPartyName(changeEntity.getPartyName());
        contractEntity.setPartyPhone(changeEntity.getPartyPhone());
        contractEntity.setPartyHandleUser(changeEntity.getPartyHandleUser());
        contractEntity.setPartyHandleUserName(changeEntity.getPartyHandleUserName());
        contractEntity.setPartyUser(changeEntity.getPartyUser());
        contractEntity.setPartyUserName(changeEntity.getPartyUserName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierHandleUser(changeEntity.getSupplierHandleUser());
        contractEntity.setSupplierHandleUserName(changeEntity.getSupplierHandleUserName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplementCode(changeEntity.getSupplementCode());
        contractEntity.setMeterRentType(changeEntity.getMeterRentType());
        contractEntity.setMeterRentTypeName(changeEntity.getMeterRentTypeName());
        contractEntity.setMonthSettlement(changeEntity.getMonthSettlement());
        contractEntity.setMeterDate(changeEntity.getMeterDate());
        contractEntity.setPreventDate(changeEntity.getPreventDate());
        contractEntity.setSignedDate(changeEntity.getSignedDate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFile(changeEntity.getContractFile());
        contractEntity.setChangingRatio(changeEntity.getChangingRatio());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangingTaxMny(null);
        contractEntity.setRentHarborType(changeEntity.getRentHarborType());
        contractEntity.setTargetType(changeEntity.getTargetType());
        contractEntity.setTargetResultId(changeEntity.getTargetResultId());
        contractEntity.setTargetResultName(changeEntity.getTargetResultName());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());


		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        // 回写原合同子表信息
        // 日租
        if (ListUtil.isNotEmpty(contractVO.getRentDayDetailedList())) {
            List<Long> collect = contractVO.getRentDayDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                outRentDayDetailedService.removeByIds(collect);
            }

        }
        List<OutRentDayDetailedEntity> dailyOutRentList = BeanMapper.mapList(changeEntity.getRentDayDetailedList(), OutRentDayDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentDayDetailedEntity entity : dailyOutRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentDayDetailedList(dailyOutRentList);
        // 月租
        if (ListUtil.isNotEmpty(contractVO.getRentMonthDetailedList())) {
            List<Long> collect = contractVO.getRentMonthDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                outRentMonthDetailedService.removeByIds(collect);
            }

        }
        List<OutRentMonthDetailedEntity> monthOutRentList = BeanMapper.mapList(changeEntity.getRentMonthDetailedList(), OutRentMonthDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentMonthDetailedEntity entity : monthOutRentList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentMonthDetailedList(monthOutRentList);
        // 工程租
        if (ListUtil.isNotEmpty(contractVO.getRentQuantitiesDetailedList())) {
            List<Long> collect = contractVO.getRentQuantitiesDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                outRentQuantitiesDetailedService.removeByIds(collect);
            }

        }
        List<OutRentQuantitiesDetailedEntity> quantitiesDetailedList = BeanMapper.mapList(changeEntity.getRentQuantitiesDetailedList(), OutRentQuantitiesDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentQuantitiesDetailedEntity entity : quantitiesDetailedList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentQuantitiesDetailedList(quantitiesDetailedList);
        // 其他费用
        if (ListUtil.isNotEmpty(contractVO.getRentOtherDetailedList())) {
            List<Long> collect = contractVO.getRentOtherDetailedList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                outRentOtherDetailedService.removeByIds(collect);
            }

        }
        List<OutRentOtherDetailedEntity> otherDetailedList = BeanMapper.mapList(changeEntity.getRentOtherDetailedList(), OutRentOtherDetailedEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentOtherDetailedEntity entity : otherDetailedList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
//
        contractEntity.setRentOtherDetailedList(otherDetailedList);
        // 条款
        if (ListUtil.isNotEmpty(contractVO.getRentContractClauseList())) {
            List<Long> collect = contractVO.getRentContractClauseList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                contractClauseService.removeByIds(collect);
            }

        }
        List<OutRentContractClauseEntity> contractClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractClauseList(), OutRentContractClauseEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentContractClauseEntity entity : contractClauseEntityList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractClauseList(contractClauseEntityList);
        // 付款
        if (ListUtil.isNotEmpty(contractVO.getRentContractClauseList())) {
            List<Long> collect = contractVO.getRentContractPaymentClauseList().stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)){
                contractClauseService.removeByIds(collect);
            }

        }
        List<OutRentContractPaymentClauseEntity> paymentClauseEntityList = BeanMapper.mapList(changeEntity.getRentContractPaymentClauseList(), OutRentContractPaymentClauseEntity.class);
        if (ListUtil.isNotEmpty(dailyOutRentList)) {
            for (OutRentContractPaymentClauseEntity entity : paymentClauseEntityList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRentContractPaymentClauseList(paymentClauseEntityList);

        //
        contractService.saveOrUpdate(contractEntity, false);

        // 同步起草方式附件（不包含变更附件管理附件）到原合同
        logger.info("同步附件");
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(changeEntity.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT_CHANGE, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT_CHANGE,
                String.valueOf(contractEntity.getId()), OutRentConstants.BILL_TYPE_OUT_CONTRACT, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT);
        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));
        return contractEntity;


    }
    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        OutRentContractChangeEntity entity = super.selectById(changeBillId);
        //合同变更只有详情页有删除
        OutRentContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<OutRentContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFile(null);
        //contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<OutRentContractEntity>().eq("id",contractEntity.getId()),false);

        super.removeById(changeBillId,false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public OutRentContractChangeVO saveOrUpdate(OutRentContractChangeVO saveOrUpdateVO,Boolean isControl) {
        // 获取主合同当前合同文件Id
        OutRentContractEntity outRentContractEntity = contractService.selectById(saveOrUpdateVO.getMainContractId());
        // 将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if(ListUtil.isNotEmpty(saveOrUpdateVO.getAttachIds()) &&  null != outRentContractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(outRentContractEntity.getContractFileId());
        }

        OutRentContractChangeEntity entity = BeanMapper.map(saveOrUpdateVO, OutRentContractChangeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            if (!isControl){
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CHANGE_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if (billCode.isSuccess()) {
//                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                }
//                else {
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
            }
            entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            entity.setContractState(ContractStatusEnum.未签订.getCode());
            entity.setFilingRef(0);
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                // 第一次变更
                entity.setChangeVersion(1);
            }
            else {
                // 版本号+1
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            //设置编码
            if(entity.getChangeVersion() < 10){
                entity.setCode(saveOrUpdateVO.getCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setCode(saveOrUpdateVO.getCode() + "-1-"  + entity.getChangeVersion());
            }
            if (!isControl){
                // 清空字表id、复制sourceBid
                clearDetailList(entity);
            }
        }
        if (saveOrUpdateVO.getId() == null &&!isControl){
            QueryWrapper<OutRentContractChangeEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("contract_id", saveOrUpdateVO.getContractId()).orderByDesc("create_time");
            List<OutRentContractChangeEntity> list = super.list(wrapper);
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            //删除旧的目标成本
//            ExecutionVO executionVO1;
//            if (list.size() > 0) {
//                executionVO1 = targetCost(BeanMapper.map(list.get(0), OutRentContractChangeVO.class),null);
//            }else {
//                executionVO1 = contractService.targetCost(BeanMapper.map(outRentContractEntity, OutRentContractVO.class),"");
//
//            }
//            totalExecutionVOList.add(executionVO1.getTotalVO());
//            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//            if (!response.isSuccess()){
//                throw new BusinessException("删除旧目标成本失败！");
//            }
        }

        contractService.validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.变更单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setContractName(entity.getContractName());
        entity.setChangeContractName(entity.getContractName());
        if (!isControl){
            this.saveOrUpdate(entity, false);
        }


        // 回写主合同信息
        LambdaUpdateWrapper<OutRentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OutRentContractEntity::getChangeId, entity.getId());
        updateWrapper.set(OutRentContractEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(OutRentContractEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(OutRentContractEntity::getChangeCode, entity.getCode());
        updateWrapper.set(OutRentContractEntity::getChangeVersion, entity.getChangeVersion());
        updateWrapper.set(OutRentContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(OutRentContractEntity::getChangeDate, entity.getChangeDate());
        updateWrapper.set(OutRentContractEntity::getChangeDraftType, entity.getChangeDraftType());
        updateWrapper.set(OutRentContractEntity::getChangeContractSignatureStatus, entity.getSignatureState());
        updateWrapper.set(OutRentContractEntity::getChangeFileId, entity.getChangeFileId());
        updateWrapper.set(OutRentContractEntity::getChangeContractName, entity.getContractName());
        updateWrapper.eq(OutRentContractEntity::getId, entity.getMainContractId());
        if (!isControl){
            contractService.update(updateWrapper);
//            OutRentContractChangeVO vo = BeanMapper.map(this.selectById(entity.getId()), OutRentContractChangeVO.class);
//
//            // 推送新目标成本
//            CommonResponse<String> response = executionApi.aggPush(targetCost(vo,null));
//            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败！");
//            }
        }
        if (null ==entity.getId() && isControl) {
            entity.setId(IdWorker.getId());
            return BeanMapper.map(entity,OutRentContractChangeVO.class);
        }
        return BeanMapper.map(entity, OutRentContractChangeVO.class);

    }

    public void deleteOldCost(OutRentContractChangeVO changeVO) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();

        ExecutionVO executionVO = targetCost(changeVO,null);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("删除旧目标成本失败！");
        }
    }
    @Override
    public ExecutionVO targetCost(OutRentContractChangeVO changeVO,Long lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();

        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getCode());
        totalVO.setBillType(OutRentConstants.BILL_TYPE_OUT_CONTRACT);
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLastSourceId(lastSourceId);
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/leaseContractcontractChangeCard?id=" + changeVO.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;
    }


    /**
     * 文件复制
     *
     * @param srcBillId 源单据Id
     * @param srcBillTypeCode 源单据类型
     * @param targetBillId 目标单据Id
     * @param targetBillTypeCode 目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE);
        if (!copyContractAttachResp.isSuccess()){
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    ,srcBillId, srcBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_ATTACH_SOURCE_TYPE, copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if(copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE,
                    targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE);
            if (!copyContractFileResp.isSuccess()){
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        ,srcBillId, srcBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, targetBillId, targetBillTypeCode, CONTRACT_FILE_SOURCE_TYPE, copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }
    @Override
    public void queryBpm(Long billId){
        OutRentContractEntity contractEntity = contractService.selectById(billId);
        if (contractEntity != null){

            if((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
                //线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
                logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
                contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
                contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
                //合同已生效，添加生效时间
                contractEntity.setEffectiveDate(new Date());
            } else if(null == contractEntity.getContractFileId()) {
                //确保线上起草方式时，用户已编辑合同文件
            }
        }

        //直审时添加单据提交人等信息
        contractEntity.setCommitDate(new Date());
        contractEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
        contractEntity.setCommitUserName(sessionManager.getUserContext().getUserName());


        contractService.saveOrUpdate(contractEntity);
    }

    public void clearDetailList(OutRentContractChangeEntity changeEntity) {
        // 日租
        if(ListUtil.isNotEmpty(changeEntity.getRentDayDetailedList())){
            for (OutRentChangeDayDetailedEntity entity : changeEntity.getRentDayDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 月租
        if(ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())){
            for (OutRentChangeMonthDetailedEntity entity : changeEntity.getRentMonthDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 工程量租
        if(ListUtil.isNotEmpty(changeEntity.getRentMonthDetailedList())){
            for (OutRentChangeMonthDetailedEntity entity : changeEntity.getRentMonthDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 维修
        if(ListUtil.isNotEmpty(changeEntity.getRentOtherDetailedList())){
            for (OutRentChangeOtherDetailedEntity entity : changeEntity.getRentOtherDetailedList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }


        // 付款计划
        if(ListUtil.isNotEmpty(changeEntity.getRentContractPaymentClauseList())){
            for (OutRentChangeContractPaymentEntity entity : changeEntity.getRentContractPaymentClauseList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
        // 合同条款
        if(ListUtil.isNotEmpty(changeEntity.getRentContractClauseList())){
            for (OutRentChangeContractClauseEntity entity : changeEntity.getRentContractClauseList()) {
//                if (entity.getId() != null) {
//                    // 来源合同子表id
//                    entity.setSrcTblId(entity.getId());
//                }
                entity.setId(null);
                entity.setContractId(changeEntity.getMainContractId());
            }
        }
    }


    @Override
    public ParamsCheckVO targetCostCtrl(OutRentContractChangeVO changeVO) {
//        OutRentContractChangeVO contractVO1 = saveOrUpdate(changeVO,true);
//        QueryWrapper<OutRentContractChangeEntity> wrapper = new QueryWrapper<>();
//        wrapper.eq("contract_id", changeVO.getContractId()).orderByDesc("create_time");
//        List<OutRentContractChangeEntity> list = super.list(wrapper);
//        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//        OutRentContractEntity outRentContractEntity = contractService.selectById(changeVO.getContractId());
//        Long lastSourceId = null;
//        if (list.size() > 0) {
//            lastSourceId = list.get(0).getId();
//        }else {
//            lastSourceId = outRentContractEntity.getId();
//
//        }
//        ExecutionVO executionVO = targetCost(contractVO1,lastSourceId);
//        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
//        logger.error("ss" + JSONObject.toJSONString(executionVO));
//        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//        ParamsCheckVO paramsCheckVO = checkParams(contractVO1, response.getData());
        ParamsCheckVO paramsCheckVO = checkParams(changeVO, null);
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        OutRentContractChangeVO contractVO = queryDetail(id);
//        ExecutionVO executionVO = targetCost(contractVO,null);
//        logger.error("ss" + JSONObject.toJSONString(executionVO));
//        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, null);
        return paramsCheckVO;
    }

    @Override
    public OutRentContractChangeVO queryDetail(Long id) {
        OutRentContractChangeEntity entity = contractChangeService.selectById(id);
        OutRentContractChangeVO vo = BeanMapper.map(entity, OutRentContractChangeVO.class);
        return vo;
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        OutRentContractChangeEntity changeEntity = super.selectById(billId);
        if (changeEntity != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                this.effectiveSaveWriteContract(billId, changeEntity.getCode(), false);
                // 推送合同池
//                outRentContractService.pushContract(BeanMapper.map(contractEntity, OutRentContractVO.class));
                return true;
            }
            else {
                changeEntity.setSignatureState(String.valueOf(status));
                super.saveOrUpdate(changeEntity);
                logger.info("变更合同签章状态已修改---------------->");
                //回写主合同（变更合同签章状态，主合同变更状态）
                LambdaUpdateWrapper<OutRentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(OutRentContractEntity::getId, changeEntity.getContractId());
                updateWrapper.set(OutRentContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureState()));
                contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                logger.info("签章状态为已签章，回写主合同签章状态---------------->");
            }
            return true;
        }
        else {
            return false;
        }
    }
    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(OutRentContractChangeVO vo,ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
//        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
//            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
//        }
//        paramsCheckVOS.addAll(this.checkParamsMny(vo));//合同金额控制变更金额
//        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));//总计划金额控制
//        if(paramsCheckVO2!=null){//组合成本参数
//            paramsCheckVOS.add(paramsCheckVO2);
//        }

        // 历史价控 合同价
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(OutRentContractChangeVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }



    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMny(OutRentContractChangeVO vo) {
        BigDecimal changeMoney  = vo.getChangeMny()==null?BigDecimal.ZERO:vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny()==null?BigDecimal.ZERO:vo.getBaseTaxMny();//初始合同金额
        BigDecimal totalChangeMoney =  changeMoney;//累计变更金额  默认赋值本次
        //查询累计变更金额
        QueryWrapper<OutRentContractChangeEntity> query = new QueryWrapper<>();
        query.eq("contract_id", vo.getContractId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",1,3);
        query.eq("signature_state",SignatureStatusEnum.已签章.getCode());
        List<OutRentContractChangeEntity> list = this.list(query);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list)){
            for (OutRentContractChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd(changeEntity.getChangeMny(),totalChangeMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("累计变更金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("变更超合同金额");
                        paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次变更金额：").append(changeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计变更金额：").append(totalChangeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalChangeMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(OutRentContractChangeVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次合同金额
        BigDecimal planTaxMny = BigDecimal.ZERO;//总计划金额
        BigDecimal totalMoney =  contractTaxMny;//累计合同金额  默认赋值本次
        //查询总计划
//        LambdaQueryWrapper<OutRentTotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
//        planLambda.eq(OutRentTotalPlanEntity::getProjectId, vo.getProjectId());
//        planLambda.in(OutRentTotalPlanEntity::getBillState,1,3);
//        planLambda.eq(OutRentTotalPlanEntity::getDr,0);
//        List<OutRentTotalPlanEntity> planList = outRentTotalPlanService.list(planLambda);
//        if(CollectionUtils.isNotEmpty(planList)){
//            planTaxMny = planList.stream().filter(e -> e.getTemporaryAmount() != null).map(OutRentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
//        }else {
//            return paramsCheckVOList;
//        }
        //查询合同
        LambdaQueryWrapper<OutRentContractEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(OutRentContractEntity::getProjectId, vo.getProjectId());
        Lambda.orderByDesc(OutRentContractEntity::getCreateTime);
        Lambda.ne(OutRentContractEntity::getId, vo.getContractId());//除本次
        List<OutRentContractEntity> list = outRentContractService.list(Lambda);//查询项目下所有合同
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> collect = list.stream().map(OutRentContractEntity::getId).collect(Collectors.toList());
            List<OutRentContractChangeVO> contractChangeList = outRentContractMapper.getRentContractChangeList(collect);//查询未生效的变更单
            Map<Long, OutRentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
//            List<OutRentSettlementVO> settlementList = outRentContractMapper.getRentSettlementList(collect);//查询最后一个结算单
//            Map<Long, OutRentSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
//            for (OutRentContractEntity entity : list) {
//                BigDecimal zero = BigDecimal.ZERO;//要累加的金额
//                if (PerformanceStatusEnum.已终止.getCode().equals(entity.getContractPerformanceState()) ||PerformanceStatusEnum.已作废.getCode().equals(entity.getContractPerformanceState())){
//                    //合同已终止、已结束、已作废：取合同结算金额）  即最终结算或 最后一次结算  累计结算金额
//                    if(mapSettle.containsKey(entity.getId())){
//                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
//                    }// 校验变更合同
//                }else if(mapChange.containsKey(entity.getId())){//有为生效的变更单  取最新变更单金额
//                    zero = mapChange.get(entity.getId()).getContractTaxMny();
//                } else {//没有未生效的变更单   合同状态为 未签订、履约中、已冻结取签订金额
//                    zero = entity.getContractTaxMny();
//                }
//                totalMoney = ComputeUtil.safeAdd(zero,totalMoney);//累加变更金额
//            }
        }
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PLAN_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("租赁金额超总计划金额");
                        paramsCheckDsVO.setWarnName("租赁金额超总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计合同金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    @Override
    public Map queryChangeCompare(Long id) {
          /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        OutRentContractChangeEntity changeEntity = super.selectById(id);
        OutRentContractChangeVO changeCompareVO = BeanMapper.map(changeEntity, OutRentContractChangeVO.class);
        OutRentContractEntity contractEntity = outRentContractService.selectById(changeEntity.getContractId());

        OutRentContractChangeVO beforeChangeVO = new OutRentContractChangeVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            // 若变更单已审批通过，则查询最新的合同记录
            LambdaQueryWrapper<OutRentContractRecordEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(OutRentContractRecordEntity::getChangeId, id);
            wrapper.eq(OutRentContractRecordEntity::getContractId, changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);

            List<OutRentContractRecordEntity> recordEntityList = contractRecordService.list(wrapper);
            if (ListUtil.isNotEmpty(recordEntityList)) {
                beforeChangeVO = BeanMapper.map(contractRecordService.selectById(recordEntityList.get(0).getId()), OutRentContractChangeVO.class);
            }
        }else {
            beforeChangeVO = BeanMapper.map(contractEntity, OutRentContractChangeVO.class);
            flag = true;
        }

        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            // 日租
            if (ListUtil.isNotEmpty(changeCompareVO.getRentDayDetailedList())) {
                List<OutRentChangeDayDetailedVO> dailyOutRentList = beforeChangeVO.getRentDayDetailedList();
                Map<Long, OutRentChangeDayDetailedVO> beforeDailyMap = new HashMap<>();
                if (flag) {
                    beforeDailyMap = dailyOutRentList.stream().collect(Collectors.toMap(OutRentChangeDayDetailedVO::getId, Function.identity()));
                }else {
                    beforeDailyMap = dailyOutRentList.stream().collect(Collectors.toMap(OutRentChangeDayDetailedVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeDayDetailedVO vo : changeCompareVO.getRentDayDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeDayDetailedVO beforeVO = beforeDailyMap.get(vo.getSrcTblId());
                        vo.setBcDayFactoryCode(beforeVO.getDayFactoryCode());
                        vo.setBcDayRentPrice(beforeVO.getDayRentPrice());
                        vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getTax());
                        vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                        vo.setBcStopRentNotTaxPrice(beforeVO.getStopRentNotTaxPrice());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcTaxMny(beforeVO.getTaxMny());
                        vo.setBcRentDay(beforeVO.getRentDay());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());

                    }
                }

                changeCompareVO.setRentDayDetailedList(changeCompareVO.getRentDayDetailedList().stream().filter(daily -> StringUtils.isNotEmpty(daily.getChangeType())).collect(Collectors.toList()));
            }
            // 月租
            if (ListUtil.isNotEmpty(changeCompareVO.getRentMonthDetailedList())) {
                List<OutRentChangeMonthDetailedVO> monthOutRentList = beforeChangeVO.getRentMonthDetailedList();
                Map<Long, OutRentChangeMonthDetailedVO> beforeMonthMap = new HashMap<>();
                if (flag) {
                    beforeMonthMap = monthOutRentList.stream().collect(Collectors.toMap(OutRentChangeMonthDetailedVO::getId, Function.identity()));
                }else {
                    beforeMonthMap = monthOutRentList.stream().collect(Collectors.toMap(OutRentChangeMonthDetailedVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeMonthDetailedVO vo : changeCompareVO.getRentMonthDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeMonthDetailedVO beforeVO = beforeMonthMap.get(vo.getSrcTblId());

                        vo.setBcMonthFactoryCode(beforeVO.getMonthFactoryCode());
                        vo.setBcMonthRentPrice(beforeVO.getMonthRentPrice());
                        vo.setBcInsufficientMonthDayRentPrice(beforeVO.getInsufficientMonthDayRentPrice());
                        vo.setBcStopRentPrice(beforeVO.getStopRentPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getBcTax());
                        vo.setBcMonthRentNotTaxPrice(beforeVO.getMonthRentNotTaxPrice());
                        vo.setBcInsufficientMonthNotTaxRentPrice(beforeVO.getInsufficientMonthNotTaxRentPrice());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcEquipmentCode(beforeVO.getEquipmentCode());
                        vo.setBcDayTaxPrice(beforeVO.getDayTaxPrice());
                        vo.setBcTaxMny(beforeVO.getTaxMny());
                        vo.setBcNotTaxMonthPrice(beforeVO.getNotTaxMonthPrice());
                        vo.setBcDayRentNotTaxPrice(beforeVO.getDayRentNotTaxPrice());
                        vo.setBcNotTaxStopPrice(beforeVO.getNotTaxStopPrice());
                        vo.setBcRentMonth(beforeVO.getRentMonth());
                        vo.setBcRentDay(beforeVO.getRentDay());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentMonthDetailedList(changeCompareVO.getRentMonthDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 工程量
            if (ListUtil.isNotEmpty(changeCompareVO.getRentQuantitiesDetailedList())) {
                List<OutRentChangeQuantitiesVO> quantitiesOutRentList = beforeChangeVO.getRentQuantitiesDetailedList();
                Map<Long, OutRentChangeQuantitiesVO> beforeQuantitiesMap = new HashMap<>();
                if (flag) {
                    beforeQuantitiesMap = quantitiesOutRentList.stream().collect(Collectors.toMap(OutRentChangeQuantitiesVO::getId, Function.identity()));
                }else {
                    beforeQuantitiesMap = quantitiesOutRentList.stream().collect(Collectors.toMap(OutRentChangeQuantitiesVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeQuantitiesVO vo : changeCompareVO.getRentQuantitiesDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeQuantitiesVO beforeVO = beforeQuantitiesMap.get(vo.getSrcTblId());

                        vo.setBcQuantitiesFactoryCode(beforeVO.getQuantitiesFactoryCode());
                        vo.setBcQuantitiesNum(beforeVO.getQuantitiesNum());
                        vo.setBcQuantitiesPrice(beforeVO.getQuantitiesPrice());
                        vo.setBcRentNum(beforeVO.getRentNum());
                        vo.setBcTax(beforeVO.getTax());
                        vo.setBcPlanIntoDate(beforeVO.getPlanIntoDate());
                        vo.setBcPlanOutDate(beforeVO.getPlanOutDate());
                        vo.setBcProductionManufactor(beforeVO.getProductionManufactor());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setBcNotTaxQuantitiesPrice(beforeVO.getNotTaxQuantitiesPrice());
                        vo.setBcNotTaxQuantitiesMny(beforeVO.getNotTaxQuantitiesMny());
                        vo.setBcRentMny(beforeVO.getRentMny());
                        vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentQuantitiesDetailedList(changeCompareVO.getRentQuantitiesDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 其他
            if (ListUtil.isNotEmpty(changeCompareVO.getRentOtherDetailedList())) {
                List<OutRentChangeOtherDetailedVO> otherOutRentList = beforeChangeVO.getRentOtherDetailedList();
                Map<Long, OutRentChangeOtherDetailedVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeOtherDetailedVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeOtherDetailedVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeOtherDetailedVO vo : changeCompareVO.getRentOtherDetailedList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeOtherDetailedVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcPrice(beforeVO.getPrice());
                        vo.setBcNum(beforeVO.getNum());
                        vo.setBcTaxAmount(beforeVO.getTaxAmount());
                        vo.setBcNotTaxPrice(beforeVO.getNotTaxPrice());
                        vo.setBcNotTaxAmount(beforeVO.getNotTaxAmount());
                        vo.setBcMemo(beforeVO.getBcMemo());
                        vo.setBcTaxMoney(beforeVO.getTaxMoney());
                    }
                }

                changeCompareVO.setRentOtherDetailedList(changeCompareVO.getRentOtherDetailedList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }
            // 设置合同付款阶段
            if (ListUtil.isNotEmpty(changeCompareVO.getRentContractPaymentClauseList())) {
                List<OutRentChangeContractPaymentVO> otherOutRentList = beforeChangeVO.getRentContractPaymentClauseList();
                Map<Long, OutRentChangeContractPaymentVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractPaymentVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractPaymentVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeContractPaymentVO vo : changeCompareVO.getRentContractPaymentClauseList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeContractPaymentVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcPaymentContent(beforeVO.getPaymentContent());
                        vo.setBcPaymentRatio(beforeVO.getPaymentRatio());
                        vo.setBcMemo(beforeVO.getMemo());
                        vo.setChangeType("2");
                    }
                }

                changeCompareVO.setRentContractPaymentClauseList(changeCompareVO.getRentContractPaymentClauseList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }

            // 设置合同条款
            if (ListUtil.isNotEmpty(changeCompareVO.getRentContractClauseList())) {
                List<OutRentChangeContractClauseVO> otherOutRentList = beforeChangeVO.getRentContractClauseList();
                Map<Long, OutRentChangeContractClauseVO> beforeOtherMap = new HashMap<>();
                if (flag) {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractClauseVO::getId, Function.identity()));
                }else {
                    beforeOtherMap = otherOutRentList.stream().collect(Collectors.toMap(OutRentChangeContractClauseVO::getSrcTblId, Function.identity()));
                }

                for (OutRentChangeContractClauseVO vo : changeCompareVO.getRentContractClauseList()) {
                    if (StringUtils.isNotEmpty(vo.getChangeType()) && !vo.getChangeType().equals("新增项")) {
                        OutRentChangeContractClauseVO beforeVO = beforeOtherMap.get(vo.getSrcTblId());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcName(beforeVO.getName());
                        vo.setBcClauseContent(beforeVO.getClauseContent());
                        vo.setChangeType("2");
                    }
                }

                changeCompareVO.setRentContractClauseList(changeCompareVO.getRentContractClauseList().stream().filter(month -> StringUtils.isNotEmpty(month.getChangeType())).collect(Collectors.toList()));
            }


            //设置合同条款
//            List<OutRentChangeContractClauseVO> newClauses = new ArrayList<>();
//            Map<Long, OutRentChangeContractClauseVO> beforeClauseMap = new HashMap<>();
//            if (flag) {
//                beforeClauseMap = beforeChangeVO.getOutRentContractClauseList().stream().collect(Collectors.toMap(OutRentChangeContractClauseVO::getId, clause -> clause, (v1,v2) ->v2));
//            }else {
//                beforeClauseMap = beforeChangeVO.getOutRentContractClauseList().stream().collect(Collectors.toMap(OutRentChangeContractClauseVO::getSrcTblId, clause -> clause, (v1,v2) ->v2));
//            }
//            if(ListUtil.isNotEmpty(changeCompareVO.getOutRentContractClauseList())) {
//                OutRentChangeContractClauseVO beforeVo = null;
//                for (OutRentChangeContractClauseVO vo : changeCompareVO.getOutRentContractClauseList()) {
//                    if(vo.getSrcTblId() == null) {
//                        // 没有来源则说明为新增项
//                        vo.setChangeType("0");
//                        newClauses.add(vo);
//                    } else if(beforeClauseMap.containsKey(vo.getSrcTblId())) {
//                        beforeVo = beforeClauseMap.get(vo.getSrcTblId());
//                        if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
//                            // 参照变更
//                            vo.setBcName(beforeVo.getName());
//                            vo.setBcClauseContent(beforeVo.getClauseContent());
//                            vo.setChangeType("2");
//                            newClauses.add(vo);
//                        }else {
////                            newClauses.add(vo);
//                        }
//
//                        beforeClauseMap.remove(vo.getSrcTblId());
//                    }
//                }
//            }
//            if(MapUtils.isNotEmpty(beforeClauseMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforeClauseMap.values().forEach(c -> {
//                    c.setChangeType("1");
//                    newClauses.add(c);
//                });
//            }


//            // 设置合同付款阶段
//            List<OutRentChangeContractPaymentVO> newPayList = new ArrayList<>();
//            Map<Long, OutRentChangeContractPaymentVO> beforePayMap = new HashMap<>();
//            if (flag) {
//                beforePayMap = beforeChangeVO.getOutRentContractPaymentClauseList().stream().collect(Collectors.toMap(OutRentChangeContractPaymentVO::getId, item -> item, (v1, v2) -> v2));
//            }else {
//                beforePayMap = beforeChangeVO.getOutRentContractPaymentClauseList().stream().collect(Collectors.toMap(OutRentChangeContractPaymentVO::getSrcTblId, item -> item, (v1, v2) -> v2));
//            }
//            if (ListUtil.isNotEmpty(changeCompareVO.getOutRentContractPaymentClauseList())) {
//                OutRentChangeContractPaymentVO beforeVo = null;
//                for (OutRentChangeContractPaymentVO vo : changeCompareVO.getOutRentContractPaymentClauseList()) {
//
//                    if (vo.getSrcTblId() == null) {
//                        //没有来源则说明为新增项
//                        vo.setChangeType("0");
//                        newPayList.add(vo);
//                    } else if (beforePayMap.containsKey(vo.getSrcTblId())) {
//                        beforeVo = beforePayMap.get(vo.getSrcTblId());
//                        if (!beforeVo.getName().equals(vo.getName()) || !beforeVo.getPaymentRatio().equals(vo.getPaymentRatio())) {
//                            vo.setBcName(beforeVo.getName());
//                            vo.setBcPaymentContent(beforeVo.getPaymentContent());
//                            vo.setBcPaymentRatio(beforeVo.getPaymentRatio());
//                            vo.setBcMemo(beforeVo.getMemo());
//                            vo.setChangeType("2");
//                            newPayList.add(vo);
//                        }
//                        beforePayMap.remove(vo.getSrcTblId());
//                    }
//                }
//
//            }
//            if(MapUtils.isNotEmpty(beforePayMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforePayMap.values().forEach(c -> {
//                    c.setChangeType("1");
//                    newPayList.add(c);
//                });
//            }
//            changeCompareVO.setOutRentContractPaymentClauseList(newPayList);


//            changeCompareVO.setOutRentContractClauseList(newClauses);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }

        return returnMap;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(OutRentContractChangeVO changeVO) {
        logger.info("proequipmentcorp---OutRentContractChangeServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(changeVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<OutRentChangeDayDetailedVO> dayDetailList = changeVO.getRentDayDetailedList();
        List<OutRentChangeMonthDetailedVO> monthDetailList = changeVO.getRentMonthDetailedList();
        List<OutRentChangeQuantitiesVO> quantitiesDetailList = changeVO.getRentQuantitiesDetailedList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_CON_PRICE, changeVO.getOrgId());
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("设备合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("设备合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.设备租赁价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.设备租赁价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (OutRentChangeDayDetailedVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice()==null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (OutRentChangeMonthDetailedVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice()==null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (OutRentChangeQuantitiesVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice()==null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (OutRentChangeDayDetailedVO  detailVO: dayDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice()==null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (OutRentChangeMonthDetailedVO  detailVO: monthDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice()==null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (OutRentChangeQuantitiesVO  detailVO: quantitiesDetailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("设备租赁：{}--高价：{}---低价：{}",detailVO.getName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice()==null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }
}
