package com.ejianc.business.proequipmentcorpout.outStore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.constants.OutStatusTypeEnum;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.mapper.OutStoreMapper;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.proequipmentcorpout.util.PushSupUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * out-出库单
 * 
 * @author generator
 * 
 */
@Service("outStoreService")
public class OutStoreServiceImpl extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    @Autowired
    private OutStoreMapper baseMapper;
    @Autowired
    private PushSupUtil pushSupUtil;
    private static final String BILL_TYPE = OutStatusTypeEnum.租出出库单.getCode();
    private static final String BILL_NAME = OutStatusTypeEnum.租出出库单.getName();
    
    @Override
    public void validateTime(OutStoreVO saveOrUpdateVO) {
            Date lastDate = baseMapper.getContractLastDate(saveOrUpdateVO.getContractId(),saveOrUpdateVO.getId());
            if (lastDate != null && lastDate.compareTo(saveOrUpdateVO.getRentDate()) > 0){
                throw new BusinessException("计租日期小于当前单据同合同下最大计租日期【" + DateUtil.formatDate(saveOrUpdateVO.getRentDate()) + "】，不允许保存!");
            }
        //大于等于  租出、启用、停用....等关键单据的日期；
//        Date lastAllBillDate = baseMapper.getLastDate(saveOrUpdateVO.getContractId());
//        if (lastAllBillDate != null && lastAllBillDate.compareTo(saveOrUpdateVO.getRentDate()) > 0){
//            throw new BusinessException("计租日期小于下游单据最大计租日期【" + DateUtil.formatDate(saveOrUpdateVO.getRentDate()) + "】，不允许保存!");
//        }
//        子表计租日期：必填，默认主表计租日期，可修改，格式：yyyy-mm-dd。大于最新一期租金计算日期（含未结算的租金计算单）。

    }

    @Override
    public String updateBillSupSignSync(Map<String,String> map) {
        String billId = map.get("billId");
        OutStoreEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutStoreEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }
}
