package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetRecordEntity;
import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetRecordlMapper;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetRecordVO;
import com.ejianc.business.proequipmentcorppur.decorator.IAssetRecord;
import com.ejianc.business.proequipmentcorppur.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 固定资产流转记录表
 *
 * @author generator
 */
@Service("assetRecordService")
public class AssetRecordServiceImpl extends BaseServiceImpl<AssetRecordlMapper, AssetRecordEntity> implements IAssetRecordService {


    /**
     * @param assetRecord
     * @description: 保存流转记录
     * @return: boolean
     * @author songlx
     * @date: 2022/6/25
     */
    @Override
    public boolean saveRecord(IAssetRecord assetRecord) {
        List<AssetRecordVO> list = assetRecord.toRecordList();
        if (CollectionUtils.isNotEmpty(list)) {
            List<AssetRecordEntity> assetRecordEntities = BeanMapper.mapList(list, AssetRecordEntity.class);
            return this.saveBatch(assetRecordEntities);
        }
        return false;
    }

    /**
     * @param sourceId 业务单据主键
     * @description: 删除流转记录
     * @return: boolean
     * @author songlx
     * @date: 2022/6/25
     */
    @Override
    public boolean delRecord(Long sourceId) {
        if (sourceId != null) {
            LambdaQueryWrapper<AssetRecordEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(AssetRecordEntity::getSourceId, sourceId);
            return this.remove(lambda);
        }
        return false;
    }
}
