/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.proxy.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractDetailEntity;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.mapper.ProxyContractMapper;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;
import com.ejianc.business.proequipmentcorpout.proxy.vo.ProxyContractVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="proxyContractService")
public class ProxyContractServiceImpl
extends BaseServiceImpl<ProxyContractMapper, ProxyContractEntity>
implements IProxyContractService {
    private static final String BILL_CODE = "PROXY_CONTRACT ";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;

    @Override
    public ProxyContractVO saveOrUpdate(ProxyContractVO saveOrUpdateVO) {
        List equipmentIdList;
        ProxyContractEntity entity = (ProxyContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProxyContractEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(equipmentIdList = entity.getProxyContractDetailList().stream().filter(e -> null != e.getequipmentId()).map(ProxyContractDetailEntity::getequipmentId).collect(Collectors.toList())) && equipmentIdList.size() > 0) {
            CommonResponse codeCommonResponse = this.equipmentApi.queryEquipmentItemByIds(equipmentIdList);
            if (!codeCommonResponse.isSuccess() || ((List)codeCommonResponse.getData()).size() <= 0) {
                throw new BusinessException("\u6839\u636e\u8bbe\u5907id\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b50\u8868\u8bbe\u5907\uff01");
            }
            List equipmentList = (List)codeCommonResponse.getData();
            Map<Long, EquipmentVO> equipmentMap = equipmentList.stream().filter(map -> map.getId() != null).collect(Collectors.toMap(e -> e.getId(), e -> e));
            for (ProxyContractDetailEntity proxyContractDetailEntity : entity.getProxyContractDetailList()) {
                if (!equipmentMap.containsKey(proxyContractDetailEntity.getequipmentId())) continue;
                proxyContractDetailEntity.setJobContent(equipmentMap.get(proxyContractDetailEntity.getequipmentId()).getJobContent());
                proxyContractDetailEntity.setDetailMeasurementRules(equipmentMap.get(proxyContractDetailEntity.getequipmentId()).getDetailMeasurementRules());
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (ProxyContractVO)BeanMapper.map((Object)((Object)entity), ProxyContractVO.class);
    }
}

