/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentDayDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentPlanService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentMonthDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentQuantitiesDetailedService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentPlanEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentEquipmentPlan")
public class RentEquipmentPlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentEquipmentPlanService planService;
    @Autowired
    private IRentDayDetailedService dayDetailedService;
    @Autowired
    private IRentMonthDetailedService monthDetailedService;
    @Autowired
    private IRentQuantitiesDetailedService quantitiesDetailedService;
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u4e86\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        RentEquipmentPlanEntity planEntity = (RentEquipmentPlanEntity)((Object)this.planService.selectById(billId));
        if (CollectionUtils.isNotEmpty(planEntity.getRentEquipmentPlanSubList())) {
            List<Long> batchIds = planEntity.getRentEquipmentPlanSubList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<RentDayDetailedEntity> dayList = this.queryRentDayList(batchIds);
            if (CollectionUtils.isNotEmpty(dayList)) {
                return CommonResponse.error((String)"\u6e05\u5355\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
            }
            List<RentMonthDetailedEntity> monthList = this.queryRentMonthList(batchIds);
            if (CollectionUtils.isNotEmpty(monthList)) {
                return CommonResponse.error((String)"\u6e05\u5355\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
            }
            List<RentQuantitiesDetailedEntity> quantitiesList = this.queryRentQuantitiesList(batchIds);
            if (CollectionUtils.isNotEmpty(quantitiesList)) {
                return CommonResponse.error((String)"\u6e05\u5355\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
            }
            if (RentPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(planEntity.getBiddingState())) {
                return CommonResponse.success();
            }
            CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
            }
            for (Long i : batchIds) {
                CommonResponse resps = this.billTypeApi.checkQuote(billTypeCode, i);
                if (resps.isSuccess()) continue;
                return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("resp\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002{}{}", (Object)billTypeCode, (Object)billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + resp.isSuccess() + "----" + resp.getMsg());
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public List<RentDayDetailedEntity> queryRentDayList(List<Long> batchIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", batchIds);
        query.eq((Object)"dr", (Object)0);
        return this.dayDetailedService.list((Wrapper)query);
    }

    public List<RentMonthDetailedEntity> queryRentMonthList(List<Long> batchIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", batchIds);
        query.eq((Object)"dr", (Object)0);
        return this.monthDetailedService.list((Wrapper)query);
    }

    public List<RentQuantitiesDetailedEntity> queryRentQuantitiesList(List<Long> batchIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", batchIds);
        query.eq((Object)"dr", (Object)0);
        return this.quantitiesDetailedService.list((Wrapper)query);
    }
}

