/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetHandleDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetHandleEntity;
import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetHandleMapper;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetHandleService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetHandleVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetHandleService")
public class AssetHandleServiceImpl
extends BaseServiceImpl<AssetHandleMapper, AssetHandleEntity>
implements IAssetHandleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;

    @Override
    public CommonResponse<AssetHandleVO> pushCost(AssetHandleVO handleVO) {
        AssetHandleEntity handleEntity = (AssetHandleEntity)((Object)((AssetHandleMapper)this.baseMapper).selectById(handleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)handleVO.getHandleDetailList())) {
            List handleDetailEntities = BeanMapper.mapList((Iterable)handleVO.getHandleDetailList(), AssetHandleDetailEntity.class);
            handleEntity.setHandleDetailList(handleDetailEntities);
        }
        super.saveOrUpdate((Object)handleEntity, false);
        this.costPush(handleEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)handleVO, AssetHandleVO.class));
    }

    @Override
    public void costPush(AssetHandleEntity handleEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AssetHandleDetailEntity> allotOutDetailEntities = handleEntity.getHandleDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AssetHandleDetailEntity entity : allotOutDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                this.logger.info("getSubjectId" + entity.getSubjectId());
                this.logger.info("getWbsId" + entity.getWbsId());
                break;
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        this.logger.info("newRelationFlag" + newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{handleEntity.getId()});
        updateWrapper.set(AssetHandleEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = handleEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.logger.info("\u4e4b\u524d\u5df2\u5173\u8054" + newRelationFlag);
                this.saveCost(handleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u8c03\u62e8\u51fa\u5e93Id---{}", (Object)handleEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(handleEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.logger.info("\u4e4b\u524d\u672a\u5173\u8054" + newRelationFlag);
            this.saveCost(handleEntity);
        }
    }

    private void saveCost(AssetHandleEntity handleEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AssetHandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleDetailList)) {
            for (AssetHandleDetailEntity entity : handleDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleDiffTaxMny());
                costDetailVO.setHappenMny(entity.getHandleTaxMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_HANDLE");
                costDetailVO.setSourceTabType("ASSET_HANDLE_SUB");
                costDetailVO.setProjectId(handleEntity.getProjectId());
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u5904\u7f6e.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/handle/handleCard?id=" + handleEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

