/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.temporary.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryChangeOtherEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractRecordEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryEquipmentChangeEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryEquipmentDetailedEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryOtherEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryPaymentClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.mapper.TemporaryContractChangeMapper;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryClauseService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractChangeService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractRecordService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryPaymentClauseService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryContractChangeVO;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="temporaryContractChangeService")
public class TemporaryContractChangeServiceImpl
extends BaseServiceImpl<TemporaryContractChangeMapper, TemporaryContractChangeEntity>
implements ITemporaryContractChangeService {
    @Autowired
    private ITemporaryContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryContractRecordService recordContractService;
    @Autowired
    private ITemporaryClauseService contractClauseService;
    @Autowired
    private ITemporaryPaymentClauseService contractPaymentService;
    @Autowired
    private ITemporaryContractChangeService changeService;

    @Override
    public TemporaryContractChangeVO saveOrUpdates(TemporaryContractChangeVO temporaryContractChangeVO) {
        TemporaryContractChangeEntity changeEntity;
        TemporaryContractChangeEntity entity;
        TemporaryContractEntity temporaryContractEntity = (TemporaryContractEntity)((Object)this.contractService.getById(temporaryContractChangeVO.getContractId()));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)temporaryContractChangeVO.getContractId()));
        List contractList = this.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)contractList) && !(entity = (TemporaryContractChangeEntity)((Object)contractList.get(0))).getId().equals(temporaryContractChangeVO.getId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (CollectionUtils.isNotEmpty((Collection)temporaryContractChangeVO.getAttachIds()) && null != temporaryContractEntity.getContractFileId()) {
            temporaryContractChangeVO.getAttachIds().remove(temporaryContractChangeVO.getContractFileId());
        }
        if ((changeEntity = (TemporaryContractChangeEntity)((Object)BeanMapper.map((Object)temporaryContractChangeVO, TemporaryContractChangeEntity.class))).getId() == null) {
            changeEntity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setCode(changeEntity.getCode() + "10" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setCode(changeEntity.getCode() + "1" + changeEntity.getChangeVersion());
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveOrUpdateContract(changeEntity);
        TemporaryContractChangeVO changeVO = (TemporaryContractChangeVO)BeanMapper.map((Object)((Object)changeEntity), TemporaryContractChangeVO.class);
        return changeVO;
    }

    public void saveOrUpdateContract(TemporaryContractChangeEntity changeEntity) {
        TemporaryContractEntity temporaryContractEntity = (TemporaryContractEntity)((Object)this.contractService.getById(changeEntity.getContractId()));
        temporaryContractEntity.setChangeCode(changeEntity.getCode());
        temporaryContractEntity.setChangeDate(new Date());
        temporaryContractEntity.setChangeId(changeEntity.getId());
        temporaryContractEntity.setChangeStatus(2);
        temporaryContractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        temporaryContractEntity.setChangeFile(changeEntity.getChangeFile());
        temporaryContractEntity.setBeforeChangeMny(temporaryContractEntity.getContractMny());
        temporaryContractEntity.setAfterChangeMny(changeEntity.getChangeMny());
        temporaryContractEntity.setChangingMny((changeEntity.getChangeMny() != null ? changeEntity.getChangeMny() : BigDecimal.ZERO).subtract(changeEntity.getChangeTax() != null ? changeEntity.getChangeTax() : BigDecimal.ZERO));
        temporaryContractEntity.setChangeContractSignatureStatus(Integer.valueOf(changeEntity.getSignatureState()));
        temporaryContractEntity.setChangeFile(changeEntity.getChangeFile());
        temporaryContractEntity.setChangeVersion(changeEntity.getChangeVersion());
        this.contractService.saveOrUpdate((Object)temporaryContractEntity);
    }

    @Override
    public TemporaryContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(contractId));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            TemporaryContractChangeEntity change = (TemporaryContractChangeEntity)((Object)this.selectById(contractEntity.getChangeId()));
            TemporaryContractChangeVO vo = (TemporaryContractChangeVO)BeanMapper.map((Object)((Object)change), TemporaryContractChangeVO.class);
            return vo;
        }
        TemporaryContractChangeVO changeVO = (TemporaryContractChangeVO)BeanMapper.map((Object)((Object)contractEntity), TemporaryContractChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        this.resetSub(changeVO);
        return changeVO;
    }

    public void resetSub(TemporaryContractChangeVO changeVO) {
        List paymentList;
        List contractList;
        List otherList;
        List equipmentList = changeVO.getTemporaryEquipmentDetailedList();
        if (CollectionUtils.isNotEmpty((Collection)equipmentList)) {
            equipmentList.forEach(equipment -> {
                equipment.setSrcTblId(equipment.getId());
                equipment.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(otherList = changeVO.getTemporaryOtherList()))) {
            otherList.forEach(monthDetailed -> {
                monthDetailed.setId(null);
                monthDetailed.setChangeId(monthDetailed.getId());
                monthDetailed.setSrcTblId(monthDetailed.getId());
                monthDetailed.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractList = changeVO.getTemporaryClauseList()))) {
            contractList.forEach(item -> item.setRowState("add"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(paymentList = changeVO.getTemporaryPaymentClauseList()))) {
            paymentList.forEach(item -> item.setRowState("add"));
        }
    }

    @Override
    public TemporaryContractChangeVO queryDetailRecord(Long id) {
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(id));
        TemporaryContractChangeVO changeVO = new TemporaryContractChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("contract_performance_state", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = TemporaryContractChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), TemporaryContractChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureState()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(TemporaryContractChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(TemporaryContractChangeEntity::getSignatureState, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(TemporaryContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        List<TemporaryOtherEntity> contractOtherList;
        List<TemporaryEquipmentDetailedEntity> contractDayList;
        Object resp = null;
        TemporaryContractChangeEntity changeEntity = (TemporaryContractChangeEntity)((Object)this.selectById(changeBillId));
        if (commitState.booleanValue()) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        TemporaryContractEntity contract = (TemporaryContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        TemporaryContractVO contractVO = (TemporaryContractVO)BeanMapper.map((Object)((Object)contract), TemporaryContractVO.class);
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordContractService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        TemporaryContractRecordEntity recordEntity = (TemporaryContractRecordEntity)((Object)BeanMapper.map((Object)contractVO, TemporaryContractRecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO.getTemporaryEquipmentDetailedList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getTemporaryEquipmentDetailedList()));
        if (CollectionUtils.isNotEmpty(recordEntity.getTemporaryEquipmentDetailedList())) {
            recordEntity.getTemporaryEquipmentDetailedList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getTemporaryOtherList())) {
            recordEntity.getTemporaryOtherList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getTemporaryClauseList())) {
            recordEntity.getTemporaryClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getTemporaryPaymentClauseList())) {
            recordEntity.getTemporaryPaymentClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getTemporaryEquipmentDetailedList()));
        this.recordContractService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u539f\u5408\u540c\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString(resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)BeanMapper.map((Object)contractVO, TemporaryContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setPartyId(changeEntity.getPartyId());
        contractEntity.setPartyName(changeEntity.getPartyName());
        contractEntity.setPartyPhone(changeEntity.getPartyPhone());
        contractEntity.setPartyHandleUser(changeEntity.getPartyHandleUser());
        contractEntity.setPartyHandleUserName(changeEntity.getPartyHandleUserName());
        contractEntity.setPartyUser(changeEntity.getPartyUser());
        contractEntity.setPartyUserName(changeEntity.getPartyUserName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierHandleUser(changeEntity.getSupplierHandleUser());
        contractEntity.setSupplierHandleUserName(changeEntity.getSupplierHandleUserName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplementCode(changeEntity.getSupplementCode());
        contractEntity.setSignedDate(changeEntity.getSignedDate());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFile(changeEntity.getContractFile());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        changeEntity.setSignatureState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        this.changeService.saveOrUpdate((Object)changeEntity, false);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + contractEntity.getChangeStatus());
        TemporaryContractEntity contractChangeEntity = (TemporaryContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), TemporaryContractEntity.class));
        List<TemporaryEquipmentChangeEntity> equipmentDetailedList = changeEntity.getTemporaryEquipmentDetailedList();
        HashMap changDayIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(equipmentDetailedList)) {
            equipmentDetailedList.forEach(changEuipmentDetailed -> changDayIdMap.put(changEuipmentDetailed.getId(), changEuipmentDetailed.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractDayList = contractChangeEntity.getTemporaryEquipmentDetailedList())) {
            Long contractBid = null;
            for (TemporaryEquipmentDetailedEntity contractDetailEntity : contractDayList) {
                contractBid = (Long)changDayIdMap.get(contractDetailEntity.getId());
                contractDetailEntity.setPid(changeEntity.getContractId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
            }
        }
        contractEntity.setTemporaryEquipmentDetailedList(contractDayList);
        List<TemporaryChangeOtherEntity> changeOtherList = changeEntity.getTemporaryOtherList();
        HashMap changOtherIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherList)) {
            changeOtherList.forEach(changeOtherCostEntity -> changOtherIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherList = contractChangeEntity.getTemporaryOtherList())) {
            Long contractBid = null;
            for (TemporaryOtherEntity contractOtherCostEntity : contractOtherList) {
                contractBid = (Long)changOtherIdMap.get(contractOtherCostEntity.getId());
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setPid(contractEntity.getId());
            }
        }
        contractEntity.setTemporaryOtherList(contractOtherList);
        List<TemporaryClauseEntity> contractClauseList = contractEntity.getTemporaryClauseList();
        List<TemporaryClauseEntity> contractChangeClauseList = contractChangeEntity.getTemporaryClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setTemporaryClauseList(contractChangeClauseList);
        List<TemporaryPaymentClauseEntity> contractPayList = contractEntity.getTemporaryPaymentClauseList();
        List<TemporaryPaymentClauseEntity> pList = contractChangeEntity.getTemporaryPaymentClauseList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setTemporaryPaymentClauseList(pList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> deleteById(Long id) {
        TemporaryContractChangeEntity entity = (TemporaryContractChangeEntity)((Object)super.selectById((Serializable)id));
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)id);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() != null ? contractEntity.getChangeVersion() - 1 : 0);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFile(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void queryBpm(Long billId) {
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(billId));
        if (contractEntity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractEntity.getDraftType())) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                contractEntity.setSignatureState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setEffectiveDate(new Date());
            } else if (null == contractEntity.getContractFileId()) {
                // empty if block
            }
        }
        contractEntity.setCommitDate(new Date());
        contractEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
        contractEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        this.contractService.saveOrUpdate((Object)contractEntity);
    }
}

