package com.ejianc.business.proequipmentcorpout.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.contract.bean.*;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.*;
import com.ejianc.business.proequipmentcorpout.contract.vo.*;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.api.ITenderSubApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRentContract")
public class OutRentContractController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITenderSubApi tenderApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private final String ENTITY_REF_CODE = "rent-contract";

    private static final String BILL_CODE = "RENT_CONTRACT";//此处需要根据实际修改

    @Autowired
    private IOutRentContractService service;
//    @Autowired
//    private IOutRentCheckBeforeService rentCheckBeforeService;
    @Autowired
    private IOutRentContractChangeService rentContractChangeService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IOutRentDayDetailedService rentDayDetailedService;//日租明细
    @Autowired
    private IOutRentMonthDetailedService rentMonthDetailedService;//月租明细
    @Autowired
    private IOutRentQuantitiesDetailedService rentQuantitiesDetailedService;//工程量租明细
    @Autowired
    private IOutRentOtherDetailedService rentOtherDetailedService;//其他费用明细
    @Autowired
    private IOutRentContractAsyncService outRentContractAsyncService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRentContractVO> saveOrUpdate(@RequestBody OutRentContractVO saveOrUpdateVO,HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return service.saveOrUpdate(saveOrUpdateVO,authority,false);
    }
    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
//        return service.pushTargetCost(id);
        return CommonResponse.success("设备公司租入租赁合同没有目标成本");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentContractVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            //目标成本推送
//            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (OutRentContractVO contractVO : vos) {
                OutRentContractEntity contractEntity = service.selectById(contractVO.getId());
//                String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractEntity.getId();
//                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, OutRentContractVO.class),linkUrl);
//                totalExecutionVOList.add(executionVO.getTotalVO());
                //回写定标
                if (contractEntity.getId() != null && contractEntity.getTargetResultId() != null) {
                    service.updateTargetResult(contractEntity, 1);
                }
                logger.info("租出合同租赁方式：{}", contractEntity.getRentHarborType());
                logger.info("OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_IN：{}", OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_IN);
                logger.info("contractEntity.getProxyContractId()：{}", contractEntity.getProxyContractId());
                if (OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_IN == contractEntity.getRentHarborType()
                        && contractEntity.getProxyContractId() != null) {
                    logger.info("11");
                    service.updateProxyContract(contractEntity.getProxyContractId(), 1);
                }
            }

//            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
//            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
//            }

        }
        service.removeByIds(vos.stream().map(OutRentContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        fuzzyFields.add("partyHandleUserName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("org_id",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
       /* if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);*/
        IPage<OutRentContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OutRentContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        /**   数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
//        Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).
//                getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("org_id",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        param.getParams().put("outOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        Map<String, Object> beans = new HashMap<>();
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<OutRentContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<OutRentContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(vo -> {
                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getContractPerformanceState().toString())) {
                        vo.setContractPerformanceState(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        vo.setContractPerformanceState(PerformanceStatusEnum.getEnumByCode(vo.getContractPerformanceState().toString()).getDescription());
                    }

                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getSignatureState())) {
                        vo.setSignatureState(SignatureStatusEnum.未签章.getDescription());
                    } else {
                        vo.setSignatureState(SignatureStatusEnum.getEnumByCode(vo.getSignatureState()).getDescription());
                    }

                    vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("outRentContract-export.xlsx", beans, response);
    }

    @GetMapping(value = "/refOutRentContract")
    @ResponseBody
    public CommonResponse<IPage<ContractPoolVO>> refOutRentContract(@RequestParam("pageNumber") Integer pageNumber,
                                                                    @RequestParam("pageSize") Integer pageSize,
                                                                    String searchText,
                                                                    String searchObject,
                                                                    String condition,
                                                                    String relyCondition) throws Exception {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("code", "name", "projectName", "partyName", "supplierName"));


        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            JSONObject conditionJson = JSONObject.parseObject(condition);
            // 根据项目ID查询
            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            String rentType = conditionJson.getString("rentType");
            if(StringUtils.isBlank(projectId) && StringUtils.isBlank(orgId) && StringUtils.isBlank(orgType)) {
                return CommonResponse.error("查询失败，缺少查询参数projectId或组织过滤参数-orgId,orgType！");
            }

            if (StringUtils.isNotBlank(projectId)){
                logger.info("condition中projectId：{}", projectId);
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.valueOf(projectId)));
            } else {
                if(StringUtils.isBlank(orgId)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgId！");
                }
                if(StringUtils.isBlank(orgType)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgType！");
                }
                //查询本下范围内日的合同
                if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    //按项目部过滤
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, Long.valueOf(orgId)));
                } else {
                    //按组织过滤
                    CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if(!orgResp.isSuccess()) {
                        logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                        return CommonResponse.error("查询失败，获取组织信息失败！");
                    }
                    param.getParams().put("orgId", new Parameter(QueryParam.IN,
                            orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }

            // 租赁方式
            if (StringUtils.isNotBlank(rentType)) {
                param.getParams().put("rentHarborType", new Parameter(QueryParam.EQ, rentType));
            }

            // 根据合同履约状态查询
            String performanceStatusParam = conditionJson.getString("performanceStatus");
            if(StringUtils.isNotBlank(performanceStatusParam)) {
                param.getParams().put("contractPerformanceState", new Parameter(QueryParam.IN, performanceStatusParam.split(",")));
            } else {
                param.getParams().put("contractPerformanceState", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
            }
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        }

        IPage<OutRentContractEntity> page = service.queryPage(param,false);
        List<ContractPoolVO> contractLists = new ArrayList<>();
        ContractPoolVO tmp = null;
        if(CollectionUtils.isNotEmpty(page.getRecords())) {
            for(OutRentContractEntity c : page.getRecords()) {
                tmp = BeanConvertorUtil.convert(BeanMapper.map(c, OutRentContractVO.class), ContractPoolVO.class);
                tmp.setSourceType(ContractTypeEnum.设备公司设备租出合同.getTypeCode());
                tmp.setSourceTypeName(ContractTypeEnum.设备公司设备租出合同.getTypeName());
                contractLists.add(tmp);
            }
        }
        IPage<ContractPoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(contractLists);

        return CommonResponse.success(pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentContractVO>> refRentContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("contractPerformanceState", new Parameter(QueryParam.EQ, "2"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }

        Long projectId = null;
        Long orgId = null;
        Integer rentHarborType = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
            rentHarborType = _con.getInteger("rentHarborType");
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
//        if (rentHarborType == null) {
//            throw new BusinessException("租赁方式不能为空！");
//        }
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId)
                    .getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            param.getParams().put("outOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        }
        if (rentHarborType != null) {
            param.getParams().put("rentHarborType", new Parameter(QueryParam.EQ, rentHarborType));
        }
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId)
//                .getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);

        // 获取合同归档控制参数
        String valueData = service.getContractFilingCode();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            // 控制参数0：不控制
            // 控制参数1：部分控制，需要传入参数filingType并且值=1，查询已归档合同
            if ("1".equals(valueData)) {
                // 如果传入查询条件中有filingType参数，并且参数值=1，则查询已归档的合同参照
                if (_con.containsKey("filingType") && "1".equals(_con.getString("filingType"))) {
                    param.getParams()
                            .put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
                }
            }
            // 控制参数2：合同未归档限制全部业务，只查询已归档合同
            else if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }
        else {
            if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }
        IPage<OutRentContractEntity> page = service.queryPage(param,false);
        IPage<OutRentContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentContractVO> voList = BeanMapper.mapList(page.getRecords(), OutRentContractVO.class);
        if (CollectionUtils.isNotEmpty(voList)) {
            for (OutRentContractVO vo : voList) {
                vo.setRentHarborTypeName(OutRentConstants.getOutContractRentHarborTypeMap(vo.getRentHarborType()));
            }
        }
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 补充协议
     * @return
     */
     @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
     @ResponseBody
     public CommonResponse<OutRentContractVO> saveOrUpdateSupplement(@RequestBody OutRentContractVO OutRentContractVO, HttpServletRequest req){
         if (OutRentContractVO.getMainContractId() == null) {
             return CommonResponse.error("保存失败，主合同信息为空！");
         }
         String authority = req.getHeader("authority");
         OutRentContractVO vo =service.saveOrUpdateSupplement(OutRentContractVO,authority);
         return CommonResponse.success("保存成功",vo);
     }
    /**
     *
     * @return
     */
     @RequestMapping(value = "/updateContract", method = RequestMethod.GET)
     @ResponseBody
     public CommonResponse<OutRentContractVO> updateContract(){
         String s ="567266021388451898,567268093148135439,568013122045083682,568015335932952669,568373325273890852,568375174412501068,568382439739752524,568385701528338455,568387464750825535,568390102187901012,568391150323499097,568399777797111902,568446820783620134,568458653338828873,568460486820102239,568461300997423160,568462913203994692,568464873323888736,568465871354331171,568466737016733707,568467681741766741,568469048673828890,568469806626504749,568470954875944998,568761557476048988,568801254365593676,568805433700122688,568831024637804572,568844426219225121,569106882380300326,569111737501089853,569121279815319561,569545615197995061,569546961527635976,569548461075202140,569549410237808733,569557806982758467,569560431589457976,569850928962863185,569851746831171614,572384553180729389,573065421977161815,1519211246524104706,1519317550792572930,1519319308713459714,1519321190655721474,1520223664933257217,1520228207783919617,1520231010019393537,1520285716301299713,1520289874995658754,1520291134058610689,1522460613341429761,567023290854539336,567028014022524986";
         List <String> list1 = Arrays.asList (s.split (","));
         for (String ss : list1){
             Long id = Long.parseLong (ss);
             OutRentContractEntity OutRentContractEntity = service.selectById(id);
             OutRentContractVO map = BeanMapper.map(OutRentContractEntity, OutRentContractVO.class);
             service.pushContract(map);
         }


         return CommonResponse.success("保存成功");
     }
    /**
     *
     * @return
     */
    @RequestMapping(value = "/pushContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentContractVO> pushContract(@RequestParam Long id){

        OutRentContractEntity OutRentContractEntity = service.selectById(id);
        OutRentContractVO map = BeanMapper.map(OutRentContractEntity, OutRentContractVO.class);
        service.pushContract(map);
        return CommonResponse.success("同步合同池成功");
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentContractVO> addConvertByConId(Long contractId) {
        OutRentContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            boolean filingFlag = service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error("合同未归档，不允许新增补充协议！");
            }
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }
    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        OutRentContractEntity OutRentContractEntity = service.selectById(id);
        if (OutRentContractEntity != null){
            OutRentContractEntity.setContractPerformanceState(SignatureStatusEnum.已签章.getCode());
            OutRentContractEntity.setSignatureState(PerformanceStatusEnum.履约中.getCode());
            OutRentContractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(OutRentContractEntity);
        }
        return CommonResponse.success();
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentContractVO> querySupplementRecord(Long id) {
        OutRentContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description 参照
     * @Return (合同子表设备数据)
     */
    @RequestMapping(value = "/refRentContractEquipmentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentContractEquipmentAllVO>> refRentContractEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                             String condition,
                                                                                             String searchObject,
                                                                                             String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        /** 租户隔离 */
        Long contractId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId =_con.getLong("contractId");
            if (contractId ==null){
                throw new BusinessException("合同id不能必须传！");
            }
        }
        Map<String, Object> param = new HashMap<>();
        if(contractId != null){
            param.put("contractId",contractId);
        }
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());

        if (queryParam.getOrderMap().get("createTime") != null){
            param.put("createTime", queryParam.getOrderMap().get("createTime"));
        }
        if(param.get("pageIndex")!=null){
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if(StringUtils.isNotBlank(queryParam.getSearchText())){
            param.put("searchText", queryParam.getSearchText());
        }
        IPage<OutRentContractEquipmentAllVO> page = service.queryEquipmentSubList(param);
        IPage<OutRentContractEquipmentAllVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //进场验收自制用//
        List<OutRentContractEquipmentAllVO> OutRentContractEquipmentAllVOS = BeanMapper.mapList(page.getRecords(), OutRentContractEquipmentAllVO.class);
//        List<OutRentCheckBeforeDetailVO> OutRentCheckBeforeDetailVOS = rentCheckBeforeService.queryDetailList(contractId);
//        if(CollectionUtils.isNotEmpty(OutRentCheckBeforeDetailVOS)){
//            Map<String, OutRentCheckBeforeDetailVO> map = OutRentCheckBeforeDetailVOS.stream().collect(Collectors.toMap(x->x.getEquipmentId() + "|" + x.getFactoryCode(), x->x));
//            if(CollectionUtils.isNotEmpty(OutRentCheckBeforeDetailVOS)){
//                for (OutRentContractEquipmentAllVO allVO : OutRentContractEquipmentAllVOS) {
//                    String key =  allVO.getEquipmentId()+ "|" + allVO.getFactoryCode();
//                    if(map.containsKey(key)){
//                        allVO.setCheckBeforeId(map.get(key).getCheckBeforeId());
//                        allVO.setCheckBeforeName(map.get(key).getCheckBeforeName());
//                    }
//                }
//            }
//        }
        pageData.setRecords(OutRentContractEquipmentAllVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description queryList queryListAll
     *  查询已生效的合同
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRentContractVO>> queryListAll(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<OutRentContractEntity> page = service.queryPage(param,false);
        IPage<OutRentContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
//        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(ENTITY_REF_CODE);
//        if(!billTypeResp.isSuccess()) {
//            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", ENTITY_REF_CODE, billTypeResp.getMsg());
//            return CommonResponse.error("查询元数据信息失败");
//        }

        OutRentContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractType());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractType(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", OutRentConstants.BILL_TYPE_OUT_CONTRACT);
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }
    @ApiOperation("日租明细参照")
    @RequestMapping(value = "/refRentContractDayDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentDayDetailedVO>> refRentContractDayDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                String condition,
                                                                                String searchObject,
                                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("dayFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("pid", new Parameter(QueryParam.EQ, contractId));
            }
        }
        IPage<OutRentDayDetailedEntity> page = rentDayDetailedService.queryPage(param, false);
        IPage<OutRentDayDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentDayDetailedVO> list = BeanMapper.mapList(page.getRecords(), OutRentDayDetailedVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            for (OutRentDayDetailedVO vo : list) {
                vo.setMeterRentTypeName("日租");
            }
        }
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    @ApiOperation("月租明细参照")
    @RequestMapping(value = "/refRentContractMonthDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentMonthDetailedVO>> refRentContractMonthDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                    String condition,
                                                                                    String searchObject,
                                                                                    String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("monthFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("pid", new Parameter(QueryParam.EQ, contractId));
            }
        }
        IPage<OutRentMonthDetailedEntity> page = rentMonthDetailedService.queryPage(param, false);
        IPage<OutRentMonthDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentMonthDetailedVO> list = BeanMapper.mapList(page.getRecords(), OutRentMonthDetailedVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            for (OutRentMonthDetailedVO vo : list) {
                vo.setMeterRentTypeName("月租");
            }
        }
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    @ApiOperation("工程量租明细参照")
    @RequestMapping(value = "/refRentContractQuantitiesDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentQuantitiesDetailedVO>> refRentContractQuantitiesDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                              String condition,
                                                                                              String searchObject,
                                                                                              String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("quantitiesFactoryCode");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("pid", new Parameter(QueryParam.EQ, contractId));
            }
        }
        IPage<OutRentQuantitiesDetailedEntity> page = rentQuantitiesDetailedService.queryPage(param, false);
        IPage<OutRentQuantitiesDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentQuantitiesDetailedVO> list = BeanMapper.mapList(page.getRecords(), OutRentQuantitiesDetailedVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            for (OutRentQuantitiesDetailedVO vo : list) {
                vo.setMeterRentTypeName("工程量租");
            }
        }
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    @ApiOperation("其他费用明细参照")
    @RequestMapping(value = "/refRentContractOtherDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentOtherDetailedVO>> refRentContractOtherDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                           String condition,
                                                                                           String searchObject,
                                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("pid", new Parameter(QueryParam.EQ, contractId));
            }
        }
        IPage<OutRentOtherDetailedEntity> page = rentOtherDetailedService.queryPage(param, false);
        IPage<OutRentOtherDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRentOtherDetailedVO> list = BeanMapper.mapList(page.getRecords(), OutRentOtherDetailedVO.class);
        pageData.setRecords(list);
        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（补充协议、变更单、冻结单、解除单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId, @RequestParam(value = "billType", required = false) String billType
            , @RequestParam(value = "billId", required = false) Long billId, @RequestParam(value = "type", required = false) String type) {
        String msg = service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success("校验成功！", msg);
    }


    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody OutRentContractVO contractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(contractVO,authority));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * @Description saveOrUpdate 查询当前合同下付款申请单列表
     * @param id
     */
    @RequestMapping(value = "/queryPaymentApplyList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = service.queryPaymentApplyList(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 手动添加水印
     * @param id 合同id
     * @return 添加结果
     */
    @RequestMapping(value = "/asyncWatermarkById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> asyncWatermarkById(@RequestParam(value = "id") Long id) {
        outRentContractAsyncService.asyncWatermarkById(id);
        return CommonResponse.success("水印添加成功！");
    }

    /**
     * 校验合同能否新增变更、补充协议
     *
     * @param id 合同id
     * @return 校验结果
     */
    @RequestMapping(value = "/checkContractFiling", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success("校验通过！");
        }
        return CommonResponse.error("当前合同无法新增");
    }

}
