package com.ejianc.business.proequipmentcorpout.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentSignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 签章流程
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRentContractSignature")
public class OutRentSignatureController implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    private IOutRentSignatureService signatureService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeStatus(@RequestBody String objectStr) {
        if (objectStr == null || StringUtils.isBlank(objectStr)) {
            return CommonResponse.error("签章流程返回对象为空，请检查！");
        }
        logger.info("进入修改签章流程方法------------->");
        JSONObject object = (JSONObject) JSONObject.parse(objectStr);
        Long billId = Long.valueOf(object.getString("billId"));
        int status = Integer.parseInt(object.getString("status"));
        String refCode = object.getString("refCode");
        return signatureService.changeStatus(billId, status, refCode);
    }
}
