package com.ejianc.business.proequipmentcorpout.contract.mapper;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentDayDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractEquipmentAllVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 租赁合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface OutRentContractMapper extends BaseCrudMapper<OutRentContractEntity> {
    /**
     * 查询数量
     * @param queryParam
     * @return
     */
    public Integer countNumber(Map<String, Object> queryParam);

    /**
     * 分页查询
     * @param queryParam
     * @return
     */
    List<OutRentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> queryParam);

    List<OutRentContractChangeVO> getRentContractChangeList(@Param("contractIds") List<Long> contractIds);

    @Select("select * from ejc_outequipmentcorp_rent_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<OutRentContractEntity> getContractListByTime(Date qDate);

    //需从三个子表中获取数据
    //日租
    @Select({
            "<script>",
            "select * from ejc_outequipmentcorp_rent_day_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRentDayDetailedEntity> getDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //月租
    @Select({
            "<script>",
            "select * from ejc_outequipmentcorp_rent_month_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRentMonthDetailedEntity> getMonthDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //工程量租
    @Select({
            "<script>",
            "select * from ejc_outequipmentcorp_rent_quantities_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<OutRentQuantitiesDetailedEntity> getQuantitiesDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);


//    List<OutRentSettlementVO> getRentSettlementList(@Param("contractIds") List<Long> contractIds);
}
