package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractRelieveEntity;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractRelieveMapper;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractRelieveService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 租赁合同解除
 * 
 * @author generator
 * 
 */
@Service("outRentContractRelieveService")
public class OutRentContractRelieveServiceImpl extends BaseServiceImpl<OutRentContractRelieveMapper, OutRentContractRelieveEntity> implements IOutRentContractRelieveService {
//    @Autowired
//    private IOutRentSettlementService outRentSettlementService;
    @Autowired
    private IOutRentContractService outRentContractService;
    @Value("${common.env.base-host}")
    private String baseHost;
    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(OutRentContractRelieveEntity entity) {
        // 计算所有过程结算累计结算金额
//        LambdaQueryWrapper<OutRentSettlementEntity> wrapper = new LambdaQueryWrapper<OutRentSettlementEntity>();
//        wrapper.eq(OutRentSettlementEntity::getContractId, entity.getContractId());
//        wrapper.eq(OutRentSettlementEntity::getSettlementType, "0");
//        wrapper.in(OutRentSettlementEntity::getBillState, Arrays.asList(1,3));
//        List<OutRentSettlementEntity> list = outRentSettlementService.list(wrapper);
//
//        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(OutRentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(OutRentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        OutRentContractEntity contractEntity = outRentContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType(OutRentConstants.BILL_TYPE_OUT_CONTRACT_RELIEVE);
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getCompanyId());
//        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
//        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
//        totalVO.setLinkUrl(baseHost + "ejc-proequipment-frontend/#/leaseContractContractRelieveCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }
}
