package com.ejianc.business.proequipmentcorpout.outStore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.RequireFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.enums.WeighFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartSubService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetRecordEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.consts.AssetRecordTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.rent.vo.RentAcceptanceSubVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


@Service("outStore")
public class OutStoreBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOutStoreService service;
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IOutRentContractService outRentContractService;
	@Autowired
	private IRentReceiptsApi rentReceiptsApi;
	@Autowired
	private IRentParameterService rentParameterService;
	@Autowired
	private IAssetService assetService;
	@Autowired
	private IAssetRecordService assetRecordService;
	@Autowired
	private IOutRentEquipmentStartService startService;
	@Autowired
	private IOutRentEquipmentStartSubService startSubService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutStoreEntity outStoreEntity = service.selectById(billId);
		if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
			if (outStoreEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
				return CommonResponse.error("地磅称重不符合要求,无法提交");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (state == 0){
			OutStoreEntity outStoreEntity = service.selectById(billId);
			if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
				if (outStoreEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
					return CommonResponse.error("地磅称重不符合要求,无法提交");
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity entity = service.selectById(billId);
		OutStoreVO outStoreVO = BeanMapper.map(entity, OutStoreVO.class);
		OutRentParameterVO pushParamVO = null;
		OutRentContractEntity contract = outRentContractService.selectById(entity.getContractId());

		List<OutRentParameterVO> saveList = new ArrayList<>();
		List<RentAcceptanceSubVO> rentAcceptanceSubList = new ArrayList<>();
		RentAcceptanceSubVO tmpRentAcc = null;
		for(OutStoreDetailVO outStoreDetailVO : outStoreVO.getOutStoreDetailList()) {
			//推送租出台账
			try {
				pushParamVO = BeanConvertorUtil.convert(outStoreVO, OutRentParameterVO.class);
				logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));
			} catch (Exception e) {
				logger.error("出库单推送租出设备台账失败, 出库转换台账单异常: ", e);
				return CommonResponse.error("出库单推送租出设备台账失败！");
			}

			//维护设备信息
			//出厂编码
			pushParamVO.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
			//单据审批状态设置为生效
			pushParamVO.setBillState(1);
			//设备基本信息
			pushParamVO.setCategoryId(outStoreDetailVO.getMaterialTypeId());
			pushParamVO.setCategoryName(outStoreDetailVO.getMaterialTypeName());
			pushParamVO.setEquipmentId(outStoreDetailVO.getMaterialId());
			pushParamVO.setEquipmentCode(outStoreDetailVO.getMaterialCode());
			pushParamVO.setEquipmentName(outStoreDetailVO.getMaterialName());
			pushParamVO.setUnitId(outStoreDetailVO.getRentUnitId());
			pushParamVO.setUnitName(outStoreDetailVO.getRentUnitName());
			pushParamVO.setSpec(outStoreDetailVO.getSpec());
			//产权单位
			pushParamVO.setPropertyRightCompany(outStoreDetailVO.getPropertyRightCompany());
			//安装位置
			pushParamVO.setInstallLocation(outStoreDetailVO.getInstallLocation());
			//计租日期
			pushParamVO.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
			pushParamVO.setAcceptanceDate(outStoreVO.getOutstoreDate());
			pushParamVO.setStartDate(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? outStoreDetailVO.getRentDetailDate():null);
			//计租方式
			pushParamVO.setMeterRentType(outStoreDetailVO.getRentCalculationType());
			//设备状态
			pushParamVO.setEquipmentState(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? OutRentEquipmentStateEnum.启用.getCode() : OutRentEquipmentStateEnum.待启用.getCode());
			pushParamVO.setEquipmentStateName(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? OutRentEquipmentStateEnum.启用.getDescription() : OutRentEquipmentStateEnum.待启用.getDescription());
			//使用状态- 在用
            pushParamVO.setUseType(2);
			//设备台账Id
			pushParamVO.setEquipLedgerId(outStoreDetailVO.getStoreEquipId());
			//设备台账出厂编码
			pushParamVO.setEquipLedgerFactoryCode(outStoreDetailVO.getStoreEquipCode());
			//设备台账设备名称
			pushParamVO.setEquipLedgerEquipName(outStoreDetailVO.getStoreEquipName());
			pushParamVO.setEquipLedgerType(entity.getRentHarborType() == 0 ? OutRentParameterVO.EQUIP_LEDGER_TYPE_PUR : OutRentParameterVO.EQUIP_LEDGER_TYPE_RENT);

			//使用项目-- 从出库单的项目信息获取
			pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
			pushParamVO.setUseProjectId(pushParamVO.getProjectId());
			pushParamVO.setUseProjectName(pushParamVO.getProjectName());
			pushParamVO.setUseOrgCode(entity.getOutOrgCode());
			pushParamVO.setUseOrgName(entity.getOutOrgName());
			pushParamVO.setUseOrgId(entity.getOutOrgId());
			//合同供应商
			pushParamVO.setSupplierId(contract.getSupplierId());
			pushParamVO.setSupplierName(contract.getSupplierName());
			pushParamVO.setSourceId(outStoreVO.getId());
			pushParamVO.setSourceBillType(entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.设备租出自购.getCode() : RentOutParamSourceBillTypeEnum.设备租出租赁.getCode());

			pushParamVO.setMemo(outStoreDetailVO.getMemo());

			//合同税率
			pushParamVO.setContractTaxRate(contract.getContractTax());

			OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
			paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
			paramDetailVO.setOperationDate(outStoreDetailVO.getRentDetailDate());
			paramDetailVO.setSourceId(outStoreDetailVO.getId());
			paramDetailVO.setSourceType(OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE); //出库单

			List<OutRentParameterDetailVO> paramSubList =new ArrayList<>();
			paramSubList.add(paramDetailVO);
			pushParamVO.setRentParameterDetailList(paramSubList);
			logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));

			if(entity.getRentHarborType() == 1) { //内租 推项目验收
				tmpRentAcc = new RentAcceptanceSubVO();
				tmpRentAcc.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
				tmpRentAcc.setEquipmentAppearanceCode(outStoreDetailVO.getEquipLeaveFactoryCode());
				tmpRentAcc.setSpecs(outStoreDetailVO.getSpec());
				tmpRentAcc.setCategoryId(outStoreDetailVO.getMaterialTypeId());
				tmpRentAcc.setCategoryName(outStoreDetailVO.getMaterialName());
				tmpRentAcc.setEquipmentCode(outStoreDetailVO.getMaterialCode());
				tmpRentAcc.setEquipmentId(outStoreDetailVO.getMaterialId());
				tmpRentAcc.setName(outStoreDetailVO.getMaterialName());
				tmpRentAcc.setContractId(entity.getContractId());
				tmpRentAcc.setNum(null != outStoreDetailVO.getRentNum() ? Integer.valueOf(outStoreDetailVO.getRentNum().intValue()) : 0);
				tmpRentAcc.setRentTypeId("day".equals(outStoreDetailVO.getRentCalculationType()) ? 1 : "month".equals(outStoreDetailVO.getRentCalculationType()) ? 2 : 3);
				tmpRentAcc.setRentTypeName("day".equals(outStoreDetailVO.getRentCalculationType()) ? "日租" : "month".equals(outStoreDetailVO.getRentCalculationType()) ? "月租" : "工程量");
//				tmpRentAcc.setPrice();  //不知道计算公式
				tmpRentAcc.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
				tmpRentAcc.setUnitName(outStoreDetailVO.getRentUnitName());
				tmpRentAcc.setUnitId(outStoreDetailVO.getRentUnitId());
				tmpRentAcc.setQuantitiesNum(null != outStoreDetailVO.getCalculateNum() ? outStoreDetailVO.getCalculateNum() : BigDecimal.ZERO); //此项不确定
				tmpRentAcc.setSourceId(outStoreDetailVO.getId());
				tmpRentAcc.setProductionManufactor(outStoreDetailVO.getProductionManufactor());
				rentAcceptanceSubList.add(tmpRentAcc);
			}

			saveList.add(pushParamVO);
		}

		if(Integer.valueOf("1").equals(entity.getSourceType())) {
			//设备来源：租赁
			QueryWrapper<RentParameterEntity> rentParameterQuery = new QueryWrapper<>();
			rentParameterQuery.in("id", entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
			List<RentParameterEntity> rentParameterList = rentParameterService.list(rentParameterQuery);
			if(CollectionUtils.isNotEmpty(rentParameterList)) {
				for(RentParameterEntity rp : rentParameterList) {
					rp.setUseType(2); //再用状态

					if(null == rp.getUseProjectId()) {
						rp.setUseProjectId(pushParamVO.getUseProjectId());
						rp.setUseProjectName(pushParamVO.getProjectName());
						rp.setUseProjectCode(pushParamVO.getProjectCode());
						rp.setUseOrgId(pushParamVO.getUseOrgId());
						rp.setUseOrgCode(pushParamVO.getUseOrgCode());
						rp.setUseOrgName(pushParamVO.getUseOrgName());
					}
				}
				rentParameterService.saveOrUpdateBatch(rentParameterList, rentParameterList.size(), false);
			}
		} else {
			//设备来源：采购
			//修改设备绑定的仓库设备状态，将其设备状态改为再用，租出状态改为启用
			QueryWrapper<AssetEntity> assetQuery = new QueryWrapper<>();
			assetQuery.in("id", entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
			Map<Long, OutStoreDetailEntity> outStoreDetailMap = entity.getOutStoreDetailList().stream().collect(Collectors.toMap(item -> item.getStoreEquipId(), item -> item));
			List<AssetEntity> assetEntities = assetService.list(assetQuery);
			List<AssetRecordEntity> newAssetRecordList = new ArrayList<>(); //新增流转记录
			OutStoreDetailEntity tmpOutStoreDetail = null;
			if(CollectionUtils.isNotEmpty(assetEntities)) {
				for(AssetEntity asset : assetEntities) {

					asset.setRentState(Integer.valueOf("1").equals(entity.getEntranceRentFlag()) ? 1 : 5); //租出状态为启用
					asset.setEquipmentStatus(1); //设置状态为在用
					if(StringUtils.isBlank(asset.getProjectName())) {
						asset.setProjectId(pushParamVO.getProjectId());
						asset.setProjectName(pushParamVO.getProjectName());
					}
					//生成设备流转记录
					newAssetRecordList.add(generateAssetRecord(asset, entity));
				}
				assetService.saveOrUpdateBatch(assetEntities, assetEntities.size(), false);
				if(CollectionUtils.isNotEmpty(newAssetRecordList)) {
					assetRecordService.saveOrUpdateBatch(newAssetRecordList, newAssetRecordList.size(), false);
				}
			}
		}

		outRentParameterService.saveOrUpdateOutRentParams(saveList);
		if(entity.getRentHarborType() == 1) { //内租 推项目验收
            JSONObject data = JSONObject.parseObject(JSONObject.toJSONString(BeanMapper.map(entity, RentAcceptanceVO.class)));
			data.put("orgId", outStoreVO.getOutOrgId());// 项目部Id
			data.put("orgCode", outStoreVO.getOutOrgCode());//项目部编码
			data.put("orgName", outStoreVO.getOutOrgName()); //项目部名称
			data.put("outOrgId", outStoreVO.getOrgId());// 租出单位Id
			data.put("outOrgCode", outStoreVO.getOrgCode());//租出单位编码
			data.put("outOrgName", outStoreVO.getOrgName()); //租出单位名称
            data.put("supplierId", contract.getSupplierId());// 供应商
            data.put("supplierName", contract.getSupplierName());//供应商
            data.put("acceptanceDate", entity.getOutstoreDate()); //验收日期
            data.put("acceptanceUserName", entity.getEmployeeName()); //验收人名称
            data.put("acceptanceUserId", entity.getEmployeeId()); //验收人Id
            data.put("rentDate", entity.getRentDate()); //计租日期
            data.put("acceptanceSource", "出库单["+entity.getId().toString()+"]"); //验收来源 1-自制,2-送货单
            data.put("acceptanceSourceId", 1); //验收来源
            data.put("sourceType", 0); //验收来源，0-自制验收,1-发货验收
            data.put("signStatus", 0); //签字状态：0-未签字,1-已签字
            data.put("carCode", entity.getLicensePlate()); //车牌号
            data.put("companyId", entity.getParentOrgId()); //所属单位Id
            data.put("companyName", entity.getParentOrgName()); //所属单位名称
            data.put("rentType", 1); //租赁方式(0-外租，1-内租)
			data.put("code", entity.getBillCode());
			data.put("entranceRentFlag", entity.getEntranceRentFlag());//是否进场即计租

			data.put("rentAcceptanceSubList", rentAcceptanceSubList);

			//TODO 同步签字信息
			data.put("signStatus", entity.getSupplierSignStatus());

			logger.info("推送项目方验收单信息：{}", JSONObject.toJSONString(data));
			CommonResponse<String> response = rentReceiptsApi.receiptsSync(data, RentReceiptsEnum.验收单.getName());
			if(!response.isSuccess()){
				logger.error("内租出库单推项目验收失败：{}", JSONObject.toJSONString(response));
				throw new BusinessException(response.getMsg());
			}
		}

		return CommonResponse.success();
	}

	private AssetRecordEntity generateAssetRecord(AssetEntity asset, OutStoreEntity entity) {
		AssetRecordEntity tmpAssetRecord = new AssetRecordEntity();
		tmpAssetRecord.setAssetId(asset.getId());
		tmpAssetRecord.setAssetName(asset.getEquipmentName());
		tmpAssetRecord.setAssetCode(asset.getBillCode());
		tmpAssetRecord.setProjectId(entity.getProjectId());
		tmpAssetRecord.setProjectCode(entity.getProjectCode());
		tmpAssetRecord.setProjectName(entity.getProjectName());
		tmpAssetRecord.setOrgId(entity.getOutOrgId());
		tmpAssetRecord.setOrgCode(entity.getOutOrgCode());
		tmpAssetRecord.setOrgName(entity.getOutOrgName());
		tmpAssetRecord.setParentOrgCode(entity.getParentOrgCode());
		tmpAssetRecord.setParentOrgId(entity.getParentOrgId());
		tmpAssetRecord.setParentOrgName(entity.getParentOrgName());
		tmpAssetRecord.setEquipmentCode(asset.getEquipmentCode());
		tmpAssetRecord.setEquipmentId(asset.getEquipmentId());
		tmpAssetRecord.setEquipmentName(asset.getEquipmentName());
		tmpAssetRecord.setEquipmentTypeId(asset.getEquipmentTypeId());
		tmpAssetRecord.setEquipmentTypeCode(asset.getEquipmentTypeCode());
		tmpAssetRecord.setEquipmentTypeName(asset.getEquipmentTypeName());
		tmpAssetRecord.setBillDate(new Date());
		tmpAssetRecord.setSourceBillCode(asset.getBillCode());
		tmpAssetRecord.setSourceId(entity.getId());
		tmpAssetRecord.setSourceType(AssetRecordTypeEnum.出库.getCode());
		tmpAssetRecord.setSourceTypeName(AssetRecordTypeEnum.出库.getName());
		return tmpAssetRecord;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity entity = service.selectById(billId);

		OutRentContractEntity contract = outRentContractService.selectById(entity.getContractId());
        if(contract !=null && PerformanceStatusEnum.已终止.getCode().equals(contract.getContractPerformanceState())){
            return CommonResponse.error("合同已终止，该单据不能撤回！");
        }

		//查询对应租出台账
		QueryWrapper<OutRentParameterEntity> query = new QueryWrapper<>();
		query.eq("source_id", billId);
		query.eq("contract_id", entity.getContractId());
		query.eq("dr", BaseVO.DR_UNDELETE);
		List<OutRentParameterEntity> outRentParameterEntitys = outRentParameterService.list(query);
		logger.info("outRentParameterEntitys------>{}", JSONObject.toJSONString(outRentParameterEntitys));

		//校验是否有未生效的下游单据
		List<Long> parameterIdList = outRentParameterEntitys.stream().map(OutRentParameterEntity::getId).collect(Collectors.toList());
		outRentParameterService.checkNoEffectData(parameterIdList, billId, entity.getContractId());

		QueryWrapper<OutRentParameterDetailEntity> detailQuery = new QueryWrapper<>();
		detailQuery.in("parameter_id", parameterIdList);
		detailQuery.ne("source_type", OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE);

		List<OutRentParameterDetailEntity> list = outRentParameterDetailService.list(detailQuery);
		if(CollectionUtils.isNotEmpty(list)) {
			return CommonResponse.error("弃审失败，设备已进行下游业务！");
		}else {
			QueryParam checkQueryParam = new QueryParam();
			checkQueryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
			checkQueryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
					BillStateEnum.COMMITED_STATE.getBillStateCode(),
					BillStateEnum.PASSED_STATE.getBillStateCode())));

			List<OutRentEquipmentStartEntity> startEntityList = startService.queryList(checkQueryParam, false);
			logger.info("startEntityList:{}", JSONObject.toJSONString(startEntityList));
			if (CollectionUtils.isNotEmpty(startEntityList)) {
				for (OutRentEquipmentStartEntity rentEquipmentStartEntity : startEntityList) {
					QueryWrapper<OutRentEquipmentStartSubEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("pid", rentEquipmentStartEntity.getId());
					List<OutRentEquipmentStartSubEntity> outRentEquipmentStartSubEntityList = startSubService.list(queryWrapper);
					logger.info("outRentEquipmentStartSubEntityList:{}", JSONObject.toJSONString(outRentEquipmentStartSubEntityList));
					for (OutRentEquipmentStartSubEntity rentEquipmentStartSubEntity : outRentEquipmentStartSubEntityList) {
						if (parameterIdList.contains(rentEquipmentStartSubEntity.getSourceId())){
							throw new BusinessException("存在生效的启用单，无法撤回单据！");
						}
					}
				}
			}
		}

		String result = outRentParameterService.removeBySourceId(entity.getId(), entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.设备租出自购.getCode() : RentOutParamSourceBillTypeEnum.设备租出租赁.getCode());
		if(StringUtils.isNotBlank(result)) {
			return CommonResponse.error("弃审失败，删除租出台账失败，原因："+result);
		}

		//修改设备绑定的仓库设备状态，将其设备状态改为闲置，租出状态改为停用
		if(Integer.valueOf("1").equals(entity.getSourceType())) {
			//设备来源：租赁
			QueryWrapper<RentParameterEntity> rentParameterQuery = new QueryWrapper<>();
			rentParameterQuery.in("id", entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
			List<RentParameterEntity> rentParameterList = rentParameterService.list(rentParameterQuery);
			if(CollectionUtils.isNotEmpty(rentParameterList)) {
				for(RentParameterEntity rp : rentParameterList) {
					rp.setUseType(1); //闲置状态

					if(null != rp.getUseProjectId()) {
						rp.setUseProjectId(null);
						rp.setUseProjectName(null);
						rp.setUseProjectCode(null);
						rp.setUseOrgId(null);
						rp.setUseOrgCode(null);
						rp.setUseOrgName(null);
					}
				}
				rentParameterService.saveOrUpdateBatch(rentParameterList, rentParameterList.size(), false);
			}
		} else {
			//设备来源：采购
			//修改设备绑定的仓库设备状态，将其设备状态改为再用，租出状态改为启用
			QueryWrapper<AssetEntity> assetQuery = new QueryWrapper<>();
			assetQuery.in("id", entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
			List<AssetEntity> assetEntities = assetService.list(assetQuery);
			if(CollectionUtils.isNotEmpty(assetEntities)) {
				for(AssetEntity asset : assetEntities) {
					asset.setRentState(2); //租出状态为停用
					asset.setEquipmentStatus(3); //设置状态为闲置
					if(StringUtils.isNotBlank(asset.getProjectName())) {
						asset.setProjectId(null);
						asset.setProjectName(null);
					}
				}
				assetService.saveOrUpdateBatch(assetEntities, assetEntities.size(), false);

				//删除推送的流转记录
				assetRecordService.delRecord(entity.getId());
			}
		}

		// 内阻推送供方
		if(entity.getRentHarborType() == 1) { //内租 删除掉推送的验收单
			CommonResponse<String> response = rentReceiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.验收单.getName());
			if (!response.isSuccess()) {
				logger.error("出库单弃审异常，删除内租验收单失败：{}", JSONObject.toJSONString(response));
				throw new BusinessException(response.getMsg());
			}
		}

		return CommonResponse.success("操作成功！");
	}

}
