package com.ejianc.business.proequipmentcorpout.outrent.Enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OutRentEquipmentStateEnum {
    /**
     * 设备状态: 1-进厂
     */
    进厂(1, "进厂"),
    /**
     * 设备状态: 2-启用
     */
    启用(2, "启用"),
    /**
     * 设备状态: 3-停用
     */
    停用(3, "停用"),
    /**
     * 设备状态: 4-退场
     */
    退场(4, "退场"),
    /**
     * 设备状态: 5-待启用
     */
    待启用(5, "待启用"),
    /**
     * 设备状态: 6-停租
     */
    停租(6, "停租");


    private Integer code;
    private String description;
    private static Map<Integer, OutRentEquipmentStateEnum> enumMap = new HashMap<>();

    OutRentEquipmentStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(OutRentEquipmentStateEnum.class).stream().collect(Collectors
                .toMap(OutRentEquipmentStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static OutRentEquipmentStateEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
