package com.ejianc.business.proequipmentcorpout.proxy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractDetailEntity;
import com.ejianc.business.proequipmentcorpout.proxy.vo.ProxyContractVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorpout.proxy.mapper.ProxyContractMapper;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 设备公司租出线-合同授权委托书
 * 
 * @author generator
 * 
 */
@Service("proxyContractService")
public class ProxyContractServiceImpl extends BaseServiceImpl<ProxyContractMapper, ProxyContractEntity> implements IProxyContractService{
    private static final String BILL_CODE = "PROXY_CONTRACT ";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;

    @Override
    public ProxyContractVO saveOrUpdate(ProxyContractVO saveOrUpdateVO) {
        ProxyContractEntity entity = BeanMapper.map(saveOrUpdateVO, ProxyContractEntity.class);
        if(StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<Long> equipmentIdList = entity.getProxyContractDetailList().stream().filter(e -> null != e.getequipmentId()).map(ProxyContractDetailEntity::getequipmentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(equipmentIdList) && equipmentIdList.size() > 0){
            CommonResponse<List<EquipmentVO>> codeCommonResponse = equipmentApi.queryEquipmentItemByIds(equipmentIdList);
            if (!codeCommonResponse.isSuccess() || !(codeCommonResponse.getData().size() > 0)){
                throw new BusinessException("根据设备id获取设备信息失败，请检查子表设备！");
            }

            List<EquipmentVO> equipmentList = codeCommonResponse.getData();
            Map<Long, EquipmentVO> equipmentMap = equipmentList.stream().filter(map -> map.getId() != null).collect(Collectors.toMap(e -> e.getId(), e -> e));
            for (ProxyContractDetailEntity proxyContractDetailEntity : entity.getProxyContractDetailList()) {
                if (equipmentMap.containsKey(proxyContractDetailEntity.getequipmentId())){
                    proxyContractDetailEntity.setJobContent(equipmentMap.get(proxyContractDetailEntity.getequipmentId()).getJobContent());
                    proxyContractDetailEntity.setDetailMeasurementRules(equipmentMap.get(proxyContractDetailEntity.getequipmentId()).getDetailMeasurementRules());
                }
            }
        }


        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ProxyContractVO.class);
    }
}
