package com.ejianc.business.proequipmentcorppur.purchase.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备采购合同-记录表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_purchase_contract_record")
public class RecordPurchaseContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="target_result_id")
    private Long targetResultId; // 定标结果Id
    @TableField(value="target_result_name")
    private String targetResultName; // 定标结果名称
    @TableField(value="bill_code")
    private String billCode; // 合同编号
    @TableField(value="contract_code")
    private String contractCode; // 合同编号

    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_company")
    private String projectCompany; // 所属单位
    @TableField(value="project_company_id")
    private Long projectCompanyId; // 所属单位id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别Id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方
    @TableField(value="first_party_id")
    private Long firstPartyId; // 甲方id
    @TableField(value="first_party_psn")
    private String firstPartyPsn; // 甲方负责人
    @TableField(value="first_party_psn_id")
    private Long firstPartyPsnId; // 甲方负责人id
    @TableField(value="first_party_employee")
    private String firstPartyEmployee; // 甲方经办人
    @TableField(value="first_party_employee_id")
    private Long firstPartyEmployeeId; // 甲方经办人id
    @TableField(value="first_party_phone")
    private String firstPartyPhone; // 甲方联系电话
    @TableField(value="supplier_name")
    private String supplierName; // 乙方
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_employee")
    private String supplierEmployee; // 乙方经办人
    @TableField(value="supplier_phone")
    private String supplierPhone; // 乙方联系电话
    @TableField(value="supplier_address")
    private String supplierAddress; // 乙方地址
    @TableField(value="sign_date")
    private Date signDate; // 签订日期
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="sign_place")
    private String signPlace; // 供货地点
    @TableField(value="signature_status")
    private String signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @TableField(value="contract_performance_state")
    private Integer contractPerformanceState; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；  不可选择，根据 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】；
    @TableField(value="draft_type")
    private String draftType; // 起草方式：1、在线起草2、上传合同3、线下签订
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="contract_file_version_id")
    private Long contractFileVersionId; // 合同附件版本Id
    @TableField(value="contract_file_version")
    private Long contractFileVersion; // 合同附件版本
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税)
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="equipment_tax_mny")
    private BigDecimal equipmentTaxMny; // 设备金额
    @TableField(value="equipment_mny")
    private BigDecimal equipmentMny; // 设备金额（无税）
    @TableField(value="equipment_tax")
    private BigDecimal equipmentTax; // 设备税额
    @TableField(value="other_tax_mny")
    private BigDecimal otherTaxMny; // 其他金额
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其他金额（无税）
    @TableField(value="other_tax")
    private BigDecimal otherTax; // 其他税额
    @TableField(value="estimate_amortize_total_mny")
    private BigDecimal estimateAmortizeTotalMny; // 预计摊销总金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value="contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始版本金额
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同Id
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="contract_id")
    private Long contractId; // 主合同Id
    @TableField(value="supplement_describe")
    private String supplementDescribe; // 补充项描述
    @TableField(value="main_contract_create_date")
    private Date mainContractCreateDate; // 主合同创建日期（用于合同、补充协议排序）
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="before_contract_name")
    private String beforeContractName; // 变更前合同名称
    @TableField(value="change_items")
    private String changeItems; // 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
    @TableField(value="change_employee_id")
    private Long changeEmployeeId; // 经办人
    @TableField(value="change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value="change_mny")
    private BigDecimal changeMny; // 本次变更金额
    @TableField(value="change_scale")
    private BigDecimal changeScale; // 本次变更比例
    @TableField(value="change_tax")
    private BigDecimal changeTax; // 本次变更税率
    @TableField(value="change_reason")
    private String changeReason; // 变更原因描述
    @TableField(value="change_draft_type")
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    @TableField(value="change_file_id")
    private Long changeFileId; // 变更附件Id
    @TableField(value="change_file_path")
    private String changeFilePath; // 变更附件路径
    @TableField(value="change_contract_signature_status")
    private Integer changeContractSignatureStatus; // 变更合同签章状态
    @TableField(value="signed_file_id")
    private Long signedFileId; // 签章完成合同文件Id
    @TableField(value="add_type")
    private Boolean addType; // 合同新增方式：参照定标结果新增-1，直接新增-0
    @TableField(value="org_code")
    private String orgCode; // 项目部编码

    /**
     * 设备采购合同-机械设备明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "recordPurchaseContractDetailService", pidName = "recordId")
    private List<RecordPurchaseContractDetailEntity> detailList = new ArrayList<>();
    /**
     * 设备采购合同-合同条款
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "recordPurchaseContractClauseService", pidName = "recordId")
    private List<RecordPurchaseContractClauseEntity> clauseList = new ArrayList<>();
    /**
     * 设备采购合同-合同支付条款
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "recordPurchaseContractPaymentClauseService", pidName = "recordId")
    private List<RecordPurchaseContractPaymentClauseEntity> paymentList = new ArrayList<>();

    /**
     * 设备采购合同-其他费用
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "recordPurchaseContractOtherDetailedService", pidName = "recordId")
    private List<RecordPurchaseContractOtherDetailedEntity> otherCostList = new ArrayList<>();
    @TableField(value="purchase_id")
    private String purchaseId; // 供货内容id
    @TableField(value="purchase_name")
    private String purchaseName; // 供货内容名称

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }
    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectCompany() {
        return projectCompany;
    }

    public void setProjectCompany(String projectCompany) {
        this.projectCompany = projectCompany;
    }
    public Long getProjectCompanyId() {
        return projectCompanyId;
    }

    public void setProjectCompanyId(Long projectCompanyId) {
        this.projectCompanyId = projectCompanyId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyPsn() {
        return firstPartyPsn;
    }

    public void setFirstPartyPsn(String firstPartyPsn) {
        this.firstPartyPsn = firstPartyPsn;
    }
    public Long getFirstPartyPsnId() {
        return firstPartyPsnId;
    }

    public void setFirstPartyPsnId(Long firstPartyPsnId) {
        this.firstPartyPsnId = firstPartyPsnId;
    }
    public String getFirstPartyEmployee() {
        return firstPartyEmployee;
    }

    public void setFirstPartyEmployee(String firstPartyEmployee) {
        this.firstPartyEmployee = firstPartyEmployee;
    }
    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }

    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }
    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierEmployee() {
        return supplierEmployee;
    }

    public void setSupplierEmployee(String supplierEmployee) {
        this.supplierEmployee = supplierEmployee;
    }
    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }
    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Integer getContractPerformanceState() {
        return contractPerformanceState;
    }

    public void setContractPerformanceState(Integer contractPerformanceState) {
        this.contractPerformanceState = contractPerformanceState;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }
    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getEquipmentTaxMny() {
        return equipmentTaxMny;
    }

    public void setEquipmentTaxMny(BigDecimal equipmentTaxMny) {
        this.equipmentTaxMny = equipmentTaxMny;
    }
    public BigDecimal getEquipmentMny() {
        return equipmentMny;
    }

    public void setEquipmentMny(BigDecimal equipmentMny) {
        this.equipmentMny = equipmentMny;
    }
    public BigDecimal getEquipmentTax() {
        return equipmentTax;
    }

    public void setEquipmentTax(BigDecimal equipmentTax) {
        this.equipmentTax = equipmentTax;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    public BigDecimal getEstimateAmortizeTotalMny() {
        return estimateAmortizeTotalMny;
    }

    public void setEstimateAmortizeTotalMny(BigDecimal estimateAmortizeTotalMny) {
        this.estimateAmortizeTotalMny = estimateAmortizeTotalMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }
    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }
    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }
    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }
    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }
    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }
    public BigDecimal getChangeMny() {
        return changeMny;
    }

    public void setChangeMny(BigDecimal changeMny) {
        this.changeMny = changeMny;
    }
    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }
    public BigDecimal getChangeTax() {
        return changeTax;
    }

    public void setChangeTax(BigDecimal changeTax) {
        this.changeTax = changeTax;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }
    public String getChangeFilePath() {
        return changeFilePath;
    }

    public void setChangeFilePath(String changeFilePath) {
        this.changeFilePath = changeFilePath;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
    public Boolean getAddType() {
        return addType;
    }

    public void setAddType(Boolean addType) {
        this.addType = addType;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<RecordPurchaseContractDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<RecordPurchaseContractDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<RecordPurchaseContractClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<RecordPurchaseContractClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<RecordPurchaseContractPaymentClauseEntity> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<RecordPurchaseContractPaymentClauseEntity> paymentList) {
        this.paymentList = paymentList;
    }

    public List<RecordPurchaseContractOtherDetailedEntity> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<RecordPurchaseContractOtherDetailedEntity> otherCostList) {
        this.otherCostList = otherCostList;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
}
