package com.ejianc.business.proequipmentcorppur.purchase.mapper;

import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractDetailedEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 设备采购合同表
 * 
 * @author generator
 * 
 */
@Mapper
public interface PurchaseContractMapper extends BaseCrudMapper<PurchaseContractEntity> {

    @Select({
            "<script>",
            "select * from ejc_proequipmentcorp_equipment_detailed where contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<PurchaseContractDetailedEntity> getContractDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    @Select("select * from ejc_proequipmentcorp_purchase_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<PurchaseContractEntity> getContractListByTime(Date qDate);
}
