package com.ejianc.business.proequipmentcorprent.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceSubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 租赁设备验收
 *
 * @author generator
 *
 */
@TableName("ejc_proequipmentcorp_rent_acceptance")
public class RentAcceptanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 费用项目名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode; // 合同编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="engineering_id")
    private Long engineeringId; // 工程id
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称

    @TableField(value="acceptance_user_name")
    private String acceptanceUserName; // 验收人
    @TableField(value="acceptance_date")
    private Date acceptanceDate; // 验收日期
    @TableField(value="car_code")
    private String carCode; // 车票号
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="acceptance_user_id")
    private Long acceptanceUserId; // 验收人id
    @TableField(value="rent_date")
    private Date rentDate; // 计租日期
    @TableField(value="acceptance_source")
    private String acceptanceSource; // 验收来源
    @TableField(value="acceptance_source_id")
    private Integer acceptanceSourceId;//1-自制,2-送货单
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="company_id")
    private Long companyId; // 所属单位
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="equipment_num") //设备总数(由子表汇总)
    private Integer equipmentNum;
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部ID
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称
    @TableField(value="not_signature")
    private Boolean notSignature;//是否签字
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="supplier_sign_id")
    private String supplierSignId;
    @TableField(value="sign_array")
    private String signArray;
    @TableField(value="sign_array_t")
    private String signArrayT;
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键
    @TableField(value="check_state")
    private Integer checkState; // 验收状态（0-未验收，1--已验收）
    @TableField(value="source_type")
    private Integer sourceType; // 验收来源，0-自制验收,1-发货验收
    @TableField(value = "delivery_code")
    private String deliveryCode; // 发货单编号
    /***  协同需要字段 START  ***/
    @TableField(value = "sign_status")
    private Integer signStatus; // 签字状态：0-未签字,1-已签字
    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    @TableField(exist=false)
    @SubEntity(serviceName="rentAcceptanceSubService")
    private List<RentAcceptanceSubEntity> rentAcceptanceSubList = new ArrayList<>(); // 租赁设备验收明细
    @TableField(value="org_code")
    private String orgCode;

    @TableField(value="rent_project_code")
    private String rentProjectCode; // 所属项目编号
    @TableField(value="rent_project_id")
    private Long rentProjectId; // 所属项目id
    @TableField(value="rent_project_name")
    private String rentProjectName; // 所属项目

    @TableField(value="rent_org_code")
    private String rentOrgCode; // 所属组织编号
    @TableField(value="rent_org_id")
    private Long rentOrgId; // 所属组织id
    @TableField(value="rent_org_name")
    private String rentOrgName; // 所属组织
    @TableField(value="rent_project_type")
    private Integer rentProjectType; // 项目类别，0-内部项目,1-外部项目
    @TableField(value="rent_project_addr")
    private String rentProjectAddr; // 所属项目地址
    @TableField(value="check_before_flag")
    private Integer checkBeforeFlag; // 是否进场前验收   1-是  2-否
    @TableField(value="record_flag")
    private String recordFlag; // 是否补录，0-否，1-是
    @TableField(value="store_type")
    private String storeType; // 入库方式，0-收料入库，1-直入直出
    @TableField(value="entrance_rent_flag")
    private Integer entranceRentFlag; // 是否进场计租   1-是  2-否
//出库信息
    @TableField(value="out_contract_id")
    private Long outContractId; // 合同id
    @TableField(value="out_contract_name")
    private String outContractName; // 合同名称
    @TableField(value="out_contract_code")
    private String outContractCode; // 合同编码
    @TableField(value="out_project_id")
    private Long outProjectId; // 项目id
    @TableField(value="out_project_name")
    private String outProjectName; // 项目名称
    @TableField(value="out_project_code")
    private String outProjectCode; // 项目名称
    @TableField(value="out_employee_name")
    private String outEmployeeName; // 联系人
    @TableField(value="out_employee_phone")
    private String outEmployeePhone; // 联系电话

    public Integer getEntranceRentFlag() {
        return entranceRentFlag;
    }

    public void setEntranceRentFlag(Integer entranceRentFlag) {
        this.entranceRentFlag = entranceRentFlag;
    }

    public String getRecordFlag() {
        return recordFlag;
    }

    public void setRecordFlag(String recordFlag) {
        this.recordFlag = recordFlag;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public Long getOutContractId() {
        return outContractId;
    }

    public void setOutContractId(Long outContractId) {
        this.outContractId = outContractId;
    }

    public String getOutContractName() {
        return outContractName;
    }

    public void setOutContractName(String outContractName) {
        this.outContractName = outContractName;
    }

    public String getOutContractCode() {
        return outContractCode;
    }

    public void setOutContractCode(String outContractCode) {
        this.outContractCode = outContractCode;
    }

    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }

    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }

    public String getOutProjectCode() {
        return outProjectCode;
    }

    public void setOutProjectCode(String outProjectCode) {
        this.outProjectCode = outProjectCode;
    }

    public String getOutEmployeeName() {
        return outEmployeeName;
    }

    public void setOutEmployeeName(String outEmployeeName) {
        this.outEmployeeName = outEmployeeName;
    }

    public String getOutEmployeePhone() {
        return outEmployeePhone;
    }

    public void setOutEmployeePhone(String outEmployeePhone) {
        this.outEmployeePhone = outEmployeePhone;
    }

    public Integer getCheckBeforeFlag() {
        return checkBeforeFlag;
    }

    public void setCheckBeforeFlag(Integer checkBeforeFlag) {
        this.checkBeforeFlag = checkBeforeFlag;
    }

    public String getRentProjectCode() {
        return rentProjectCode;
    }

    public void setRentProjectCode(String rentProjectCode) {
        this.rentProjectCode = rentProjectCode;
    }

    public Long getRentProjectId() {
        return rentProjectId;
    }

    public void setRentProjectId(Long rentProjectId) {
        this.rentProjectId = rentProjectId;
    }

    public String getRentProjectName() {
        return rentProjectName;
    }

    public void setRentProjectName(String rentProjectName) {
        this.rentProjectName = rentProjectName;
    }

    public String getRentOrgCode() {
        return rentOrgCode;
    }

    public void setRentOrgCode(String rentOrgCode) {
        this.rentOrgCode = rentOrgCode;
    }

    public Long getRentOrgId() {
        return rentOrgId;
    }

    public void setRentOrgId(Long rentOrgId) {
        this.rentOrgId = rentOrgId;
    }

    public String getRentOrgName() {
        return rentOrgName;
    }

    public void setRentOrgName(String rentOrgName) {
        this.rentOrgName = rentOrgName;
    }

    public Integer getRentProjectType() {
        return rentProjectType;
    }

    public void setRentProjectType(Integer rentProjectType) {
        this.rentProjectType = rentProjectType;
    }

    public String getRentProjectAddr() {
        return rentProjectAddr;
    }

    public void setRentProjectAddr(String rentProjectAddr) {
        this.rentProjectAddr = rentProjectAddr;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Integer getCheckState() {
        return checkState;
    }

    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getAcceptanceUserName() {
        return acceptanceUserName;
    }

    public void setAcceptanceUserName(String acceptanceUserName) {
        this.acceptanceUserName = acceptanceUserName;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getAcceptanceUserId() {
        return acceptanceUserId;
    }

    public void setAcceptanceUserId(Long acceptanceUserId) {
        this.acceptanceUserId = acceptanceUserId;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public String getAcceptanceSource() {
        return acceptanceSource;
    }

    public void setAcceptanceSource(String acceptanceSource) {
        this.acceptanceSource = acceptanceSource;
    }


    public List<RentAcceptanceSubEntity> getRentAcceptanceSubList() {
        return rentAcceptanceSubList;
    }

    public void setRentAcceptanceSubList(List<RentAcceptanceSubEntity> rentAcceptanceSubList) {
        this.rentAcceptanceSubList = rentAcceptanceSubList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getAcceptanceSourceId() {
        return acceptanceSourceId;
    }

    public void setAcceptanceSourceId(Integer acceptanceSourceId) {
        this.acceptanceSourceId = acceptanceSourceId;
    }

    public Integer getEquipmentNum() {
        return equipmentNum;
    }

    public void setEquipmentNum(Integer equipmentNum) {
        this.equipmentNum = equipmentNum;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getSupplierSignId() {
        return supplierSignId;
    }

    public void setSupplierSignId(String supplierSignId) {
        this.supplierSignId = supplierSignId;
    }

    public String getSignArray() {
        return signArray;
    }

    public void setSignArray(String signArray) {
        this.signArray = signArray;
    }

    public String getSignArrayT() {
        return signArrayT;
    }

    public void setSignArrayT(String signArrayT) {
        this.signArrayT = signArrayT;
    }
}
