package com.ejianc.business.proequipmentcorprent.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 租赁设备台账
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_rent_parameter")
public class RentParameterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 设备名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="factory_code")
    private String factoryCode; // 设备出厂编号
    @TableField(value="category_id")
    private Long categoryId; // 设备类别id
    @TableField(value="category_name")
    private String categoryName; // 设备类别名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit_name")
    private String unitName; // 单位
    @TableField(value="rent_num")
    private Integer rentNum; // 租赁数量
    @TableField(value="plan_into_date")
    private Date planIntoDate; // 计划进程日期
    @TableField(value="plan_out_date")
    private Date planOutDate; // 计划出场日期
    @TableField(value="production_manufactor")
    private String productionManufactor; // 生产厂家
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编号
    @TableField(value="equipment_id")
    private Long equipmentId; // 设备id
    @TableField(value="num")
    private Integer num; // 数量/选择数量/送货数量
    @TableField(value="rent_type_id")
    private Integer rentTypeId; // 租赁方式id
    @TableField(value="rent_type_name")
    private String rentTypeName; // 租赁方式名称
    @TableField(value="acceptance_id")
    private Long acceptanceId; // 验收单id
    @TableField(value="equipment_state")
    private Integer equipmentState; // 设备状态:1--进场,2--启用,3--停用,4--退场
    @TableField(value="equipment_cost")
    private BigDecimal equipmentCost; // 设备费用
    @TableField(value="acceptance_date")
    private Date acceptanceDate; // 验收日期
    @TableField(value="start_date")
    private Date startDate; // 启动日期
    @TableField(value="stop_date")
    private Date stopDate; // 停用日期
    @TableField(value="out_date")
    private Date outDate; // 退场日期
    @TableField(value="equipment_name")
    private String equipmentName; // 设备名称
    @TableField(value="price")
    private BigDecimal price; // 有税单价
    @TableField(value="not_tax_price")
    private BigDecimal notTaxPrice; // 无税单价
    @TableField(value="acceptance_detail_id")
    private Long acceptanceDetailId; // 验收单明细id
    @TableField(value="meter_rent_date")
    private Date meterRentDate; // 计租日期
    @TableField(value="operation_date")
    private Date operationDate; // 操作日期
    @TableField(value="quantities_num")
    private BigDecimal quantitiesNum; // 工程量数量
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="settlement_flag")
    private Integer settlementFlag; // 是否已计算租金（0-否，1-是）
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField("contract_code")
    private String contractCode; // 合同编码
    @TableField(value="engineering_id")
    private Long engineeringId; // 工程id
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField("rent_harbor_type")
    private Integer rentHarborType;//1-内租,2-外租

    @TableField(value="check_before_id")
    private Long checkBeforeId; //进场前验收
    @TableField(value="check_before_name")
    private String checkBeforeName; //
    @TableField(value="check_after_id")
    private Long checkAfterId; //安装后验收
    @TableField(value="check_after_name")
    private String checkAfterName; //

    @TableField(value="acceptance_name")
    private String acceptanceName; //验收名称
    @TableField(value="use_type")
    private Integer useType; // 使用状态1-闲置,2-再用

    @TableField(value="use_org_id")
    private Long useOrgId; //使用单位
    @TableField(value="use_org_name")
    private String useOrgName; //
    @TableField(value="use_org_code")
    private String useOrgCode; //
    @TableField(value="use_project_id")
    private Long useProjectId; //使用项目
    @TableField(value="use_project_name")
    private String useProjectName; //
    @TableField(value="use_project_code")
    private String useProjectCode; //
    @TableField(value="install_location")
    private String installLocation; // 安装位置
    /**
     * 止租日期
     */
    @TableField("rent_end_date")
    private Date rentEndDate;

    @TableField(exist = false)
    @SubEntity(serviceName = "rentParameterDetailService", pidName = "parameterId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentParameterDetailEntity> rentParameterDetailList = new ArrayList<>(); // 租金计算日租明细

    public List<RentParameterDetailEntity> getRentParameterDetailList() {
        return rentParameterDetailList;
    }

    public Date getRentEndDate() {
        return rentEndDate;
    }

    public void setRentEndDate(Date rentEndDate) {
        this.rentEndDate = rentEndDate;
    }

    public Long getCheckBeforeId() {
        return checkBeforeId;
    }

    public void setCheckBeforeId(Long checkBeforeId) {
        this.checkBeforeId = checkBeforeId;
    }

    public String getCheckBeforeName() {
        return checkBeforeName;
    }

    public void setCheckBeforeName(String checkBeforeName) {
        this.checkBeforeName = checkBeforeName;
    }

    public Long getCheckAfterId() {
        return checkAfterId;
    }

    public void setCheckAfterId(Long checkAfterId) {
        this.checkAfterId = checkAfterId;
    }

    public String getCheckAfterName() {
        return checkAfterName;
    }

    public void setCheckAfterName(String checkAfterName) {
        this.checkAfterName = checkAfterName;
    }

    public String getAcceptanceName() {
        return acceptanceName;
    }

    public void setAcceptanceName(String acceptanceName) {
        this.acceptanceName = acceptanceName;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public Long getUseOrgId() {
        return useOrgId;
    }

    public void setUseOrgId(Long useOrgId) {
        this.useOrgId = useOrgId;
    }

    public String getUseOrgName() {
        return useOrgName;
    }

    public void setUseOrgName(String useOrgName) {
        this.useOrgName = useOrgName;
    }

    public String getUseOrgCode() {
        return useOrgCode;
    }

    public void setUseOrgCode(String useOrgCode) {
        this.useOrgCode = useOrgCode;
    }

    public Long getUseProjectId() {
        return useProjectId;
    }

    public void setUseProjectId(Long useProjectId) {
        this.useProjectId = useProjectId;
    }

    public String getUseProjectName() {
        return useProjectName;
    }

    public void setUseProjectName(String useProjectName) {
        this.useProjectName = useProjectName;
    }

    public String getUseProjectCode() {
        return useProjectCode;
    }

    public void setUseProjectCode(String useProjectCode) {
        this.useProjectCode = useProjectCode;
    }

    public void setRentParameterDetailList(List<RentParameterDetailEntity> rentParameterDetailList) {
        this.rentParameterDetailList = rentParameterDetailList;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Integer getRentNum() {
        return rentNum;
    }

    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    public Date getPlanOutDate() {
        return planOutDate;
    }

    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
    public Integer getRentTypeId() {
        return rentTypeId;
    }

    public void setRentTypeId(Integer rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public Long getAcceptanceId() {
        return acceptanceId;
    }

    public void setAcceptanceId(Long acceptanceId) {
        this.acceptanceId = acceptanceId;
    }
    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }
    public BigDecimal getEquipmentCost() {
        return equipmentCost;
    }

    public void setEquipmentCost(BigDecimal equipmentCost) {
        this.equipmentCost = equipmentCost;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getStopDate() {
        return stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNotTaxPrice() {
        return notTaxPrice;
    }

    public void setNotTaxPrice(BigDecimal notTaxPrice) {
        this.notTaxPrice = notTaxPrice;
    }
    public Long getAcceptanceDetailId() {
        return acceptanceDetailId;
    }

    public void setAcceptanceDetailId(Long acceptanceDetailId) {
        this.acceptanceDetailId = acceptanceDetailId;
    }
    public Date getMeterRentDate() {
        return meterRentDate;
    }

    public void setMeterRentDate(Date meterRentDate) {
        this.meterRentDate = meterRentDate;
    }
    public Date getOperationDate() {
        return operationDate;
    }

    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }
    public BigDecimal getQuantitiesNum() {
        return quantitiesNum;
    }

    public void setQuantitiesNum(BigDecimal quantitiesNum) {
        this.quantitiesNum = quantitiesNum;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSettlementFlag() {
        return settlementFlag;
    }

    public void setSettlementFlag(Integer settlementFlag) {
        this.settlementFlag = settlementFlag;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getEngineeringId() {
        return engineeringId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getInstallLocation() {
        return installLocation;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
    }
}
