package com.ejianc.business.proequipmentcorprent.rent.mapper;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractChangeVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettlementVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 租赁合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface RentContractMapper extends BaseCrudMapper<RentContractEntity> {
    /**
     * 查询数量
     * @param queryParam
     * @return
     */
    public Integer countNumber(Map<String, Object> queryParam);

    /**
     * 分页查询
     * @param queryParam
     * @return
     */
    List<RentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> queryParam);

    List<RentContractChangeVO> getRentContractChangeList(@Param("contractIds")List<Long> contractIds);
    List<RentSettlementVO> getRentSettlementList(@Param("contractIds")List<Long> contractIds);



    @Select("select * from ejc_proequipmentcorp_rent_contract where dr = 0 and create_time >= #{time} or update_time >= #{time}")
    List<RentContractEntity> getContractListByTime(Date qDate);

    //需从三个子表中获取数据
    //日租
    @Select({
            "<script>",
            "select * from ejc_proequipmentcorp_rent_day_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentDayDetailedEntity> getDayDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //月租
    @Select({
            "<script>",
            "select * from ejc_proequipmentcorp_rent_month_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentMonthDetailedEntity> getMonthDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

    //工程量租
    @Select({
            "<script>",
            "select * from ejc_proequipmentcorp_rent_quantities_detailed where dr = 0 and pid in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<RentQuantitiesDetailedEntity> getQuantitiesDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

}
