package com.ejianc.business.proequipmentcorprent.rent.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * 租赁设备验收
 *
 * @author generator
 *
 */
public interface IRentAcceptanceService extends IBaseService<RentAcceptanceEntity> {

    public void saveOrUpdates(RentAcceptanceEntity entity);

    public RentAcceptanceEntity selectByContractId(Long contractId);

    void deletes(List<RentAcceptanceVO> vos);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url);

    Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode);

	/**
	 * 根据项目id、验收日期查询设备租赁单据数量
	 *
	 * @param projectId 项目id
	 * @param checkDate 验收日期
	 *
	 * @return Integer
	 */
	Integer countBillNum(Long projectId, Date checkDate);


	List<RentAcceptanceSubVO> refRentAcceptanceDataDetail(Page<RentAcceptanceSubVO> page, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
}
