package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentChangeTotalPlanSubService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentTotalPlanService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentTotalPlanSubService;
import com.ejianc.business.proequipmentcorprent.rent.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.proequipmentcorprent.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.rent.mapper.RentChangeTotalPlanMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentChangeTotalPlanService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 租赁设备总计划便更主表
 * 
 * @author generator
 * 
 */
@Service("rentChangeTotalPlanService")
public class RentChangeTotalPlanServiceImpl extends BaseServiceImpl<RentChangeTotalPlanMapper, RentChangeTotalPlanEntity> implements IRentChangeTotalPlanService{
    @Autowired
    private IRentChangeTotalPlanSubService rentChangeTotalPlanSubService;
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;

    @Autowired
    private IRentTotalPlanService totalPlanService;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IRentChangeTotalPlanService service;




    @Override
    public RentChangeTotalPlanVO insertOrUpdate(RentChangeTotalPlanVO saveOrUpdateVO, Boolean isControl) {
        RentChangeTotalPlanEntity entity = BeanMapper.map(saveOrUpdateVO, RentChangeTotalPlanEntity.class);
        if (!isControl){
            if(entity.getId() == null || entity.getId() == 0){
                for (RentChangeTotalPlanSubEntity sub : entity.getTotalPlanSubList()){
                    sub.setId(null);
                    sub.setRowState("add");
                }
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            service.saveOrUpdates(entity);
        }
        RentChangeTotalPlanVO vo = BeanMapper.map(entity, RentChangeTotalPlanVO.class);
        if (!isControl){
            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree(vo.getTotalPlanSubList()));
        }
        if (null ==vo.getId() && isControl) {
            vo.setId(IdWorker.getId());
            List<RentChangeTotalPlanSubVO> totalPlanSubList = vo.getTotalPlanSubList();
            for (RentChangeTotalPlanSubVO rentTotalPlanSubVO : totalPlanSubList){
                if(rentTotalPlanSubVO.getId() == null){
                    rentTotalPlanSubVO.setId(IdWorker.getId());
                }
            }
        }
        return vo;
    }

    @Override
    public RentChangeTotalPlanVO queryDetail(Long id) {
        RentChangeTotalPlanEntity entity = service.selectById(id);
        RentChangeTotalPlanVO vo = BeanMapper.map(entity, RentChangeTotalPlanVO.class);
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())){

            vo.setTotalPlanSubList(TreeNodeBUtil.buildTree(vo.getTotalPlanSubList()));
        }
        return vo;
    }

    @Override
    public List<RentChangeTotalPlanVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<RentChangeTotalPlanEntity> changeEntities = baseMapper.selectList(new QueryWrapper<RentChangeTotalPlanEntity>()
                .eq("total_id", id)
                .in("bill_state", billStatus).orderByDesc("change_date"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<RentChangeTotalPlanVO> changeVos = BeanMapper.mapList(changeEntities, RentChangeTotalPlanVO.class);
            for (RentChangeTotalPlanVO cvo : changeVos) {
                String historyBillCode = cvo.getCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    /**
     * 保存
     * @param entity
     */
    @Override
    @Transactional
    public void saveOrUpdates(RentChangeTotalPlanEntity entity) {

        if(CollectionUtils.isNotEmpty(entity.getTotalPlanSubList())){
            saveOrUpdateChild(entity);
        }
        long changeId = entity.getId()==null?IdWorker.getId():entity.getId();//生成一个id
        RentTotalPlanEntity rentTotalPlanEntity =totalPlanService.selectById(entity.getTotalId());
        rentTotalPlanEntity.setChangingMny(entity.getChangingMny());//变更中金额
        rentTotalPlanEntity.setChangeCode(entity.getCode());
        rentTotalPlanEntity.setChangeId(changeId);
        rentTotalPlanEntity.setChangeStatus(2);
        rentTotalPlanEntity.setBeforeChangeMny(rentTotalPlanEntity.getTemporaryAmount());

        totalPlanService.saveOrUpdate(rentTotalPlanEntity);

        //推送目标成本
        //删除之前数据
        //删除旧的目标成本
        if (entity.getId() == null){
            ExecutionVO executionVO1;
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            QueryWrapper<RentChangeTotalPlanEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("total_id", entity.getTotalId()).orderByDesc("create_time");
            List<RentChangeTotalPlanEntity> list = super.list(wrapper);

            if (list.size() > 0) {
                executionVO1 = targetCost(list.get(0),null);
            }else {
                executionVO1 = rentTotalPlanService.targetCost(rentTotalPlanEntity);
            }
            totalExecutionVOList.add(executionVO1.getTotalVO());
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("删除旧目标成本失败！");
            }
        }
        entity.setId(changeId);
        this.saveOrUpdate(entity,false);
        ExecutionVO executionVO1 = targetCost(entity,null);
        // 推送新目标成本
        CommonResponse<String> response = executionApi.aggPush(executionVO1);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败！");
        }

    }
    @Override
    public ExecutionVO targetCost(RentChangeTotalPlanEntity entity, Long lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220309000000002");
        totalVO.setBussinessType(BussinessTypeEnum.设备总计划.getCode());
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/totalPlan/totalChangeCard?id=" + entity.getId());
        totalVO.setBillDate(entity.getOrganizationDate().toString());
        totalVO.setLastSourceId(lastSourceId);
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (RentChangeTotalPlanSubEntity rentTotalPlanSubEntity : entity.getTotalPlanSubList()) {
            checkMoney = checkMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            checkTaxMoney = checkTaxMoney.add(rentTotalPlanSubEntity.getTemporaryAmount());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(rentTotalPlanSubEntity.getId());
            detailExecutionVO.setSourceBillId(entity.getId());
            detailExecutionVO.setCategoryId(rentTotalPlanSubEntity.getEquipmentTypeId());
            detailExecutionVO.setCategoryName(rentTotalPlanSubEntity.getEquipmentTypeName());
            detailExecutionVO.setCode(rentTotalPlanSubEntity.getEquipmentCode());
            detailExecutionVO.setCategoryContainFlag(false);

            //判断是否是分类
            if (rentTotalPlanSubEntity.getEquipmentId()==null){
                detailExecutionVO.setCategoryFlag(true);
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentTypeId());
            }else {
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentTotalPlanSubEntity.getEquipmentId());
            }

            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
            detailExecutionVO.setName(rentTotalPlanSubEntity.getEquipmentName());
//            detailExecutionVO.setUnitId(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setUnitName(rentTotalPlanSubEntity.getMeteringUnit());
            detailExecutionVO.setSpec(rentTotalPlanSubEntity.getSpecs());
            detailExecutionVO.setNum(rentTotalPlanSubEntity.getPlanTotal());
            detailExecutionVO.setMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailExecutionVO.setTaxMoney(rentTotalPlanSubEntity.getTemporaryAmount());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void delete(RentChangeTotalPlanEntity entity) {
        //目标成本推送
        //删除数据
        RentChangeTotalPlanEntity rentChangeTotalPlanEntity =service.selectById(entity.getId());
        RentTotalPlanEntity rentTotalPlanEntity = rentTotalPlanService.selectById(entity.getTotalId());
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        ExecutionVO executionVO = targetCost(rentChangeTotalPlanEntity,null);
        totalExecutionVOList.add(executionVO.getTotalVO());

        logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        //推送上一版数据
        //目标成本推送
        ExecutionVO executionVO1;
        executionVO1 = rentTotalPlanService.targetCost(rentTotalPlanEntity);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO1));
        CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
        if (!response1.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }


        this.removeById(entity);
        RentTotalPlanEntity planEntity =totalPlanService.selectById(entity.getTotalId());
        planEntity.setChangeStatus(1);
        totalPlanService.saveOrUpdate(planEntity);

    }

    /**
     * 保存子表
     * @param entity
     */
    @Transactional
    public void saveOrUpdateChild(RentChangeTotalPlanEntity entity) {
        List<RentChangeTotalPlanSubEntity> listbs = entity.getTotalPlanSubList();
        Map<Long,Long> idMap=new HashMap<>();
        for(RentChangeTotalPlanSubEntity cdEntity:listbs){
            if(cdEntity.getParentId() ==999L){
                idMap.put(cdEntity.getDocCategoryId(),cdEntity.getId());
            }
        }

        for(RentChangeTotalPlanSubEntity cdEntity:listbs){
            if(!cdEntity.getParentId().equals(999L)){
                Long parentId =idMap.get(cdEntity.getDocCategoryId());
                cdEntity.setParentId(parentId != null?parentId:entity.getProjectId());
                cdEntity.setTid(cdEntity.getId());

            }else{
                cdEntity.setTid(cdEntity.getId());
            }
        }
        rentChangeTotalPlanSubService.saveOrUpdateBatch(listbs,listbs.size(),false);
    }

    @Override
    public ParamsCheckVO targetCostCtrl(RentChangeTotalPlanVO totalPlanVO) {
        RentChangeTotalPlanVO contractVO1 = insertOrUpdate(totalPlanVO, true);
        //删除旧的目标成本
        Long lastSourceId = null;
        QueryWrapper<RentChangeTotalPlanEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("total_id", totalPlanVO.getTotalId()).orderByDesc("create_time");
        List<RentChangeTotalPlanEntity> list = super.list(wrapper);
        RentTotalPlanEntity rentTotalPlanEntity = rentTotalPlanService.selectById(totalPlanVO.getTotalId());

        if (list.size() > 0) {
            lastSourceId = list.get(0).getId();
        }else {
            lastSourceId = rentTotalPlanEntity.getId();
        }


        ExecutionVO executionVO = targetCost(BeanMapper.map(contractVO1, RentChangeTotalPlanEntity.class),lastSourceId);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentChangeTotalPlanVO contractVO = queryDetail(id);
        ExecutionVO executionVO = targetCost(BeanMapper.map(contractVO, RentChangeTotalPlanEntity.class),null);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }
}
