package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentTotalPlanSubMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("rentTotalPlan") 
public class RentTotalPlanBpmServiceImpl implements ICommonBusinessService {
     @Autowired
	 private IRentTotalPlanService rentTotalPlanService;
     @Autowired
	 private IRentEquipmentPlanSubService rentEquipmentPlanSubService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentTotalPlanEntity totalPlanEntity = rentTotalPlanService.selectById(billId);
		if(totalPlanEntity.getChangeStatus() == 2){
			return CommonResponse.error("总计划变更中，不允许回退!");
		}

		List<RentTotalPlanSubEntity> subEntityList = totalPlanEntity.getTotalPlanSubList();
		if(CollectionUtils.isNotEmpty(subEntityList)){
			List<Long> batchIds = subEntityList.stream().map(RentTotalPlanSubEntity::getId).collect(Collectors.toList());
			QueryWrapper<RentEquipmentPlanSubEntity> query = new QueryWrapper<RentEquipmentPlanSubEntity>();
			query.in("source_id", batchIds);
			query.eq("dr", 0);
			List<RentEquipmentPlanSubEntity> rentEquipmentPlanList = rentEquipmentPlanSubService.list(query);
			if(CollectionUtils.isNotEmpty(rentEquipmentPlanList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
