/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.temporary.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.bean.TemporaryUseRecordEntity;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.service.ITemporaryUseRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="temporaryUseRecord")
public class TemporaryUseRecordBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ITemporaryUseRecordService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TemporaryUseRecordEntity entity = (TemporaryUseRecordEntity)((Object)this.service.selectById(billId));
        boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (!pushFlag) {
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        TemporaryUseRecordEntity entity = (TemporaryUseRecordEntity)((Object)this.service.selectById(billId));
        if (entity.getNotSignature() != null && entity.getNotSignature() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        List<TemporaryUseRecordSubEntity> subList = entity.getTemporaryUseRecordSubList();
        if (CollectionUtils.isNotEmpty(subList)) {
            for (TemporaryUseRecordSubEntity subEntity : subList) {
                if (subEntity.getSettleFlag() == null || subEntity.getSettleFlag() != 1) continue;
                return CommonResponse.error((String)"\u5355\u636e\u88ab\u7ed3\u7b97\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TemporaryUseRecordEntity entity = (TemporaryUseRecordEntity)((Object)this.service.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(entity, billTypeCode);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }
}

