package com.ejianc.business.acceptance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.acceptance.hystrix.IPurchaseAcceptanceHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 设备采购
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@FeignClient(
		name = "ejc-proequipmentp-web",
		url = "${common.env.feign-client-url}",
		path = "ejc-proequipmentp-web",
		fallback = IPurchaseAcceptanceHystrix.class
)
public interface IPurchaseAcceptanceApi {

	/**
	 * 根据项目id、验收日期查询设备采购单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return CommonResponse<Integer>
	 */
	@PostMapping(value = "/api/purchaseAcceptance/countBillNum")
	CommonResponse<Integer> countBillNum(@RequestBody JSONObject jsonObject);

}
