package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.consts.AssetRecordTypeEnum;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.asset.vo.AssetAllotInDetailVO;

/**
 * 固定资产调入表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产调入表")
public class AssetAllotInVO extends BaseVO implements IAssetRecord {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("设备调出单id")
    private Long allocatOutId;
    @ApiModelProperty("调入范围 1-项目，2-组织")
    private Integer allocatRange;
    @ApiModelProperty("调入项目id")
    private Long projectId;
    @ApiModelProperty("调入项目名称")
    private String projectName;
    @ApiModelProperty("调入组织id")
    private Long orgId;
    @ApiModelProperty("调入组织编码")
    private String orgCode;
    @ApiModelProperty("调入组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("调出的时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;
    @ApiModelProperty("调出金额")
    private BigDecimal outMny;
    @ApiModelProperty("调出金额(有税)")
    private BigDecimal outTaxMny;
    @ApiModelProperty("调拨方式 1 资产盘活 2 自制")
    private Integer allocatType;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人部门id")
    private Long departmentId;
    @ApiModelProperty("经办人部门")
    private String departmentName;
    @ApiModelProperty("调出范围 1-项目，2-组织")
    private Integer outAllocatRange;
    @ApiModelProperty("调出项目id")
    private Long outProjectId;
    @ApiModelProperty("调出项目名称")
    private String outProjectName;
    @ApiModelProperty("调出项目部id")
    private Long outOrgId;
    @ApiModelProperty("调出项目部名称")
    private String outOrgName;
    @ApiModelProperty("调出项目部编码")
    private String outOrgCode;
    @ApiModelProperty("调出上级组织id")
    private Long outParentOrgId;
    @ApiModelProperty("调出上级组织名称")
    private String outParentOrgName;
    @ApiModelProperty("调出上级组织编码")
    private String outParentOrgCode;
    @ApiModelProperty("调出设备名称集合")
    private String equipmentNames;
    @ApiModelProperty("通知收料人id")
    private Long notifyReceiverId;
    @ApiModelProperty("通知收料人")
    private String notifyReceiverName;
    @ApiModelProperty("调入组织收料人")
    private String receiverName;
    @ApiModelProperty("收料时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate;
    @ApiModelProperty("通过时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date passDate;
    @ApiModelProperty("退回原因")
    private String returnReason;
    @ApiModelProperty("收料状态 1、待收；2、已收；3、退回")
    private Integer receiveState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("收料人id")
    private Long receiverPersonId;
    @ApiModelProperty("收料人")
    private String receiverPerson;
    @ApiModelProperty("财务调拨 0-未完成，1-已完成")
    private Integer financeAllotFlag;

    private String billStateName; //单据状态名称
    private String receiveStateName; //收料状态名称
    private String allocatTypeName; //调拨方式名称

    @ApiModelProperty("固定资产调入明细表")
    private List<AssetAllotInDetailVO> assetAllotInDetailList = new ArrayList<>();

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备调出单id
     */
    public Long getAllocatOutId() {
        return allocatOutId;
    }

    /**
     * 设备调出单id
     */
    public void setAllocatOutId(Long allocatOutId) {
        this.allocatOutId = allocatOutId;
    }
    /**
     * 调入范围 1-项目，2-组织
     */
    public Integer getAllocatRange() {
        return allocatRange;
    }

    /**
     * 调入范围 1-项目，2-组织
     */
    public void setAllocatRange(Integer allocatRange) {
        this.allocatRange = allocatRange;
    }
    /**
     * 调入项目id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 调入项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 调入项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 调入项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 调入组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 调入组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 调入组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 调入组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 调入组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 调入组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 调出的时间
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 调出的时间
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 调出金额
     */
    public BigDecimal getOutMny() {
        return outMny;
    }

    /**
     * 调出金额
     */
    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    /**
     * 调出金额(有税)
     */
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    /**
     * 调出金额(有税)
     */
    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    /**
     * 调拨方式 1 资产盘活 2 自制
     */
    public Integer getAllocatType() {
        return allocatType;
    }

    /**
     * 调拨方式 1 资产盘活 2 自制
     */
    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办人部门
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办人部门
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 调出范围 1-项目，2-组织
     */
    public Integer getOutAllocatRange() {
        return outAllocatRange;
    }

    /**
     * 调出范围 1-项目，2-组织
     */
    public void setOutAllocatRange(Integer outAllocatRange) {
        this.outAllocatRange = outAllocatRange;
    }
    /**
     * 调出项目id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getOutProjectId() {
        return outProjectId;
    }

    /**
     * 调出项目id
     */
    @ReferDeserialTransfer
    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    /**
     * 调出项目名称
     */
    public String getOutProjectName() {
        return outProjectName;
    }

    /**
     * 调出项目名称
     */
    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    /**
     * 调出组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOutOrgId() {
        return outOrgId;
    }

    /**
     * 调出组织id
     */
    @ReferDeserialTransfer
    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    /**
     * 调出组织名称
     */
    public String getOutOrgName() {
        return outOrgName;
    }

    /**
     * 调出组织名称
     */
    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public Long getOutParentOrgId() {
        return outParentOrgId;
    }

    public void setOutParentOrgId(Long outParentOrgId) {
        this.outParentOrgId = outParentOrgId;
    }

    public String getOutParentOrgName() {
        return outParentOrgName;
    }

    public void setOutParentOrgName(String outParentOrgName) {
        this.outParentOrgName = outParentOrgName;
    }

    public String getOutParentOrgCode() {
        return outParentOrgCode;
    }

    public void setOutParentOrgCode(String outParentOrgCode) {
        this.outParentOrgCode = outParentOrgCode;
    }

    /**
     * 调出设备名称集合
     */
    public String getEquipmentNames() {
        return equipmentNames;
    }

    /**
     * 调出设备名称集合
     */
    public void setEquipmentNames(String equipmentNames) {
        this.equipmentNames = equipmentNames;
    }
    /**
     * 通知收料人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getNotifyReceiverId() {
        return notifyReceiverId;
    }

    /**
     * 通知收料人id
     */
    @ReferDeserialTransfer
    public void setNotifyReceiverId(Long notifyReceiverId) {
        this.notifyReceiverId = notifyReceiverId;
    }
    /**
     * 通知收料人
     */
    public String getNotifyReceiverName() {
        return notifyReceiverName;
    }

    /**
     * 通知收料人
     */
    public void setNotifyReceiverName(String notifyReceiverName) {
        this.notifyReceiverName = notifyReceiverName;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    /**
     * 收料时间
     */
    public Date getReceiveDate() {
        return receiveDate;
    }

    /**
     * 收料时间
     */
    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    /**
     * 通过时间
     */
    public Date getPassDate() {
        return passDate;
    }

    /**
     * 通过时间
     */
    public void setPassDate(Date passDate) {
        this.passDate = passDate;
    }
    /**
     * 退回原因
     */
    public String getReturnReason() {
        return returnReason;
    }

    /**
     * 退回原因
     */
    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    /**
     * 收料状态 1、待收；2、已收；3、退回
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 收料状态 1、待收；2、已收；3、退回
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 收料人id
     */
    public Long getReceiverPersonId() {
        return receiverPersonId;
    }

    /**
     * 收料人id
     */
    public void setReceiverPersonId(Long receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }
    /**
     * 收料人
     */
    public String getReceiverPerson() {
        return receiverPerson;
    }

    /**
     * 收料人
     */
    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }
    /**
     * 财务调拨 0-未完成，1-已完成
     */
    public Integer getFinanceAllotFlag() {
        return financeAllotFlag;
    }

    /**
     * 财务调拨 0-未完成，1-已完成
     */
    public void setFinanceAllotFlag(Integer financeAllotFlag) {
        this.financeAllotFlag = financeAllotFlag;
    }
    
     /**
      * 固定资产调入明细表
      */
      public List<AssetAllotInDetailVO> getAssetAllotInDetailList() {
         return assetAllotInDetailList;
      }
     /**
      * 固定资产调入明细表
      */
     public void setAssetAllotInDetailList(List<AssetAllotInDetailVO> assetAllotInDetailList) {
         this.assetAllotInDetailList = assetAllotInDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getAllocatTypeName() {
        return allocatTypeName;
    }

    public void setAllocatTypeName(String allocatTypeName) {
        this.allocatTypeName = allocatTypeName;
    }

    @Override
    public List<AssetRecordVO> toRecordList() {
        List<AssetAllotInDetailVO> assetAllotInDetailList = this.getAssetAllotInDetailList();
        ArrayList<AssetRecordVO> assetRecordVOS = new ArrayList<>();
        for (AssetAllotInDetailVO assetAllotInDetailVO : assetAllotInDetailList) {
            AssetRecordVO recordVO = BeanMapper.map(assetAllotInDetailVO, AssetRecordVO.class);
            recordVO.setId(null);
            recordVO.setVersion(null);
            recordVO.setBillDate(new Date());
            recordVO.setSourceId(this.getId());
            recordVO.setSourceBillCode(this.getBillCode());
            recordVO.setSourceDetailId(assetAllotInDetailVO.getId());
            recordVO.setSourceType(AssetRecordTypeEnum.调入.getCode());
            recordVO.setSourceTypeName(AssetRecordTypeEnum.调入.getName());
            recordVO.setOrgId(this.getOrgId());
            recordVO.setOrgName(this.getOrgName());
            recordVO.setOrgCode(this.getOrgCode());
            recordVO.setParentOrgId(this.getParentOrgId());
            recordVO.setParentOrgName(this.getParentOrgName());
            recordVO.setParentOrgCode(this.getParentOrgCode());
            recordVO.setProjectId(this.getProjectId());
            recordVO.setProjectName(this.getProjectName());
            assetRecordVOS.add(recordVO);
        }
        return assetRecordVOS;
    }
}
