package com.ejianc.business.acceptance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.acceptance.vo.PurchaseAcceptanceSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
public class PurchaseAcceptanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 单据编号
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long projectId; // 项目id
    private String projectOrg; // 所属单位
    private Long projectOrgId; // 所属单位id
    private String contractName; // 合同名称
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String supplierName; // 供应商
    private Long supplierId; // 供应商idisContract
    private String propertyRightCompany; // 产权单位
    private Long propertyRightCompanyId; // 产权单位id
    private String manageCompany; // 管理单位
    private Long manageCompanyId; // 管理单位id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate; // 验收日期
    private String acceptancePsn; // 验收人
    private Long acceptancePsnId; // 验收人id
    private String manufactor; // 厂家:一致/不一致
    private String equipmentModel; // 设备型号:一致/不一致
    private String appearance; // 外观:一致/不一致
    private String bodyStructure; // 机体结构:良好/一般/差
    private String safeProtectDevice; // 安全防护装置：良好/一般/差
    private String testRun; // 试运行:合格/不合格
    private String skillInformation; // 技术资料:完备/不完备
    private String manufacturer; // 生产厂家
    private String certificateNum; // 合格证号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate; // 生产日期
    private String leaveFactoryCode; // 出厂编号
    private String randomTool; // 随机工具
    private String ability; // 能力
    private BigDecimal weight; // 重量（t）
    private BigDecimal power; // 动力（kw）
    private BigDecimal ownWeight; // 自重（t）
    private BigDecimal appearanceSize; // 外形尺寸（毫米）
    private String modelExplain; // 型号说明
    private String memo; // 备注
    private String originalBillPath; // 原始单据路径
    private String photoPath; // 现场照片路径
    private String projectMangerSign; // 项目经理签字
    private String supplierSign; // 供应商签字
    private Long projectDepartmentId; // 项目部ID
    private String projectDepartmentName; // 项目部名称
    private Boolean notSignature;//是否签字
    private Long equipmentId; // 设备ID
    private String equipmentCode; // 设备编码
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long equipmentTypeId; // 设备分类ID
    private Long sourceDetailId; //
    private String equipmentName; // 设备名称
    private String equipmentType; // 设备类别
    private String equipmentTypeCode; // 设备类别编码
    private String spec; // 规格型号
    private String company; // 计量单位
    private BigDecimal purchasePrice; // 含税单价
    private BigDecimal taxRate; // 税率
    private BigDecimal overageSettleTaxMny; //
    private BigDecimal contractNum; // 剩余可结算金额
    private String orgCode; // 项目部编码
    private Integer financePushFlag; // 是否推送财务1推送0不推送
    private Integer checkType; //验收类型
    private Integer isContract; // 是否有合同

    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;


    private String itemBrand; // 设备品牌

    private String produceManufacturer; // 生产厂商

    private String displacement; // 排量

    private String storageLocation; //存放地点
    @JsonFormat( pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date purchaseDate; // 购货日期

    @JsonFormat( pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dateManufacture;//生产日期

    private Long employeeId; //经办人id

    private String employeeName; // 经办人
    private BigDecimal money; // 金额（不含税）
    private BigDecimal tax; // 税额
    private BigDecimal totalMoney; // 金额（含税）
    private String moneyWord; // 金额大写
    private BigDecimal carTotalMoney; // 车身价（含税）
    private BigDecimal carMoney; // 车身价（不含税）
    private BigDecimal carTax; // 车身价（税额）
    private BigDecimal buyTotalMoney; // 购置税（含税）
    private BigDecimal buyMoney; // 购置税（不含税）
    private BigDecimal buyTax; // 购置税（税额）
    private BigDecimal boardTotalMoney; // 上牌费（含税）
    private BigDecimal boardMoney; // 上牌费（不含税）
    private BigDecimal boardTax; // 上牌费（税额）
    private BigDecimal amountTotalMoney; // 合计（含税）
    private BigDecimal amountMoney; // 合计（不含税）
    private BigDecimal amountTax; // 合计（税额）
    private Integer assetQuoteFlag; //固定资产引用状态：0-未引用，1-已引用

    private String billStatName;

    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getOrgId() {
        return orgId;
    }
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }


    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    @ReferSerialTransfer(referCode = "Material001")

    public Long getEquipmentId() {
        return equipmentId;
    }

    @ReferDeserialTransfer
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }

    public BigDecimal getOverageSettleTaxMny() {
        return overageSettleTaxMny;
    }

    public void setOverageSettleTaxMny(BigDecimal overageSettleTaxMny) {
        this.overageSettleTaxMny = overageSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    private List<PurchaseAcceptanceSubVO> purchaseAcceptanceSubList = new ArrayList<>(); // 设备购置验收-设备明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "purchaseContract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getPropertyRightCompany() {
        return propertyRightCompany;
    }

    public void setPropertyRightCompany(String propertyRightCompany) {
        this.propertyRightCompany = propertyRightCompany;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getPropertyRightCompanyId() {
        return propertyRightCompanyId;
    }

    @ReferDeserialTransfer
    public void setPropertyRightCompanyId(Long propertyRightCompanyId) {
        this.propertyRightCompanyId = propertyRightCompanyId;
    }
    public String getManageCompany() {
        return manageCompany;
    }

    public void setManageCompany(String manageCompany) {
        this.manageCompany = manageCompany;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getManageCompanyId() {
        return manageCompanyId;
    }
    @ReferDeserialTransfer
    public void setManageCompanyId(Long manageCompanyId) {
        this.manageCompanyId = manageCompanyId;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public String getAcceptancePsn() {
        return acceptancePsn;
    }

    public void setAcceptancePsn(String acceptancePsn) {
        this.acceptancePsn = acceptancePsn;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAcceptancePsnId() {
        return acceptancePsnId;
    }
    @ReferDeserialTransfer
    public void setAcceptancePsnId(Long acceptancePsnId) {
        this.acceptancePsnId = acceptancePsnId;
    }
    public String getManufactor() {
        return manufactor;
    }

    public void setManufactor(String manufactor) {
        this.manufactor = manufactor;
    }
    public String getEquipmentModel() {
        return equipmentModel;
    }

    public void setEquipmentModel(String equipmentModel) {
        this.equipmentModel = equipmentModel;
    }
    public String getAppearance() {
        return appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }
    public String getBodyStructure() {
        return bodyStructure;
    }

    public void setBodyStructure(String bodyStructure) {
        this.bodyStructure = bodyStructure;
    }
    public String getSafeProtectDevice() {
        return safeProtectDevice;
    }

    public void setSafeProtectDevice(String safeProtectDevice) {
        this.safeProtectDevice = safeProtectDevice;
    }
    public String getTestRun() {
        return testRun;
    }

    public void setTestRun(String testRun) {
        this.testRun = testRun;
    }
    public String getSkillInformation() {
        return skillInformation;
    }

    public void setSkillInformation(String skillInformation) {
        this.skillInformation = skillInformation;
    }
    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }
    public String getCertificateNum() {
        return certificateNum;
    }

    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }
    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }
    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }
    public String getRandomTool() {
        return randomTool;
    }

    public void setRandomTool(String randomTool) {
        this.randomTool = randomTool;
    }
    public String getAbility() {
        return ability;
    }

    public void setAbility(String ability) {
        this.ability = ability;
    }
    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
    public BigDecimal getPower() {
        return power;
    }

    public void setPower(BigDecimal power) {
        this.power = power;
    }
    public BigDecimal getOwnWeight() {
        return ownWeight;
    }

    public void setOwnWeight(BigDecimal ownWeight) {
        this.ownWeight = ownWeight;
    }
    public BigDecimal getAppearanceSize() {
        return appearanceSize;
    }

    public void setAppearanceSize(BigDecimal appearanceSize) {
        this.appearanceSize = appearanceSize;
    }
    public String getModelExplain() {
        return modelExplain;
    }

    public void setModelExplain(String modelExplain) {
        this.modelExplain = modelExplain;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getOriginalBillPath() {
        return originalBillPath;
    }

    public void setOriginalBillPath(String originalBillPath) {
        this.originalBillPath = originalBillPath;
    }

    public String getPhotoPath() {
        return photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }

    public String getSupplierSign() {
        return supplierSign;
    }

    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public List<PurchaseAcceptanceSubVO> getPurchaseAcceptanceSubList() {
        return purchaseAcceptanceSubList;
     }

     public void setPurchaseAcceptanceSubList(List<PurchaseAcceptanceSubVO> purchaseAcceptanceSubList) {
        this.purchaseAcceptanceSubList = purchaseAcceptanceSubList;
     }

    public Integer getFinancePushFlag() {
        return financePushFlag;
    }

    public void setFinancePushFlag(Integer financePushFlag) {
        this.financePushFlag = financePushFlag;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public Integer getIsContract() {
        return isContract;
    }

    public void setIsContract(Integer isContract) {
        this.isContract = isContract;
    }

    public String getItemBrand() {
        return itemBrand;
    }

    public void setItemBrand(String itemBrand) {
        this.itemBrand = itemBrand;
    }

    public String getProduceManufacturer() {
        return produceManufacturer;
    }

    public void setProduceManufacturer(String produceManufacturer) {
        this.produceManufacturer = produceManufacturer;
    }

    public String getDisplacement() {
        return displacement;
    }

    public void setDisplacement(String displacement) {
        this.displacement = displacement;
    }

    public String getStorageLocation() {
        return storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public Date getDateManufacture() {
        return dateManufacture;
    }

    public void setDateManufacture(Date dateManufacture) {
        this.dateManufacture = dateManufacture;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }

    public String getMoneyWord() {
        return moneyWord;
    }

    public void setMoneyWord(String moneyWord) {
        this.moneyWord = moneyWord;
    }

    public BigDecimal getCarTotalMoney() {
        return carTotalMoney;
    }

    public void setCarTotalMoney(BigDecimal carTotalMoney) {
        this.carTotalMoney = carTotalMoney;
    }

    public BigDecimal getCarMoney() {
        return carMoney;
    }

    public void setCarMoney(BigDecimal carMoney) {
        this.carMoney = carMoney;
    }

    public BigDecimal getCarTax() {
        return carTax;
    }

    public void setCarTax(BigDecimal carTax) {
        this.carTax = carTax;
    }

    public BigDecimal getBuyTotalMoney() {
        return buyTotalMoney;
    }

    public void setBuyTotalMoney(BigDecimal buyTotalMoney) {
        this.buyTotalMoney = buyTotalMoney;
    }

    public BigDecimal getBuyMoney() {
        return buyMoney;
    }

    public void setBuyMoney(BigDecimal buyMoney) {
        this.buyMoney = buyMoney;
    }

    public BigDecimal getBuyTax() {
        return buyTax;
    }

    public void setBuyTax(BigDecimal buyTax) {
        this.buyTax = buyTax;
    }

    public BigDecimal getBoardTotalMoney() {
        return boardTotalMoney;
    }

    public void setBoardTotalMoney(BigDecimal boardTotalMoney) {
        this.boardTotalMoney = boardTotalMoney;
    }

    public BigDecimal getBoardMoney() {
        return boardMoney;
    }

    public void setBoardMoney(BigDecimal boardMoney) {
        this.boardMoney = boardMoney;
    }

    public BigDecimal getBoardTax() {
        return boardTax;
    }

    public void setBoardTax(BigDecimal boardTax) {
        this.boardTax = boardTax;
    }

    public BigDecimal getAmountTotalMoney() {
        return amountTotalMoney;
    }

    public void setAmountTotalMoney(BigDecimal amountTotalMoney) {
        this.amountTotalMoney = amountTotalMoney;
    }

    public BigDecimal getAmountMoney() {
        return amountMoney;
    }

    public void setAmountMoney(BigDecimal amountMoney) {
        this.amountMoney = amountMoney;
    }

    public BigDecimal getAmountTax() {
        return amountTax;
    }

    public void setAmountTax(BigDecimal amountTax) {
        this.amountTax = amountTax;
    }

    public String getBillStatName() {
        return billStatName;
    }

    public void setBillStatName(String billStatName) {
        this.billStatName = billStatName;
    }

    public Integer getAssetQuoteFlag() {
        return assetQuoteFlag;
    }

    public void setAssetQuoteFlag(Integer assetQuoteFlag) {
        this.assetQuoteFlag = assetQuoteFlag;
    }
}
