package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产调入明细表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产调入明细表")
public class AssetAllotInDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long allocatId;
    @ApiModelProperty("固定资产id")
    private Long assetId;
    @ApiModelProperty("固定资产名称")
    private String assetName;
    @ApiModelProperty("固定资产编码")
    private String assetCode;
    @ApiModelProperty("设备分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("设备分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("财务资产id")
    private String financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("调拨税率")
    private BigDecimal allocatTaxRate;
    @ApiModelProperty("调拨金额")
    private BigDecimal allocatMny;
    @ApiModelProperty("调拨金额（有税）")
    private BigDecimal allocatTaxMny;
    @ApiModelProperty("调拨税额")
    private BigDecimal allocatTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("调拨差额(无税)")
    private BigDecimal allotDiffMny;
    @ApiModelProperty("调拨差额")
    private BigDecimal allotDiffTaxMny;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal originalValuePrice;
    @ApiModelProperty("原值单价(含税)")
    private BigDecimal originalValuePriceTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("出厂编号")
    private String leaveFactoryCode;


    /**
     * 主表id
     */
    public Long getAllocatId() {
        return allocatId;
    }

    /**
     * 主表id
     */
    public void setAllocatId(Long allocatId) {
        this.allocatId = allocatId;
    }
    /**
     * 固定资产id
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 固定资产id
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 固定资产名称
     */
    public String getAssetName() {
        return assetName;
    }

    /**
     * 固定资产名称
     */
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    /**
     * 固定资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 固定资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 设备分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 设备分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 财务资产id
     */
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 调拨税率
     */
    public BigDecimal getAllocatTaxRate() {
        return allocatTaxRate;
    }

    /**
     * 调拨税率
     */
    public void setAllocatTaxRate(BigDecimal allocatTaxRate) {
        this.allocatTaxRate = allocatTaxRate;
    }
    /**
     * 调拨金额
     */
    public BigDecimal getAllocatMny() {
        return allocatMny;
    }

    /**
     * 调拨金额
     */
    public void setAllocatMny(BigDecimal allocatMny) {
        this.allocatMny = allocatMny;
    }
    /**
     * 调拨金额（有税）
     */
    public BigDecimal getAllocatTaxMny() {
        return allocatTaxMny;
    }

    /**
     * 调拨金额（有税）
     */
    public void setAllocatTaxMny(BigDecimal allocatTaxMny) {
        this.allocatTaxMny = allocatTaxMny;
    }
    /**
     * 调拨税额
     */
    public BigDecimal getAllocatTax() {
        return allocatTax;
    }

    /**
     * 调拨税额
     */
    public void setAllocatTax(BigDecimal allocatTax) {
        this.allocatTax = allocatTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 调拨差额(无税)
     */
    public BigDecimal getAllotDiffMny() {
        return allotDiffMny;
    }

    /**
     * 调拨差额(无税)
     */
    public void setAllotDiffMny(BigDecimal allotDiffMny) {
        this.allotDiffMny = allotDiffMny;
    }
    /**
     * 调拨差额
     */
    public BigDecimal getAllotDiffTaxMny() {
        return allotDiffTaxMny;
    }

    /**
     * 调拨差额
     */
    public void setAllotDiffTaxMny(BigDecimal allotDiffTaxMny) {
        this.allotDiffTaxMny = allotDiffTaxMny;
    }
    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    /**
     * 原值单价(无税)
     */
    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    /**
     * 原值单价(无税)
     */
    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }
    /**
     * 原值单价(含税)
     */
    public BigDecimal getOriginalValuePriceTax() {
        return originalValuePriceTax;
    }

    /**
     * 原值单价(含税)
     */
    public void setOriginalValuePriceTax(BigDecimal originalValuePriceTax) {
        this.originalValuePriceTax = originalValuePriceTax;
    }
    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }
}
