package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产调出明细表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产调出明细表")
public class AssetAllotOutDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long allocatId;
    @ApiModelProperty("固定资产id")
    private Long assetId;
    @ApiModelProperty("固定资产编码")
    private String assetCode;
    @ApiModelProperty("固定资产名称")
    private String assetName;
    @ApiModelProperty("设备分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("设备分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("财务资产id")
    private String financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位 Id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("产权单位id")
    private Long propertyUnitId;
    @ApiModelProperty("产权单位")
    private String propertyUnit;
    @ApiModelProperty("管理单位id")
    private Long manageUnitId;
    @ApiModelProperty("管理单位")
    private String manageUnit;
    @ApiModelProperty("使用单位id")
    private Long useUnitId;
    @ApiModelProperty("使用单位")
    private String useUnit;
    @ApiModelProperty("原值(无税)")
    private BigDecimal originalValue;
    @ApiModelProperty("原值(含税)")
    private BigDecimal originalValueTax;
    @ApiModelProperty("净值(无税)")
    private BigDecimal netWorth;
    @ApiModelProperty("净值(含税)")
    private BigDecimal netWorthTax;
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal originalValuePrice;
    @ApiModelProperty("原值单价(含税)")
    private BigDecimal originalValuePriceTax;
    @ApiModelProperty("残值(含税)")
    private BigDecimal residualValueTax;
    @ApiModelProperty("残值(无税)")
    private BigDecimal residualValue;
    @ApiModelProperty("调拨税率")
    private BigDecimal allocatTaxRate;
    @ApiModelProperty("调拨金额")
    private BigDecimal allocatMny;
    @ApiModelProperty("调拨金额（有税）")
    private BigDecimal allocatTaxMny;
    @ApiModelProperty("调拨税额")
    private BigDecimal allocatTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("调拨差额(无税)")
    private BigDecimal allocatDiffMny;
    @ApiModelProperty("调拨差额")
    private BigDecimal allocatDiffTaxMny;
    @ApiModelProperty("核算对象id")
    private Long wbsId;
    @ApiModelProperty("核算对象code")
    private String wbsCode;
    @ApiModelProperty("核算对象name")
    private String wbsName;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目code")
    private String subjectCode;
    @ApiModelProperty("成本科目name")
    private String subjectName;
    @ApiModelProperty("出厂编号")
    private String leaveFactoryCode;
    

    /**
     * 主表id
     */
    public Long getAllocatId() {
        return allocatId;
    }

    /**
     * 主表id
     */
    public void setAllocatId(Long allocatId) {
        this.allocatId = allocatId;
    }
    /**
     * 固定资产id
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 固定资产id
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 固定资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 固定资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 
     */
    public String getAssetName() {
        return assetName;
    }

    /**
     * 
     */
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    /**
     * 设备分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 设备分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 财务资产id
     */
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位 Id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位 Id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 产权单位id
     */
    public Long getPropertyUnitId() {
        return propertyUnitId;
    }

    /**
     * 产权单位id
     */
    public void setPropertyUnitId(Long propertyUnitId) {
        this.propertyUnitId = propertyUnitId;
    }
    /**
     * 产权单位
     */
    public String getPropertyUnit() {
        return propertyUnit;
    }

    /**
     * 产权单位
     */
    public void setPropertyUnit(String propertyUnit) {
        this.propertyUnit = propertyUnit;
    }
    /**
     * 管理单位id
     */
    public Long getManageUnitId() {
        return manageUnitId;
    }

    /**
     * 管理单位id
     */
    public void setManageUnitId(Long manageUnitId) {
        this.manageUnitId = manageUnitId;
    }
    /**
     * 管理单位
     */
    public String getManageUnit() {
        return manageUnit;
    }

    /**
     * 管理单位
     */
    public void setManageUnit(String manageUnit) {
        this.manageUnit = manageUnit;
    }
    /**
     * 使用单位id
     */
    public Long getUseUnitId() {
        return useUnitId;
    }

    /**
     * 使用单位id
     */
    public void setUseUnitId(Long useUnitId) {
        this.useUnitId = useUnitId;
    }
    /**
     * 使用单位
     */
    public String getUseUnit() {
        return useUnit;
    }

    /**
     * 使用单位
     */
    public void setUseUnit(String useUnit) {
        this.useUnit = useUnit;
    }
    /**
     * 原值(无税)
     */
    public BigDecimal getOriginalValue() {
        return originalValue;
    }

    /**
     * 原值(无税)
     */
    public void setOriginalValue(BigDecimal originalValue) {
        this.originalValue = originalValue;
    }
    /**
     * 原值(含税)
     */
    public BigDecimal getOriginalValueTax() {
        return originalValueTax;
    }

    /**
     * 原值(含税)
     */
    public void setOriginalValueTax(BigDecimal originalValueTax) {
        this.originalValueTax = originalValueTax;
    }
    /**
     * 净值(无税)
     */
    public BigDecimal getNetWorth() {
        return netWorth;
    }

    /**
     * 净值(无税)
     */
    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }
    /**
     * 净值(含税)
     */
    public BigDecimal getNetWorthTax() {
        return netWorthTax;
    }

    /**
     * 净值(含税)
     */
    public void setNetWorthTax(BigDecimal netWorthTax) {
        this.netWorthTax = netWorthTax;
    }
    /**
     * 原值单价(无税)
     */
    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    /**
     * 原值单价(无税)
     */
    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }
    /**
     * 原值单价(含税)
     */
    public BigDecimal getOriginalValuePriceTax() {
        return originalValuePriceTax;
    }

    /**
     * 原值单价(含税)
     */
    public void setOriginalValuePriceTax(BigDecimal originalValuePriceTax) {
        this.originalValuePriceTax = originalValuePriceTax;
    }
    /**
     * 残值(含税)
     */
    public BigDecimal getResidualValueTax() {
        return residualValueTax;
    }

    /**
     * 残值(含税)
     */
    public void setResidualValueTax(BigDecimal residualValueTax) {
        this.residualValueTax = residualValueTax;
    }
    /**
     * 残值(无税)
     */
    public BigDecimal getResidualValue() {
        return residualValue;
    }

    /**
     * 残值(无税)
     */
    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }
    /**
     * 调拨税率
     */
    public BigDecimal getAllocatTaxRate() {
        return allocatTaxRate;
    }

    /**
     * 调拨税率
     */
    public void setAllocatTaxRate(BigDecimal allocatTaxRate) {
        this.allocatTaxRate = allocatTaxRate;
    }
    /**
     * 调拨金额
     */
    public BigDecimal getAllocatMny() {
        return allocatMny;
    }

    /**
     * 调拨金额
     */
    public void setAllocatMny(BigDecimal allocatMny) {
        this.allocatMny = allocatMny;
    }
    /**
     * 调拨单价（有税）
     */
    public BigDecimal getAllocatTaxMny() {
        return allocatTaxMny;
    }

    /**
     * 调拨单价（有税）
     */
    public void setAllocatTaxMny(BigDecimal allocatTaxMny) {
        this.allocatTaxMny = allocatTaxMny;
    }
    /**
     * 调拨税额
     */
    public BigDecimal getAllocatTax() {
        return allocatTax;
    }

    /**
     * 调拨税额
     */
    public void setAllocatTax(BigDecimal allocatTax) {
        this.allocatTax = allocatTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 调拨差额(无税)
     */
    public BigDecimal getAllocatDiffMny() {
        return allocatDiffMny;
    }

    /**
     * 调拨差额(无税)
     */
    public void setAllocatDiffMny(BigDecimal allocatDiffMny) {
        this.allocatDiffMny = allocatDiffMny;
    }
    /**
     * 调拨差额
     */
    public BigDecimal getAllocatDiffTaxMny() {
        return allocatDiffTaxMny;
    }

    /**
     * 调拨差额
     */
    public void setAllocatDiffTaxMny(BigDecimal allocatDiffTaxMny) {
        this.allocatDiffTaxMny = allocatDiffTaxMny;
    }
    /**
     * 核算对象id
     */
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    /**
     * 核算对象id
     */
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象code
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象code
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 核算对象name
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象name
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    /**
     * 成本科目id
     */
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目id
     */
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目code
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目code
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 成本科目name
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目name
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }
}
