package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 固定资产摊销明细（财务）
 * 
 * @author generator
 * 
 */
public class AssetAmortizeFinanceDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表id
    private String financeTypeCode; // 财务分类编码
    private String financeTypeName; // 财务分类名称
    private String detailAmortizeDate; // 摊销周期
    private BigDecimal detailAmortizeMny; // 本次摊销金额
    private String detailMemo; // 备注
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    public String getDetailAmortizeDate() {
        return detailAmortizeDate;
    }

    public void setDetailAmortizeDate(String detailAmortizeDate) {
        this.detailAmortizeDate = detailAmortizeDate;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getFinanceTypeCode() {
        return financeTypeCode;
    }

    public void setFinanceTypeCode(String financeTypeCode) {
        this.financeTypeCode = financeTypeCode;
    }
    public String getFinanceTypeName() {
        return financeTypeName;
    }

    public void setFinanceTypeName(String financeTypeName) {
        this.financeTypeName = financeTypeName;
    }


    public BigDecimal getDetailAmortizeMny() {
        return detailAmortizeMny;
    }

    public void setDetailAmortizeMny(BigDecimal detailAmortizeMny) {
        this.detailAmortizeMny = detailAmortizeMny;
    }


    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    
}
