package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 固定资产流转记录表
 * 
 * @author generator
 * 
 */
@ApiModel("固定资产流转记录表")
public class AssetRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目组织")
    private Long orgId;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("项目组织名称")
    private String orgName;
    @ApiModelProperty("设备分类id")
    private Long equipmentTypeId;
    @ApiModelProperty("设备分类编码")
    private String equipmentTypeCode;
    @ApiModelProperty("设备分类名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("资产id")
    private Long assetId;
    @ApiModelProperty("资产编码")
    private String assetCode;
    @ApiModelProperty("资产名称")
    private String assetName;
    @ApiModelProperty("财务资产分类id")
    private String financeTypeId;
    @ApiModelProperty("财务资产id")
    private String financeAssetId;
    @ApiModelProperty("财务资产编码")
    private String financeAssetCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位 Id")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    @ApiModelProperty("来源单据id")
    private Long sourceId;
    @ApiModelProperty("来源单据编号")
    private String sourceBillCode;
    @ApiModelProperty("来源单据子表id")
    private Long sourceDetailId;
    @ApiModelProperty("来源操作标识1验收2新增3调出4调入5报废6处置")
    private Integer sourceType;
    @ApiModelProperty("来源操作标识名称")
    private String sourceTypeName;
    @ApiModelProperty("来源单据url")
    private String sourceUrl;
    @ApiModelProperty("来源单据名称")
    private String sourceBliName;

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 设备分类id
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备分类id
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备分类编码
     */
    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    /**
     * 设备分类编码
     */
    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    /**
     * 设备分类名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备分类名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 资产id
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 资产id
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 资产名称
     */
    public String getAssetName() {
        return assetName;
    }

    /**
     * 资产名称
     */
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }
    /**
     * 财务资产分类id
     */
    public String getFinanceTypeId() {
        return financeTypeId;
    }

    /**
     * 财务资产分类id
     */
    public void setFinanceTypeId(String financeTypeId) {
        this.financeTypeId = financeTypeId;
    }
    /**
     * 财务资产id
     */
    public String getFinanceAssetId() {
        return financeAssetId;
    }

    /**
     * 财务资产id
     */
    public void setFinanceAssetId(String financeAssetId) {
        this.financeAssetId = financeAssetId;
    }
    /**
     * 财务资产编码
     */
    public String getFinanceAssetCode() {
        return financeAssetCode;
    }

    /**
     * 财务资产编码
     */
    public void setFinanceAssetCode(String financeAssetCode) {
        this.financeAssetCode = financeAssetCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位 Id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位 Id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 时间
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 时间
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 来源单据id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源单据id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源单据编号
     */
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    /**
     * 来源单据编号
     */
    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    /**
     * 来源单据子表id
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源单据子表id
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源操作标识1验收2新增3调出4调入5报废6处置
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源操作标识1验收2新增3调出4调入5报废6处置
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源操作标识名称
     */
    public String getSourceTypeName() {
        return sourceTypeName;
    }

    /**
     * 来源操作标识名称
     */
    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getSourceBliName() {
        return sourceBliName;
    }

    public void setSourceBliName(String sourceBliName) {
        this.sourceBliName = sourceBliName;
    }
}
