package com.ejianc.business.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 资产流传记录类型
 * @date 2022/6/25
 */
public enum AssetRecordTypeEnum {



    验收(0, "验收"),
    新增(1, "新增"),
    调出(2, "调出"),
    调入(3, "调入"),
    报废(4, "报废"),
    处置(5, "处置");

    private Integer code;

    private String name;


    private static Map<Integer, String> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(AssetRecordTypeEnum.class).stream().collect(Collectors.toMap(AssetRecordTypeEnum::getCode, AssetRecordTypeEnum::getName));
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }


    AssetRecordTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
