package com.ejianc.business.settlement.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资价格库预警参数
 */
public enum MaterialCostPriceCheckTypeEnum {

    设备采购合同(1, "设备采购合同"),
    设备采购结算(2, "设备采购结算"),
    ;
    private Integer code;
    private String description;
    private static Map<Integer, MaterialCostPriceCheckTypeEnum> enumMap = new HashMap<>();

    MaterialCostPriceCheckTypeEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(MaterialCostPriceCheckTypeEnum.class).stream().collect(Collectors.toMap(MaterialCostPriceCheckTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static MaterialCostPriceCheckTypeEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}

