package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetRecordVO;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 固定资产
 *
 * @author generator
 */
@Service("assetService")
public class AssetServiceImpl extends BaseServiceImpl<AssetMapper, AssetEntity> implements IAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AssetMapper assetMapper;
    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202206000070";//单据类型编码

    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = purchaseAcceptanceService.selectById(billId);
        AssetEntity entity = new AssetEntity();
        if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()) {
            //封装数据 组织信息
            entity.setOrgId(purchaseAcceptanceEntity.getParentOrgId());
            entity.setOrgName(purchaseAcceptanceEntity.getParentOrgName());
            entity.setOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
            entity.setParentOrgId(purchaseAcceptanceEntity.getOrgId());
            entity.setParentOrgName(purchaseAcceptanceEntity.getOrgName());
            entity.setParentOrgCode(purchaseAcceptanceEntity.getOrgCode());
            entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
            entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            //封装数据 项目信息
            entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
            entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
            //设置编制人
            entity.setEmployeeId(sessionManager.getUserContext().getUserId());
            entity.setEmployeeName(sessionManager.getUserContext().getUserName());
            entity.setDepartmentId(sessionManager.getUserContext().getDeptId());
            entity.setDepartmentName(sessionManager.getUserContext().getDeptName());
            List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(purchaseAcceptanceSubList)) {
                //一只只能验收一台设备
                PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
                //原值 净值
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply(purchaseAcceptanceSubEntity.getPurchasePrice(), ComputeUtil.safeDiv(purchaseAcceptanceSubEntity.getTaxRate(), new BigDecimal(100)));
                BigDecimal originalValue = ComputeUtil.safeSub(purchaseAcceptanceSubEntity.getPurchasePrice(), tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                //todo 残值没有设置
                //封装设备信息
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
//                entity.setUnitId(purchaseAcceptanceSubEntity.getCompanyId());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());
                entity.setEquipmentStatus(1);
                entity.setAssetStatus(0);
                //大于2000 资产类型 1:固定资产 2:普通资产
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000)) != -1) {
                    entity.setAssetType(1);
                } else {
                    entity.setAssetType(2);
                }
                Map<Long, Long> amortizeSetmap = new HashMap<>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(), purchaseAcceptanceSubEntity.getEquipmentTypeId());
                logger.info("调用固定资产摊销设置:" + JSONObject.toJSONString(entity));
                Map<Long, AmortizeSetEntity> amortizeMap = amortizeSetService.getSet(amortizeSetmap, entity.getOrgId());
                logger.info("固定资产摊销设置:" + JSONObject.toJSONString(amortizeMap));
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity != null) {
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    logger.info("调用固定资产摊销设置残值率残值率:" + residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(residualValueRate, new BigDecimal(100)),
                            purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(residualValueRate, new BigDecimal(100)),
                            originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }
            }
            entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
            //// 来源 1：验收 2：期初 3：调拨
            entity.setSourceType(1);
            entity.setFinancePushState(0);
            entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
            //设备出厂指标
            entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
            entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
            entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
            entity.setLeaveFactoryCode(purchaseAcceptanceEntity.getLeaveFactoryCode());
            entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
            entity.setAbility(purchaseAcceptanceEntity.getAbility());
            entity.setWeight(purchaseAcceptanceEntity.getWeight());
            entity.setPower(purchaseAcceptanceEntity.getPower());
            entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
            entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
            entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
            entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
            entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
            entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
            entity.setBillState(1);
            //复制附件
            AssetVO vo = BeanMapper.map(entity, AssetVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        logger.info("推送设备卡片的信息:" + JSONObject.toJSONString(entity));
        boolean b = assetService.saveOrUpdate(entity, false);
        CommonResponse<String> commonResponse =
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()),
                        "BT220323000000007", "photoPath", String.valueOf(entity.getId()), "EJCBT202206000070",
                        "ASSET002");
        logger.info("复制图片:" + commonResponse.isSuccess());
        logger.info("复制图片返回的内容:" + commonResponse.getData());
        //从验收过来生成设备流转记录
        if (b) {
            AssetVO vo = BeanMapper.map(entity, AssetVO.class);
            logger.info("设备验收推送设备流转记录的信息:" + JSONObject.toJSONString(vo));
            assetRecordService.saveRecord(vo);
        }
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper, List<Long> orgIds) {
        return assetMapper.queryAssetPage(page, wrapper, orgIds);
    }

    @Override
    public ExecutionVO targetCost(AssetVO assetVO) {
        logger.info("推送目标责任成本数据：");
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(assetVO.getId());
        totalVO.setTenantId(assetVO.getTenantId());
        totalVO.setBillCode(assetVO.getBillCode());
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.其他成本单.getCode());
        totalVO.setBillCategory(BillCategoryEnum.其他.getCode());
        if (assetVO.getProjectId() == null) {
            throw new BusinessException("策划成本推送失败,请更换项目");
        } else {
            totalVO.setProjectId(assetVO.getProjectId());
        }
        if (assetVO.getOrgId() == null) {
            throw new BusinessException("策划成本推送失败,请更换项目");
        } else {
            totalVO.setOrgId(assetVO.getOrgId());
        }
        totalVO.setMoney(assetVO.getEstimateAmortizeMny()); //预计摊销金额
        totalVO.setTaxMoney(assetVO.getEstimateAmortizeMny()); //预计摊销金额
        String frontendBaseHost = "";
        if (StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !"null".equals(BASE_HOST_FRONTEND)) {
            frontendBaseHost = BASE_HOST_FRONTEND;
        } else {
            frontendBaseHost = BaseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipmentp-frontend/#/asset/assetCard?id=" + assetVO.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        // 获取文件存储信息
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        //租户ID
        Long tenantid = InvocationInfoProxy.getTenantid();
        //判断文件格式是否正确
        boolean isFailed = false;
        //获取文件数据
        MultipartFile mf = null;
        //遍历文件,校验格式是否正确
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            //获取文件所有内容
            mf = entity.getValue();
            //获取文件名
            String originalFileName = mf.getOriginalFilename();
            // 替换文件名中的非法字符
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        if (mf == null) {
            throw new BusinessException("导入的文件中没有数据");
        }

        // 获取文件数据
        List<List<String>> result = ExcelReader.readExcel(mf);
        //解析成功的数据
        List<AssetVO> successList = new ArrayList<>();
        //解析失败的数据
        List<AssetVO> errorList = new ArrayList<>();
        //检查获取的数据
        if (result == null || result.isEmpty()) {
            throw new BusinessException("数据表格错误");
        }
        if (result.get(0).size() != 18) {
            throw new BusinessException("请按照导入模板导入数据");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
        }
        //设备编码
        List<String> code = new ArrayList<>();
        //获取设备编码
        result.forEach(e -> code.add(e.get(0)));
        //TODO 调用查询设备编码数据接口
        /*Map<String, Object> defParamMap = new HashMap<>();
        defParamMap.put("tenantId", tenantid);*/
        CommonResponse<List<MaterialVO>>
                codes = shareMaterialApi.queryMaterialListByCodes(code);
        HashMap<String, MaterialVO> materialMap = new HashMap<>();
        if (codes != null && codes.getData() != null) {
            codes.getData().forEach(e ->
                    materialMap.put(e.getCode(), e)
            );
        }
        //int index = 2;
        boolean b = false;
        for (int i = 1; i < result.size(); i++) {
            logger.info("第" + i + "行数据" + result.get(i).toString());
            AssetVO vo = new AssetVO();
            //TODO 设备编码（设备档案里的编码）
            vo.setEquipmentCode(getAns(result, i, 0));
            MaterialVO materialVO = materialMap.get(result.get(i).get(0));
            List<AssetRecordVO> recordVOS = new ArrayList<>();
            AssetRecordVO recordVO = null;
            if (materialVO != null && materialVO.getName() != null) {
                recordVO = new AssetRecordVO();
                //数据拷贝
                BeanUtils.copyProperties(materialVO, recordVO);
                recordVO.setId(null);
            } else {
                vo.setErrorMessage("设备编码不存在");
                errorList.add(vo);
                continue;
            }
            recordVOS.add(recordVO);
            vo.setAssetRecordList(recordVOS);
            //资产编码
            vo.setFinanceAssetCode(getAns(result, i, 2));
            //验收日期
            LocalDate parse = null;
            String s = "";
            try {
                s = result.get(i).get(3);
                int nums = Integer.parseInt(s);
                Date date = convertExcelDateToJavaDate(nums);
                /*DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                parse = LocalDate.parse(s, formatter);*/
                //转化成Date类型
                vo.setCheckDate(date);
            } catch (Exception e) {
                //TODO 日期格式错误
                logger.info("日期格式错误" + s);
                vo.setErrorMessage("日期格式错误" + s);
                errorList.add(vo);
                continue;
            }
            //产权单位（系统里的组织名称）
            vo.setPropertyRightCompany(result.get(i).get(4));
            //管理单位（系统里的组织名称）
            vo.setManageCompany(result.get(i).get(5));
            //出厂编号/车牌号
            vo.setLeaveFactoryCode(getAns(result, i, 6));
            //原值(无税)
            String ans = "";
            try {
                ans = getAns(result, i, 7);
                BigDecimal decimal = BigDecimal.valueOf(Long.parseLong(ans));
                vo.setOriginalValue(decimal);
                //累计摊销金额(无税)
                ans = getAns(result, i, 8);
                decimal = BigDecimal.valueOf(Long.parseLong(ans));
                vo.setLastAmortizeMny(decimal);
                //净值(无税)
                ans = getAns(result, i, 9);
                decimal = BigDecimal.valueOf(Long.parseLong(ans));
                vo.setNetWorth(decimal);
            } catch (NumberFormatException e) {
                //TODO 格式错误
                logger.info("数值格式错误：" + ans);
                vo.setErrorMessage("数值格式错误：" + ans);
                errorList.add(vo);
                continue;
            }
            //设备类型（见sheet2) 10
            vo.setEquipType(getAns(result, i, 10));
            //物品品牌
            vo.setItemBrand(getAns(result, i, 11));
            //生产厂家
            vo.setManufacturer(getAns(result, i, 12));
            //排量
            vo.setDisplacement(getAns(result, i, 13));
            //TODO 使用人 14
            vo.setUserName(getAns(result, i, 14));
            //购货日期
            parse = null;
            try {
                s = result.get(i).get(15);
                int anInt = Integer.parseInt(s);
               /* DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                parse = LocalDate.parse(s, formatter);*/
                //转化成Date类型
                vo.setPurchaseDate(convertExcelDateToJavaDate(anInt));
            } catch (Exception e) {
                //TODO 日期格式错误
                vo.setErrorMessage("日期格式错误" + s);
                logger.info("日期格式错误" + s);
                errorList.add(vo);
                continue;
            }
            //资产类型
            vo.setTypeName(getAns(result, i, 16));
            //TODO 发动机号 17
            vo.setEngineCode(getAns(result, i, 17));
            successList.add(vo);
        }
        // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        // 拼接入库数据并入库
        Date createTime = new Date();
        UserContext userContext = sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        List<AssetVO> sucVoList = BeanMapper.mapList(successList, AssetVO.class);
        if (CollectionUtils.isNotEmpty(sucVoList)) {
            for (AssetVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                //long contractId = com.ejianc.support.idworker.util.IdWorker.getId();
                if (StringUtils.isBlank(vo.getBillCode())) {
                    BillCodeParam billCodeParam = null;
                    billCodeParam = BillCodeParam.build(BILL_CODE, tenantid, vo);
                    CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                    if (billCodeRes.isSuccess()) {
                        vo.setBillCode(billCodeRes.getData());
                    } else {
                        throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                    }
                }
            }
            List<AssetEntity> sucEntityList = BeanMapper.mapList(sucVoList, AssetEntity.class);
            saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success(json);
    }

    //获取集合元素，添加校验方法
    private String getAns(List<List<String>> result, int i, int index) {
        if (result.size() <= i) {
            return null;
        }
        List<String> list = result.get(i);
        if (list.size() <= index) {
            return null;
        }
        return list.get(index);
    }

    /**
     * 将Excel数字日期转换为Java Date对象
     *
     * @param excelDate Excel中的数字日期(如34)
     * @return 对应的Date对象
     */
    public static Date convertExcelDateToJavaDate(int excelDate) {
        // Excel的日期系统从1900年1月1日开始(Excel错误地认为1900年是闰年)
        Calendar calendar = Calendar.getInstance();

        // 设置基准日期为1900年1月1日
        // 注意: Excel错误地将1900年视为闰年，所以1900年2月28日之后的所有日期在Excel中都比实际多1天
        calendar.set(1900, Calendar.JANUARY, 1);

        // 减去2天来修正Excel的日期系统错误
        // 因为Excel认为1900年2月29日是有效日期(实际上不是)
        calendar.add(Calendar.DAY_OF_MONTH, excelDate - 2);

        return calendar.getTime();
    }

}
