package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.AssetScrapDetailEntity;
import com.ejianc.business.asset.bean.AssetScrapEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetScrapService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetScrapVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

@Service("assetScrap") 
public class AssetScrapBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetScrapService assetScrapService;
	@Autowired
	private IAssetRecordService assetRecordService;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AssetScrapEntity assetScrapEntity = assetScrapService.selectById(billId);
		if(assetScrapEntity != null){
			if(CollectionUtils.isNotEmpty(assetScrapEntity.getAssetScrapDetailList())){
				List<Long> assetIds =assetScrapEntity.getAssetScrapDetailList().stream().map(AssetScrapDetailEntity::getAssetId).collect(Collectors.toList());
				QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.in("id",assetIds);
				queryWrapper.eq("asset_status",1);
				List<AssetEntity> assetEntities = assetService.list(queryWrapper);
				if (assetEntities.size()>0){
					return CommonResponse.error("设备信息中存在设备已经被报废不能再被报废!");
				}
				assetScrapEntity.getAssetScrapDetailList().forEach(item->{
					LambdaUpdateWrapper<AssetEntity> wrapper = new LambdaUpdateWrapper<>();
					wrapper.set(AssetEntity::getAssetStatus,1);
					wrapper.eq(AssetEntity::getId,item.getAssetId());
					assetService.update(wrapper);
					logger.info("复制固定资产处置照片到固定资产卡片:"+ JSONObject.toJSONString(item));
					CommonResponse<String> commonResponse =
							attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(assetScrapEntity.getId()),
									"EJCBT202206000089", "ScrapPhoto002", String.valueOf(item.getAssetId()), "EJCBT202206000070",
									"AssetScrapPhoto002");
					logger.info("复制图片是否成功:"+commonResponse.isSuccess());
				});
				//生成设备流转记录
				AssetScrapVO assetScrapVO = BeanMapper.map(assetScrapEntity, AssetScrapVO.class);
				assetRecordService.saveRecord(assetScrapVO);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AssetScrapEntity assetScrapEntity = assetScrapService.selectById(billId);
		if(assetScrapEntity != null){
			assetScrapEntity.getAssetScrapDetailList().forEach(item->{
				LambdaUpdateWrapper<AssetEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.set(AssetEntity::getAssetStatus,0);
				wrapper.eq(AssetEntity::getId,item.getAssetId());
				assetService.update(wrapper);
				logger.info("弃审删除固定资产处置照片:"+JSONObject.toJSONString(item));
				CommonResponse<String> commonResponse =
						attachmentApi.deleteFileByParam(item.getAssetId(), "EJCBT202206000070",
								"AssetScrapPhoto002");
				logger.info("弃审删除固定资产处置照片是否成功:"+commonResponse.isSuccess());
			});
			assetRecordService.delRecord(billId);
		}
		//TODO 弃审删除设备流转记录
		return CommonResponse.success();
	}

}
