package com.ejianc.business.asset.controller;

import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 固定资产数据统计
 *
 * @author generator
 */
@Controller
@RequestMapping("assetCountNums")
@Api(value = " 固定资产数据统计", tags = {" 固定资产"})
public class AssetCountNumsController {
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IOrgApi iOrgApi;
    @ApiOperation("各类型固定资产设备统计情况")
    @RequestMapping(value = "/equipmentStatistics",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<List<String>>> equipmentStatistics() {
        //根据组织数据过滤
        Long parentOrgId = InvocationInfoProxy.getOrgId();
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(parentOrgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        //2.根据资产类型ID分组查询资产信息
        List<List<String>> ans = assetService.getGroupByAssetTypeId(orgIds);
        return CommonResponse.success("数据查询成功",ans);
    }
    @ApiOperation("各单位固定资产情况统计表")
    @RequestMapping(value = "/situationStatistics",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<List<String>>> situationStatistics(){
        //2.资产情况统计表
        List<List<String>> ans = assetService.getSituationStatistics();
        return CommonResponse.success("数据查询成功",ans);
    }
    @ApiOperation("固定资产设备使用情况")
    @RequestMapping(value = "/usage",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<List<String>>> usage(){
        //2.资产情况统计表
        List<List<String>> ans = assetService.getUsage();
        return CommonResponse.success("数据查询成功",ans);
    }
}
