package com.ejianc.business.asset.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.asset.bean.AssetEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.util.List;
import java.util.Map;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
public interface IAssetService extends IBaseService<AssetEntity> {

    void pushAsset(Long billId);

    List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper,List<Long> orgIs);

    ExecutionVO targetCost(AssetVO assetVO);

    //导入
    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag);


    CommonResponse<String> updateStatus(List<Long> ids,String assetStatus);
    /*各类型固定资产设备统计情况*/
    List<Map<String, Object>> getGroupByAssetTypeId(List<Long> orgIds);

    /*各单位固定资产情况统计表*/
    List<Map<String, Object>> getSituationStatistics();

    /*固定资产设备使用情况*/
    List<Map<String, Object>> getUsage();

    /*固定资产设备采购报废情况*/
    List<Map<String, Object>> getAnnounce(String formattedDate);

    /*各单位固定资产设备使用情况*/
    List<Map<String, Object>> getEquipmentUsage();
}
