/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAllotOutDetailEntity;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.mapper.AssetAllotOutMapper;
import com.ejianc.business.asset.service.IAssetAllotOutService;
import com.ejianc.business.asset.vo.AssetAllotOutDetailVO;
import com.ejianc.business.asset.vo.AssetAllotOutVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAllotOutService")
public class AssetAllotOutServiceImpl
extends BaseServiceImpl<AssetAllotOutMapper, AssetAllotOutEntity>
implements IAssetAllotOutService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse<AssetAllotOutVO> pushCost(AssetAllotOutVO allotOutVO) {
        AssetAllotOutEntity allotOutEntity = (AssetAllotOutEntity)((Object)((AssetAllotOutMapper)this.baseMapper).selectById(allotOutVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)allotOutVO.getAssetAllotOutDetailList())) {
            List allotOutDetailEntitys = BeanMapper.mapList((Iterable)allotOutVO.getAssetAllotOutDetailList(), AssetAllotOutDetailEntity.class);
            allotOutEntity.setAssetAllotOutDetailList(allotOutDetailEntitys);
        }
        super.saveOrUpdate((Object)allotOutEntity, false);
        this.costPush(allotOutEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)allotOutEntity), AssetAllotOutVO.class));
    }

    @Override
    public void costPush(AssetAllotOutEntity allotOutEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AssetAllotOutDetailEntity> allotOutDetailEntities = allotOutEntity.getAssetAllotOutDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AssetAllotOutDetailEntity entity : allotOutDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                this.logger.info("getSubjectId" + entity.getSubjectId());
                this.logger.info("getWbsId" + entity.getWbsId());
                break;
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        this.logger.info("newRelationFlag" + newRelationFlag);
        this.saveCost(allotOutEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{allotOutEntity.getId()});
        updateWrapper.set(AssetAllotOutEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveCost(AssetAllotOutEntity allotOutEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AssetAllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAssetAllotOutDetailList();
        if (CollectionUtils.isNotEmpty(allotOutDetailList)) {
            for (AssetAllotOutDetailEntity entity : allotOutDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getAllocatId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAllocatDiffTaxMny());
                costDetailVO.setHappenMny(entity.getAllocatDiffMny());
                costDetailVO.setHappenDate(allotOutEntity.getOutDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_ALLOT_OUT");
                costDetailVO.setSourceTabType("ASSET_ALLOT_OUT_SUB");
                costDetailVO.setProjectId(allotOutEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVO.setSourceBillCode(allotOutEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u8c03\u51fa.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/assetAllotOut/assetAllotOutCard?id=" + allotOutEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(AssetAllotOutVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(AssetAllotOutVO vo) {
        List feeList = vo.getAssetAllotOutDetailList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (AssetAllotOutDetailVO assetAllotOutDetailVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == assetAllotOutDetailVO.getSubjectId() || "del".equals(assetAllotOutDetailVO.getRowState())) continue;
                BigDecimal feeMny = assetAllotOutDetailVO.getAllocatDiffMny() == null ? BigDecimal.ZERO : assetAllotOutDetailVO.getAllocatDiffMny();
                BigDecimal bigDecimal = feeTaxMny = assetAllotOutDetailVO.getAllocatDiffTaxMny() == null ? BigDecimal.ZERO : assetAllotOutDetailVO.getAllocatDiffTaxMny();
                if (map.containsKey(assetAllotOutDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(assetAllotOutDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(assetAllotOutDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(costCtrlDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }
}

