/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetRecordVO;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="assetService")
public class AssetServiceImpl
extends BaseServiceImpl<AssetMapper, AssetEntity>
implements IAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IPurchaseAcceptanceSubService purchaseAcceptanceSubService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareEquipmentApi equipmentApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private AssetMapper assetMapper;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private static final String BILL_CODE = "ASSET_Bli_CODE";
    private static final String BILL_TYPE = "EJCBT202206000070";

    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = (PurchaseAcceptanceEntity)((Object)this.purchaseAcceptanceService.selectById(billId));
        AssetEntity entity = new AssetEntity();
        if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()) {
            entity.setOrgId(purchaseAcceptanceEntity.getParentOrgId());
            entity.setOrgName(purchaseAcceptanceEntity.getParentOrgName());
            entity.setOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
            entity.setParentOrgId(purchaseAcceptanceEntity.getOrgId());
            entity.setParentOrgName(purchaseAcceptanceEntity.getOrgName());
            entity.setParentOrgCode(purchaseAcceptanceEntity.getOrgCode());
            entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
            entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
            entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
            entity.setEmployeeId(this.sessionManager.getUserContext().getUserId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getUserName());
            entity.setDepartmentId(this.sessionManager.getUserContext().getDeptId());
            entity.setDepartmentName(this.sessionManager.getUserContext().getDeptName());
            List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(purchaseAcceptanceSubList)) {
                PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)purchaseAcceptanceSubEntity.getTaxRate(), (BigDecimal)new BigDecimal(100)));
                BigDecimal originalValue = ComputeUtil.safeSub((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());
                entity.setEquipmentStatus(1);
                entity.setAssetStatus(0);
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000)) != -1) {
                    entity.setAssetType(1);
                } else {
                    entity.setAssetType(2);
                }
                HashMap<Long, Long> amortizeSetmap = new HashMap<Long, Long>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(), purchaseAcceptanceSubEntity.getEquipmentTypeId());
                this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e:" + JSONObject.toJSONString((Object)((Object)entity)));
                Map<Long, AmortizeSetEntity> amortizeMap = this.amortizeSetService.getSet(amortizeSetmap, entity.getOrgId());
                this.logger.info("\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e:" + JSONObject.toJSONString(amortizeMap));
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity != null) {
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e\u6b8b\u503c\u7387\u6b8b\u503c\u7387:" + residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)residualValueRate, (BigDecimal)new BigDecimal(100)), (BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)residualValueRate, (BigDecimal)new BigDecimal(100)), (BigDecimal)originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }
            }
            entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
            entity.setSourceType(1);
            entity.setFinancePushState(0);
            entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
            entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
            entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
            entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
            entity.setLeaveFactoryCode(purchaseAcceptanceEntity.getLeaveFactoryCode());
            entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
            entity.setAbility(purchaseAcceptanceEntity.getAbility());
            entity.setWeight(purchaseAcceptanceEntity.getWeight());
            entity.setPower(purchaseAcceptanceEntity.getPower());
            entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
            entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
            entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
            entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
            entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
            entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
            entity.setBillState(1);
            AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.logger.info("\u63a8\u9001\u8bbe\u5907\u5361\u7247\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)entity)));
        boolean b = this.assetService.saveOrUpdate((Object)entity, false);
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()), "BT220323000000007", "photoPath", String.valueOf(entity.getId()), BILL_TYPE, "ASSET002");
        this.logger.info("\u590d\u5236\u56fe\u7247:" + commonResponse.isSuccess());
        this.logger.info("\u590d\u5236\u56fe\u7247\u8fd4\u56de\u7684\u5185\u5bb9:" + (String)commonResponse.getData());
        if (b) {
            AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
            this.logger.info("\u8bbe\u5907\u9a8c\u6536\u63a8\u9001\u8bbe\u5907\u6d41\u8f6c\u8bb0\u5f55\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)vo));
            this.assetRecordService.saveRecord((IAssetRecord)vo);
        }
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper, List<Long> orgIds) {
        return this.assetMapper.queryAssetPage(page, wrapper, orgIds);
    }

    @Override
    public ExecutionVO targetCost(AssetVO assetVO) {
        this.logger.info("\u63a8\u9001\u76ee\u6807\u8d23\u4efb\u6210\u672c\u6570\u636e\uff1a");
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(assetVO.getId());
        totalVO.setTenantId(assetVO.getTenantId());
        totalVO.setBillCode(assetVO.getBillCode());
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.\u5176\u4ed6.getCode());
        if (assetVO.getProjectId() == null) {
            throw new BusinessException("\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(assetVO.getProjectId());
        if (assetVO.getOrgId() == null) {
            throw new BusinessException("\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setMoney(assetVO.getEstimateAmortizeMny());
        totalVO.setTaxMoney(assetVO.getEstimateAmortizeMny());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipmentp-frontend/#/asset/assetCard?id=" + assetVO.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        List sucVoList;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<AssetVO> successList = new ArrayList<AssetVO>();
        ArrayList<AssetVO> errorList = new ArrayList<AssetVO>();
        if (result == null || result.isEmpty()) {
            throw new BusinessException("\u6570\u636e\u8868\u683c\u9519\u8bef");
        }
        if (((List)result.get(0)).size() != 20) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
        }
        ArrayList code = new ArrayList();
        result.forEach(e -> code.add(e.get(0)));
        CommonResponse codes = this.equipmentApi.queryEquipmentListByCodes(code);
        HashMap materialMap = new HashMap();
        if (codes != null && codes.getData() != null) {
            ((List)codes.getData()).forEach(e -> materialMap.put(e.getCode(), e));
        }
        for (int i = 1; i < result.size(); ++i) {
            AssetVO vo;
            block32: {
                block31: {
                    String s;
                    LocalDate parse;
                    block30: {
                        long id = IdWorker.getId();
                        this.logger.info("\u7b2c" + i + "\u884c\u6570\u636e" + ((List)result.get(i)).toString());
                        vo = new AssetVO();
                        vo.setEquipmentCode(this.getAns(result, i, 0));
                        vo.setId(Long.valueOf(id));
                        String ans1 = this.getAns(result, i, 6);
                        Object vos = null;
                        if (ans1 != null && !ans1.isEmpty()) {
                            CommonResponse commonResponse = this.projectPoolApi.queryProjectListByNameAndTenantId(ans1, InvocationInfoProxy.getTenantid());
                            vos = (List)commonResponse.getData();
                        }
                        if (vos == null || vos.isEmpty()) {
                            vo.setErrorMessage("\u3010\u9879\u76ee\u540d\u79f0\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e" + this.getAns(result, i, 6));
                            errorList.add(vo);
                            continue;
                        }
                        ProjectPoolSetVO vo1 = (ProjectPoolSetVO)vos.get(0);
                        vo.setProjectName(vo1.getName());
                        vo.setProjectId(vo1.getId());
                        try {
                            PurchaseAcceptanceEntity entity;
                            if (this.getAns(result, i, 4) == null || this.getAns(result, i, 4).isEmpty()) {
                                vo.setErrorMessage("\u3010\u4ea7\u6743\u5355\u4f4d\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e" + this.getAns(result, i, 4));
                                errorList.add(vo);
                                continue;
                            }
                            CommonResponse api = this.orgApi.findByNameAndTenantId(this.getAns(result, i, 4), tenantid);
                            QueryParam param = new QueryParam();
                            param.getParams().put("equipmentCode", new Parameter("eq", (Object)this.getAns(result, i, 0)));
                            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(((OrgVO)api.getData()).getId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                            List list = this.purchaseAcceptanceService.queryList(param);
                            if (list != null && !list.isEmpty() && (entity = (PurchaseAcceptanceEntity)((Object)list.get(0))) != null) {
                                vo.setPurchaseAcceptanceId(entity.getId());
                                vo.setEquipmentName(entity.getEquipmentName());
                                vo.setEquipmentId(entity.getEquipmentId());
                                vo.setModelExplain(entity.getModelExplain());
                                vo.setItemBrand(entity.getItemBrand());
                            }
                            vo.setPropertyRightCompanyId(((OrgVO)api.getData()).getId());
                            vo.setPropertyRightCompany(((OrgVO)api.getData()).getName());
                        }
                        catch (Exception e2) {
                            vo.setErrorMessage("\u3010\u4ea7\u6743\u5355\u4f4d\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e" + this.getAns(result, i, 4));
                            errorList.add(vo);
                            continue;
                        }
                        EquipmentVO materialVO = (EquipmentVO)materialMap.get(((List)result.get(i)).get(0));
                        if (materialVO == null) {
                            vo.setErrorMessage("\u3010\u8bbe\u5907\u7f16\u7801\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u6863\u6848");
                            errorList.add(vo);
                            continue;
                        }
                        vo.setEquipmentId(materialVO.getId());
                        vo.setEquipmentName(materialVO.getName());
                        vo.setEquipUnitName(materialVO.getUnitName());
                        vo.setUnit(materialVO.getUnitName());
                        vo.setUnitId(materialVO.getUnitId());
                        vo.setSpec(materialVO.getSpec());
                        vo.setModelExplain(materialVO.getSpec());
                        ArrayList<AssetRecordVO> recordVOS = new ArrayList<AssetRecordVO>();
                        vo.setEquipmentName((String)((List)result.get(i)).get(1));
                        AssetRecordVO recordVO = null;
                        recordVO = new AssetRecordVO();
                        recordVO.setEquipmentName((String)((List)result.get(i)).get(1));
                        recordVO.setEquipmentCode(materialVO.getCode());
                        recordVO.setEquipmentId(materialVO.getId());
                        recordVO.setEquipmentTypeId(materialVO.getCategoryId());
                        recordVO.setEquipmentTypeName(materialVO.getCategoryName());
                        recordVO.setEquipmentTypeCode(materialVO.getCategoryCode());
                        recordVO.setId(null);
                        recordVOS.add(recordVO);
                        vo.setAssetRecordList(recordVOS);
                        vo.setFinanceAssetCode(this.getAns(result, i, 2));
                        parse = null;
                        s = "";
                        try {
                            s = (String)((List)result.get(i)).get(3);
                            if (s == null || s.isEmpty()) break block30;
                            Date date = null;
                            parse = LocalDate.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                            vo.setCheckDate(date);
                        }
                        catch (Exception e3) {
                            vo.setErrorMessage("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u4f8b\uff1a0000-00-00");
                            errorList.add(vo);
                            continue;
                        }
                    }
                    vo.setPropertyRightCompany((String)((List)result.get(i)).get(4));
                    vo.setManageCompany((String)((List)result.get(i)).get(5));
                    CommonResponse api = this.orgApi.findByNameAndTenantId((String)((List)result.get(i)).get(5), tenantid);
                    if (api.getData() == null) {
                        vo.setErrorMessage("\u3010\u7ba1\u7406\u5355\u4f4d\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u7ec4\u7ec7" + (String)((List)result.get(i)).get(5));
                        errorList.add(vo);
                        continue;
                    }
                    vo.setManageCompanyId(((OrgVO)api.getData()).getId());
                    vo.setLeaveFactoryCode(this.getAns(result, i, 7));
                    String ans = "";
                    try {
                        ans = this.getAns(result, i, 8);
                        BigDecimal decimal = BigDecimal.valueOf(Double.parseDouble(ans));
                        vo.setOriginalValueTax(decimal);
                        ans = this.getAns(result, i, 9);
                        decimal = BigDecimal.valueOf(Double.parseDouble(ans));
                        vo.setLastAmortizeTaxMny(decimal);
                        ans = this.getAns(result, i, 10);
                        decimal = BigDecimal.valueOf(Double.parseDouble(ans));
                        vo.setNetWorthTax(decimal);
                    }
                    catch (NumberFormatException e4) {
                        this.logger.info("\u6570\u503c\u683c\u5f0f\u9519\u8bef\uff1a" + ans);
                        vo.setErrorMessage("\u6570\u503c\u683c\u5f0f\u9519\u8bef\uff1a" + ans);
                        errorList.add(vo);
                        continue;
                    }
                    vo.setEquipType(this.getAns(result, i, 11));
                    if (this.getAns(result, i, 12) == null || this.getAns(result, i, 12).isEmpty()) {
                        vo.setErrorMessage("\u3010\u7269\u54c1\u54c1\u724c\u3011\u4e3a\u5fc5\u8981\u5b57\u6bb5");
                        errorList.add(vo);
                        continue;
                    }
                    vo.setItemBrand(this.getAns(result, i, 12));
                    vo.setManufacturer(this.getAns(result, i, 13));
                    vo.setDisplacement(this.getAns(result, i, 14));
                    vo.setUserName(this.getAns(result, i, 15));
                    vo.setStorageLocation(this.getAns(result, i, 16));
                    try {
                        s = (String)((List)result.get(i)).get(17);
                        if (s == null || s.isEmpty()) break block31;
                        boolean nums = false;
                        Date date = null;
                        parse = LocalDate.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        vo.setPurchaseDate(date);
                    }
                    catch (Exception e5) {
                        vo.setErrorMessage("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u4f8b\uff1a0000-00-00");
                        this.logger.info("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4f7f\u7528excel\u65e5\u671f\u683c\u5f0f\u5316" + s);
                        errorList.add(vo);
                        continue;
                    }
                }
                vo.setTypeName(this.getAns(result, i, 18));
                try {
                    vo.setEngineCode(this.getAns(result, i, 19));
                    CommonResponse byDefCode = this.iDefdocApi.getDefDocByDefCode("equipmentp_assets_type");
                    List data = (List)byDefCode.getData();
                    data.forEach(e -> {
                        if (e.getName().equals(vo.getTypeName())) {
                            vo.setAssetTypeId(e.getId());
                        }
                        if (e.getName().equals(vo.getEquipType())) {
                            vo.setAssetsTypeId(e.getId());
                        }
                    });
                    if (vo.getAssetTypeId() == null) {
                        vo.setErrorMessage("\u3010\u8d44\u4ea7\u7c7b\u578b\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u8d44\u4ea7\u7c7b\u578b" + (String)((List)result.get(i)).get(17));
                        errorList.add(vo);
                    }
                    break block32;
                }
                catch (Exception e6) {
                    vo.setErrorMessage("\u3010\u8d44\u4ea7\u7c7b\u578b\u3011\u5728\u7cfb\u7edf\u4e2d\u65e0\u5bf9\u5e94\u8d44\u4ea7\u7c7b\u578b" + (String)((List)result.get(i)).get(17));
                    errorList.add(vo);
                }
                continue;
            }
            successList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        Date createTime = new Date();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        if (CollectionUtils.isNotEmpty((Collection)(sucVoList = BeanMapper.mapList(successList, AssetVO.class)))) {
            for (AssetVO vo : sucVoList) {
                vo.setAssetStatus(Integer.valueOf(0));
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                if (!StringUtils.isBlank((CharSequence)vo.getBillCode())) continue;
                BillCodeParam billCodeParam = null;
                billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantid, (BaseVO)vo);
                CommonResponse billCodeRes = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCodeRes.isSuccess()) {
                    vo.setBillCode((String)billCodeRes.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List sucEntityList = BeanMapper.mapList((Iterable)sucVoList, AssetEntity.class);
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<String> updateStatus(List<Long> ids, String assetStatus) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("id", new Parameter("in", ids));
        List entityList = this.queryList(param);
        for (AssetEntity entity : entityList) {
            entity.setAssetStatus(Integer.parseInt(assetStatus));
        }
        this.saveOrUpdateBatch(entityList, entityList.size(), false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    private String getAns(List<List<String>> result, int i, int index) {
        if (result.size() <= i) {
            return null;
        }
        List<String> list = result.get(i);
        if (list.size() <= index) {
            return null;
        }
        return list.get(index);
    }

    public static Date convertExcelDateToJavaDate(int excelDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        calendar.add(5, excelDate - 2);
        return calendar.getTime();
    }

    @Override
    public List<Map<String, Object>> getGroupByAssetTypeId(List<Long> orgIds) {
        CommonResponse byDefCode = this.iDefdocApi.getDefDocByDefCode("equipmentp_assets_type");
        List data = (List)byDefCode.getData();
        HashMap<String, String> map = new HashMap<String, String>();
        data.forEach(e -> map.put(String.valueOf(e.getId()), e.getName()));
        List<Map<String, Object>> ans = this.assetMapper.getGroupByAssetTypeId(orgIds);
        ArrayList<Map<String, Object>> usage = new ArrayList<Map<String, Object>>();
        try {
            Object count;
            long nums = 0L;
            for (Map<String, Object> m : ans) {
                count = m.get("count");
                if (count == null || "".equals(count)) continue;
                nums += Long.parseLong(String.valueOf(count));
            }
            for (Map<String, Object> m : ans) {
                m.put("mouen", "\u5907\u6ce8-\u6682\u65e0");
                count = map.get("count");
                if (count == null || "".equals(count)) continue;
                m.put("numsAccount", Double.parseDouble(String.valueOf(count)) / (double)nums * 100.0);
                if (m.get("assetTypeId") == null) {
                    m.put("assetTypeName", "\u6ca1\u6709\u5927\u7c7b\u540d\u79f0");
                    continue;
                }
                String assetTypeName = (String)map.get(m.get("assetTypeId"));
                m.put("assetTypeName", assetTypeName);
                map.remove("assetTypeId");
            }
            map.forEach((k, v) -> {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("assetTypeName", v);
                hashMap.put("count", 0);
                hashMap.put("originalValue", 0);
                hashMap.put("lastAmortizeMny", 0);
                hashMap.put("numsAccount", 0);
                ans.add(hashMap);
            });
            for (int i = 0; i < ans.size(); ++i) {
                Map<String, Object> objectMap = ans.get(i);
                if (!objectMap.containsKey("assetTypeName") || objectMap.get("assetTypeName") == null || "".equals(objectMap.get("assetTypeName"))) continue;
                usage.add(objectMap);
            }
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
        return usage;
    }

    @Override
    public List<Map<String, Object>> getSituationStatistics(List<Long> orgIds) {
        List<Map<String, Object>> maps = this.assetMapper.getSituationStatistics(orgIds);
        long nums = 0L;
        try {
            Object count;
            for (Map<String, Object> map : maps) {
                count = map.get("count");
                if (count == null || "".equals(count)) continue;
                nums += Long.parseLong(String.valueOf(count));
            }
            for (Map<String, Object> map : maps) {
                count = map.get("count");
                if (count == null || "".equals(count)) continue;
                map.put("numsAccount", Double.parseDouble(String.valueOf(count)) / (double)nums * 100.0);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> getUsage(List<Long> orgIds) {
        List<Map<String, Object>> usage = this.assetMapper.getUsage(orgIds);
        CommonResponse byDefCode = this.iDefdocApi.getDefDocByDefCode("equipmentp_assets_type");
        List getName = (List)byDefCode.getData();
        HashMap<String, String> map = new HashMap<String, String>();
        getName.forEach(e -> map.put(String.valueOf(e.getId()), e.getName()));
        usage.forEach(e -> e.put("assetTypeName", map.get(e.get("assetTypeId"))));
        for (Map<String, Object> m : usage) {
            if (m.get("assetTypeId") == null) continue;
            String assetTypeName = (String)map.get(m.get("assetTypeId"));
            m.put("assetTypeName", assetTypeName);
            map.remove("assetTypeId");
        }
        map.forEach((k, v) -> {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("assetTypeName", v);
            hashMap.put("inUseStatus", 0);
            hashMap.put("handleStatus", 0);
            usage.add(hashMap);
        });
        ArrayList<Map<String, Object>> ans = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < usage.size(); ++i) {
            Map<String, Object> objectMap = usage.get(i);
            if (!objectMap.containsKey("assetTypeName") || objectMap.get("assetTypeName") == null || "".equals(objectMap.get("assetTypeName"))) continue;
            ans.add(objectMap);
        }
        return ans;
    }

    @Override
    public List<Map<String, Object>> getAnnounce(String formattedDate, List<Long> orgIds) {
        List<Map<String, Object>> ans = this.assetMapper.getAnnounce(formattedDate, orgIds);
        return ans;
    }

    @Override
    public List<Map<String, Object>> getEquipmentUsage(List<Long> orgIds) {
        List<Map<String, Object>> ans = this.assetMapper.getEquipmentUsage(orgIds);
        return ans;
    }
}

