package com.ejianc.business.profillreport.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 内部承包协议评审及签订台账
 * 
 * @author generator
 * 
 */
public class InnerjudgeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同ID
    private String billCode; // 零工单号
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Integer billState; // 单据状态（审批必须字段）
    private BigDecimal companyTargetRate; // 公司审核目标计划利润率
    private String targetPlanReviewer; // 目标计划审核人
    private Integer objectPlanReview; // 目标计划评审（1：是:，2：否）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reviewTime; // 评审时间
    private String reviewer; // 参与评审人员
    private BigDecimal grassrootsOpinionJt; // 基层单位意见(集团)
    private BigDecimal grassrootsOpinionGs; // 基层单位意见(公司)
    private BigDecimal grassrootsOpinionZgb; // 基层单位意见(直管部/分公司)
    private BigDecimal managementFee; // 按公司[2022]33号文规定应上交公司管理费
    private BigDecimal companyOpinionJt; // 公司部门意见(集团)
    private BigDecimal companyOpinionGs; // 公司部门意见(公司)
    private BigDecimal companyOpinionZgb; // 公司部门意见(直管部/分公司)
    private BigDecimal reviewGroupOpinionJt; // 评审小组审核意见(集团)
    private BigDecimal reviewGroupOpinionGs; // 评审小组审核意见(公司)
    private BigDecimal reviewGroupOpinionZgb; // 评审小组审核意见(直管部/分公司)
    private Integer oaProcess; // 是否走OA流程（1：是:，2：否）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signingDate; // 签订时间
    private String signingYear; // 签订年份
    private String shallSign; // 应签定（份）
    private String signed; // 已签定（份）
    private String protocolNumber; // 内部承包协议书编号
    private Integer paperStamp; // 纸质版盖章（1：是:，2：否）
    private BigDecimal contractMny; // 内部承包协议中合同造价(万元)
    private BigDecimal grassrootsMny; // 基层单位施工范围金额
    private BigDecimal grossProfitRate; // 标前测算毛利率
    private BigDecimal planProfitRate; // 基层单位上报目标计划利润率

    private BigDecimal jtRate; // 上交集团管理费率
    private BigDecimal gsRate; // 上交公司管理费率
    private BigDecimal zgbRate; // 上交直管部管理费率
    private Integer handSituation; // 目标成本计划办理情况（0未报审、1审核中、2审定）

    public BigDecimal getJtRate() {
        return jtRate;
    }

    public void setJtRate(BigDecimal jtRate) {
        this.jtRate = jtRate;
    }

    public BigDecimal getGsRate() {
        return gsRate;
    }

    public void setGsRate(BigDecimal gsRate) {
        this.gsRate = gsRate;
    }

    public BigDecimal getZgbRate() {
        return zgbRate;
    }

    public void setZgbRate(BigDecimal zgbRate) {
        this.zgbRate = zgbRate;
    }

    public Integer getHandSituation() {
        return handSituation;
    }

    public void setHandSituation(Integer handSituation) {
        this.handSituation = handSituation;
    }

    public String getTargetPlanReviewer() {
        return targetPlanReviewer;
    }

    public void setTargetPlanReviewer(String targetPlanReviewer) {
        this.targetPlanReviewer = targetPlanReviewer;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public BigDecimal getGrassrootsMny() {
        return grassrootsMny;
    }

    public void setGrassrootsMny(BigDecimal grassrootsMny) {
        this.grassrootsMny = grassrootsMny;
    }

    public BigDecimal getGrossProfitRate() {
        return grossProfitRate;
    }

    public void setGrossProfitRate(BigDecimal grossProfitRate) {
        this.grossProfitRate = grossProfitRate;
    }

    public BigDecimal getPlanProfitRate() {
        return planProfitRate;
    }

    public void setPlanProfitRate(BigDecimal planProfitRate) {
        this.planProfitRate = planProfitRate;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }


    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }


    public String getProjectName() {
        return projectName;
    }
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getCompanyTargetRate() {
        return companyTargetRate;
    }

    public void setCompanyTargetRate(BigDecimal companyTargetRate) {
        this.companyTargetRate = companyTargetRate;
    }


    public Integer getObjectPlanReview() {
        return objectPlanReview;
    }

    public void setObjectPlanReview(Integer objectPlanReview) {
        this.objectPlanReview = objectPlanReview;
    }
    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }


    public BigDecimal getGrassrootsOpinionJt() {
        return grassrootsOpinionJt;
    }

    public void setGrassrootsOpinionJt(BigDecimal grassrootsOpinionJt) {
        this.grassrootsOpinionJt = grassrootsOpinionJt;
    }

    public BigDecimal getGrassrootsOpinionGs() {
        return grassrootsOpinionGs;
    }

    public void setGrassrootsOpinionGs(BigDecimal grassrootsOpinionGs) {
        this.grassrootsOpinionGs = grassrootsOpinionGs;
    }

    public BigDecimal getGrassrootsOpinionZgb() {
        return grassrootsOpinionZgb;
    }

    public void setGrassrootsOpinionZgb(BigDecimal grassrootsOpinionZgb) {
        this.grassrootsOpinionZgb = grassrootsOpinionZgb;
    }

    public BigDecimal getCompanyOpinionJt() {
        return companyOpinionJt;
    }

    public void setCompanyOpinionJt(BigDecimal companyOpinionJt) {
        this.companyOpinionJt = companyOpinionJt;
    }

    public BigDecimal getCompanyOpinionGs() {
        return companyOpinionGs;
    }

    public void setCompanyOpinionGs(BigDecimal companyOpinionGs) {
        this.companyOpinionGs = companyOpinionGs;
    }

    public BigDecimal getCompanyOpinionZgb() {
        return companyOpinionZgb;
    }

    public void setCompanyOpinionZgb(BigDecimal companyOpinionZgb) {
        this.companyOpinionZgb = companyOpinionZgb;
    }

    public BigDecimal getReviewGroupOpinionJt() {
        return reviewGroupOpinionJt;
    }

    public void setReviewGroupOpinionJt(BigDecimal reviewGroupOpinionJt) {
        this.reviewGroupOpinionJt = reviewGroupOpinionJt;
    }

    public BigDecimal getReviewGroupOpinionGs() {
        return reviewGroupOpinionGs;
    }

    public void setReviewGroupOpinionGs(BigDecimal reviewGroupOpinionGs) {
        this.reviewGroupOpinionGs = reviewGroupOpinionGs;
    }

    public BigDecimal getReviewGroupOpinionZgb() {
        return reviewGroupOpinionZgb;
    }

    public void setReviewGroupOpinionZgb(BigDecimal reviewGroupOpinionZgb) {
        this.reviewGroupOpinionZgb = reviewGroupOpinionZgb;
    }

    public BigDecimal getManagementFee() {
        return managementFee;
    }
    public void setManagementFee(BigDecimal managementFee) {
        this.managementFee = managementFee;
    }

    public Integer getOaProcess() {
        return oaProcess;
    }
    public void setOaProcess(Integer oaProcess) {
        this.oaProcess = oaProcess;
    }

    public Date getSigningDate() {
        return signingDate;
    }
    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }
    public String getSigningYear() {
        return signingYear;
    }

    public void setSigningYear(String signingYear) {
        this.signingYear = signingYear;
    }
    public String getShallSign() {
        return shallSign;
    }

    public void setShallSign(String shallSign) {
        this.shallSign = shallSign;
    }
    public String getSigned() {
        return signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }
    public String getProtocolNumber() {
        return protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }
    public Integer getPaperStamp() {
        return paperStamp;
    }

    public void setPaperStamp(Integer paperStamp) {
        this.paperStamp = paperStamp;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    
}
