package com.ejianc.business.profillreport.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 内部承包协议评审及签订台账
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profillreport_innerjudge")
public class InnerjudgeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="bill_code")
    private String billCode; // 零工单号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="company_target_rate")
    private BigDecimal companyTargetRate; // 公司审核目标计划利润率
    @TableField(value="target_plan_reviewer")
    private String targetPlanReviewer; // 目标计划审核人
    @TableField(value="object_plan_review")
    private Integer objectPlanReview; // 目标计划评审（1：是:，2：否）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="review_time")
    private Date reviewTime; // 评审时间
    @TableField(value="reviewer")
    private String reviewer; // 参与评审人员
    @TableField(value="grassroots_opinion_jt")
    private String grassrootsOpinionJt; // 基层单位意见(集团)
    @TableField(value="grassroots_opinion_gs")
    private String grassrootsOpinionGs; // 基层单位意见(公司)
    @TableField(value="grassroots_opinion_zgb")
    private String grassrootsOpinionZgb; // 基层单位意见(直管部/分公司)
    @TableField(value="management_fee")
    private BigDecimal managementFee; // 按公司[2022]33号文规定应上交公司管理费
    @TableField(value="company_opinion_jt")
    private String companyOpinionJt; // 公司部门意见(集团)
    @TableField(value="company_opinion_gs")
    private String companyOpinionGs; // 公司部门意见(公司)
    @TableField(value="company_opinion_zgb")
    private String companyOpinionZgb; // 公司部门意见(直管部/分公司)
    @TableField(value="review_group_opinion_jt")
    private String reviewGroupOpinionJt; // 评审小组审核意见(集团)
    @TableField(value="review_group_opinion_gs")
    private String reviewGroupOpinionGs; // 评审小组审核意见(公司)
    @TableField(value="review_group_opinion_zgb")
    private String reviewGroupOpinionZgb; // 评审小组审核意见(直管部/分公司)
    @TableField(value="oa_process")
    private Integer oaProcess; // 是否走OA流程（1：是:，2：否）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="signing_date")
    private Date signingDate; // 签订时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="signing_year")
    private String signingYear; // 签订年份
    @TableField(value="shall_sign")
    private String shallSign; // 应签定（份）
    @TableField(value="signed")
    private String signed; // 已签定（份）
    @TableField(value="protocol_number")
    private String protocolNumber; // 内部承包协议书编号
    @TableField(value="paper_stamp")
    private Integer paperStamp; // 纸质版盖章（1：是:，2：否）
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 内部承包协议中合同造价(万元)
    
    
    

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getCompanyTargetRate() {
        return companyTargetRate;
    }

    public void setCompanyTargetRate(BigDecimal companyTargetRate) {
        this.companyTargetRate = companyTargetRate;
    }

    public String getTargetPlanReviewer() {
        return targetPlanReviewer;
    }

    public void setTargetPlanReviewer(String targetPlanReviewer) {
        this.targetPlanReviewer = targetPlanReviewer;
    }
    public Integer getObjectPlanReview() {
        return objectPlanReview;
    }

    public void setObjectPlanReview(Integer objectPlanReview) {
        this.objectPlanReview = objectPlanReview;
    }
    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }
    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }
    public String getGrassrootsOpinionJt() {
        return grassrootsOpinionJt;
    }

    public void setGrassrootsOpinionJt(String grassrootsOpinionJt) {
        this.grassrootsOpinionJt = grassrootsOpinionJt;
    }
    public String getGrassrootsOpinionGs() {
        return grassrootsOpinionGs;
    }

    public void setGrassrootsOpinionGs(String grassrootsOpinionGs) {
        this.grassrootsOpinionGs = grassrootsOpinionGs;
    }
    public String getGrassrootsOpinionZgb() {
        return grassrootsOpinionZgb;
    }

    public void setGrassrootsOpinionZgb(String grassrootsOpinionZgb) {
        this.grassrootsOpinionZgb = grassrootsOpinionZgb;
    }
    public BigDecimal getManagementFee() {
        return managementFee;
    }

    public void setManagementFee(BigDecimal managementFee) {
        this.managementFee = managementFee;
    }
    public String getCompanyOpinionJt() {
        return companyOpinionJt;
    }

    public void setCompanyOpinionJt(String companyOpinionJt) {
        this.companyOpinionJt = companyOpinionJt;
    }
    public String getCompanyOpinionGs() {
        return companyOpinionGs;
    }

    public void setCompanyOpinionGs(String companyOpinionGs) {
        this.companyOpinionGs = companyOpinionGs;
    }
    public String getCompanyOpinionZgb() {
        return companyOpinionZgb;
    }

    public void setCompanyOpinionZgb(String companyOpinionZgb) {
        this.companyOpinionZgb = companyOpinionZgb;
    }
    public String getReviewGroupOpinionJt() {
        return reviewGroupOpinionJt;
    }

    public void setReviewGroupOpinionJt(String reviewGroupOpinionJt) {
        this.reviewGroupOpinionJt = reviewGroupOpinionJt;
    }
    public String getReviewGroupOpinionGs() {
        return reviewGroupOpinionGs;
    }

    public void setReviewGroupOpinionGs(String reviewGroupOpinionGs) {
        this.reviewGroupOpinionGs = reviewGroupOpinionGs;
    }
    public String getReviewGroupOpinionZgb() {
        return reviewGroupOpinionZgb;
    }

    public void setReviewGroupOpinionZgb(String reviewGroupOpinionZgb) {
        this.reviewGroupOpinionZgb = reviewGroupOpinionZgb;
    }
    public Integer getOaProcess() {
        return oaProcess;
    }

    public void setOaProcess(Integer oaProcess) {
        this.oaProcess = oaProcess;
    }
    public Date getSigningDate() {
        return signingDate;
    }

    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }
    public String getSigningYear() {
        return signingYear;
    }

    public void setSigningYear(String signingYear) {
        this.signingYear = signingYear;
    }
    public String getShallSign() {
        return shallSign;
    }

    public void setShallSign(String shallSign) {
        this.shallSign = shallSign;
    }
    public String getSigned() {
        return signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }
    public String getProtocolNumber() {
        return protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }
    public Integer getPaperStamp() {
        return paperStamp;
    }

    public void setPaperStamp(Integer paperStamp) {
        this.paperStamp = paperStamp;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    
}
