package com.ejianc.business.profillreport.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.profillreport.bean.IssuesSystemDetailEntity;
/**
 * 季度问题隐患和制度措施清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profillreport_security_issues_system")
public class IssuesSystemEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 直管部/分公司id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 直管部/分公司编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 直管部/分公司
    @TableField(value="project_id")
    private Long projectId; // 隐患责任单位id
    @TableField(value="project_name")
    private String projectName; // 隐患责任单位名称
    @TableField(value="project_code")
    private String projectCode; // 隐患责任单位编码
    @TableField(value="preparer")
    private String preparer; // 填表人
    @TableField(value="preparer_phone")
    private String preparerPhone; // 填表人联系方式
    @TableField(value="quarter")
    private String quarter; // 季度
    @TableField(value="preparer_time")
    private Date preparerTime; // 填表时间
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="issuesSystemDetailService")
    private List<IssuesSystemDetailEntity> issuesSystemDetailList = new ArrayList<>(); // 季度问题隐患和制度措施清单-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getPreparer() {
        return preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }
    public String getPreparerPhone() {
        return preparerPhone;
    }

    public void setPreparerPhone(String preparerPhone) {
        this.preparerPhone = preparerPhone;
    }
    public String getQuarter() {
        return quarter;
    }

    public void setQuarter(String quarter) {
        this.quarter = quarter;
    }
    public Date getPreparerTime() {
        return preparerTime;
    }

    public void setPreparerTime(Date preparerTime) {
        this.preparerTime = preparerTime;
    }
    

    public List<IssuesSystemDetailEntity> getIssuesSystemDetailList() {
        return issuesSystemDetailList;
    }

    public void setIssuesSystemDetailList(List<IssuesSystemDetailEntity> issuesSystemDetailList) {
        this.issuesSystemDetailList = issuesSystemDetailList;
    }
}
