package com.ejianc.business.profinance.odd.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 零星费用分配主表
 * 
 * @author generator
 * 
 */
@ApiModel("零星费用分配主表")
public class ImportOddAllocationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
//    @ApiModelProperty("创建者名称")
//    private String createUserName;
//    @ApiModelProperty("修改者名称")
//    private String updateUserName;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    private String billStateName;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("零星费用单id")
    private Long oddFeeId;
    @ApiModelProperty("零星费用单编码")
    private String oddFeeCode;
    @ApiModelProperty("无合同费用类型ID")
    private Long noContractFeeTypeId;
    @ApiModelProperty("无合同费用类型名称")
    private String noContractFeeTypeName;
    @ApiModelProperty("无合同费用类型编码")
    private String noContractFeeTypeCode;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部所属组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("发生日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date happenDate;
    private String happenDateStr;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("业务说明")
    private String businessExplain;
    @ApiModelProperty("费用金额")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("费用金额(无税)")
    private BigDecimal feeMny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("单据日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    private String billDateStr;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门id")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("经办日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date employeeDate;
    private String employeeDateStr;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("已分摊金额(不含本次)")
    private BigDecimal haveAllocatedTaxMny;
    @ApiModelProperty("已分摊金额(不含本次)(无税)")
    private BigDecimal haveAllocatedMny;
    @ApiModelProperty("剩余可分摊金额")
    private BigDecimal surplusAllocatedTaxMny;
    @ApiModelProperty("剩余可分摊金额(无税)")
    private BigDecimal surplusAllocatedMny;
    @ApiModelProperty("本次分摊金额合计")
    private BigDecimal allocatedTaxMny;
    @ApiModelProperty("本次分摊金额合计(无税)")
    private BigDecimal allocatedMny;
    @ApiModelProperty("本次分摊比例")
    private BigDecimal allocatedRatio;
    @ApiModelProperty("累计分摊金额(含本次)")
    private BigDecimal totalAllocatedTaxMny;
    @ApiModelProperty("累计分摊金额(含本次)(无税)")
    private BigDecimal totalAllocatedMny;
    @ApiModelProperty("累计分摊比例")
    private BigDecimal totalAllocatedRatio;
    @ApiModelProperty("关联状态")
    private String relationFlag; // 关联状态(1:是，0：否)
    @ApiModelProperty("分摊状态")
    private String proportionFlag; // 分摊状态(1:是，0：否)

    @ApiModelProperty("零星费用分配子表")
    private List<OddAllocationDetailVO> oddAllocationDetailList = new ArrayList<>();

    //子表相关字段
    @ApiModelProperty("核算对象id")
    private Long wbsId;
    @ApiModelProperty("核算对象名称")
    private String wbsName;
    @ApiModelProperty("核算对象编号")
    private String wbsCode;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    @ApiModelProperty("成本科目编号")
    private String subjectCode;
    @ApiModelProperty("分摊金额")
    private BigDecimal detailAllocatedTaxMny;
    @ApiModelProperty("分摊金额(无税)")
    private BigDecimal detailAllocatedMny;
    @ApiModelProperty("分摊比例")
    private BigDecimal detailAllocatedRatio;
    @ApiModelProperty("经办人OA账号")
    private String employOAAccount;
    private String createDateStr;//制单日期Str

    /**
     * 导入失败原因
     */
    private String errorMessage;





    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getHappenDateStr() {
        return happenDateStr;
    }

    public void setHappenDateStr(String happenDateStr) {
        this.happenDateStr = happenDateStr;
    }

    public String getBillDateStr() {
        return billDateStr;
    }

    public void setBillDateStr(String billDateStr) {
        this.billDateStr = billDateStr;
    }

    public String getEmployeeDateStr() {
        return employeeDateStr;
    }

    public void setEmployeeDateStr(String employeeDateStr) {
        this.employeeDateStr = employeeDateStr;
    }

//    /**
//     * 创建者名称
//     */
//    public String getCreateUserName() {
//        return createUserName;
//    }
//
//    /**
//     * 创建者名称
//     */
//    public void setCreateUserName(String createUserName) {
//        this.createUserName = createUserName;
//    }
//    /**
//     * 修改者名称
//     */
//    public String getUpdateUserName() {
//        return updateUserName;
//    }
//
//    /**
//     * 修改者名称
//     */
//    public void setUpdateUserName(String updateUserName) {
//        this.updateUserName = updateUserName;
//    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 零星费用单id
     */
    @ReferSerialTransfer(referCode = "oddFeeRef")
    public Long getOddFeeId() {
        return oddFeeId;
    }

    /**
     * 零星费用单id
     */
    @ReferDeserialTransfer
    public void setOddFeeId(Long oddFeeId) {
        this.oddFeeId = oddFeeId;
    }
    /**
     * 零星费用单编码
     */
    public String getOddFeeCode() {
        return oddFeeCode;
    }

    /**
     * 零星费用单编码
     */
    public void setOddFeeCode(String oddFeeCode) {
        this.oddFeeCode = oddFeeCode;
    }
    /**
     * 无合同费用类型ID
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getNoContractFeeTypeId() {
        return noContractFeeTypeId;
    }

    /**
     * 无合同费用类型ID
     */
    @ReferDeserialTransfer
    public void setNoContractFeeTypeId(Long noContractFeeTypeId) {
        this.noContractFeeTypeId = noContractFeeTypeId;
    }
    /**
     * 无合同费用类型名称
     */
    public String getNoContractFeeTypeName() {
        return noContractFeeTypeName;
    }

    /**
     * 无合同费用类型名称
     */
    public void setNoContractFeeTypeName(String noContractFeeTypeName) {
        this.noContractFeeTypeName = noContractFeeTypeName;
    }
    /**
     * 无合同费用类型编码
     */
    public String getNoContractFeeTypeCode() {
        return noContractFeeTypeCode;
    }

    /**
     * 无合同费用类型编码
     */
    public void setNoContractFeeTypeCode(String noContractFeeTypeCode) {
        this.noContractFeeTypeCode = noContractFeeTypeCode;
    }
    /**
     * 项目部id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 发生日期
     */
    public Date getHappenDate() {
        return happenDate;
    }

    /**
     * 发生日期
     */
    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 业务说明
     */
    public String getBusinessExplain() {
        return businessExplain;
    }

    /**
     * 业务说明
     */
    public void setBusinessExplain(String businessExplain) {
        this.businessExplain = businessExplain;
    }
    /**
     * 费用金额
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 费用金额
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 费用金额(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 费用金额(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 单据日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 单据日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */

    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 经办日期
     */
    public Date getEmployeeDate() {
        return employeeDate;
    }

    /**
     * 经办日期
     */
    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 已分摊金额(不含本次)
     */
    public BigDecimal getHaveAllocatedTaxMny() {
        return haveAllocatedTaxMny;
    }

    /**
     * 已分摊金额(不含本次)
     */
    public void setHaveAllocatedTaxMny(BigDecimal haveAllocatedTaxMny) {
        this.haveAllocatedTaxMny = haveAllocatedTaxMny;
    }
    /**
     * 已分摊金额(不含本次)(无税)
     */
    public BigDecimal getHaveAllocatedMny() {
        return haveAllocatedMny;
    }

    /**
     * 已分摊金额(不含本次)(无税)
     */
    public void setHaveAllocatedMny(BigDecimal haveAllocatedMny) {
        this.haveAllocatedMny = haveAllocatedMny;
    }
    /**
     * 剩余可分摊金额
     */
    public BigDecimal getSurplusAllocatedTaxMny() {
        return surplusAllocatedTaxMny;
    }

    /**
     * 剩余可分摊金额
     */
    public void setSurplusAllocatedTaxMny(BigDecimal surplusAllocatedTaxMny) {
        this.surplusAllocatedTaxMny = surplusAllocatedTaxMny;
    }
    /**
     * 剩余可分摊金额(无税)
     */
    public BigDecimal getSurplusAllocatedMny() {
        return surplusAllocatedMny;
    }

    /**
     * 剩余可分摊金额(无税)
     */
    public void setSurplusAllocatedMny(BigDecimal surplusAllocatedMny) {
        this.surplusAllocatedMny = surplusAllocatedMny;
    }
    /**
     * 本次分摊金额合计
     */
    public BigDecimal getAllocatedTaxMny() {
        return allocatedTaxMny;
    }

    /**
     * 本次分摊金额合计
     */
    public void setAllocatedTaxMny(BigDecimal allocatedTaxMny) {
        this.allocatedTaxMny = allocatedTaxMny;
    }
    /**
     * 本次分摊金额合计(无税)
     */
    public BigDecimal getAllocatedMny() {
        return allocatedMny;
    }

    /**
     * 本次分摊金额合计(无税)
     */
    public void setAllocatedMny(BigDecimal allocatedMny) {
        this.allocatedMny = allocatedMny;
    }
    /**
     * 本次分摊比例
     */
    public BigDecimal getAllocatedRatio() {
        return allocatedRatio;
    }

    /**
     * 本次分摊比例
     */
    public void setAllocatedRatio(BigDecimal allocatedRatio) {
        this.allocatedRatio = allocatedRatio;
    }
    /**
     * 累计分摊金额(含本次)
     */
    public BigDecimal getTotalAllocatedTaxMny() {
        return totalAllocatedTaxMny;
    }

    /**
     * 累计分摊金额(含本次)
     */
    public void setTotalAllocatedTaxMny(BigDecimal totalAllocatedTaxMny) {
        this.totalAllocatedTaxMny = totalAllocatedTaxMny;
    }
    /**
     * 累计分摊金额(含本次)(无税)
     */
    public BigDecimal getTotalAllocatedMny() {
        return totalAllocatedMny;
    }

    /**
     * 累计分摊金额(含本次)(无税)
     */
    public void setTotalAllocatedMny(BigDecimal totalAllocatedMny) {
        this.totalAllocatedMny = totalAllocatedMny;
    }
    /**
     * 累计分摊比例
     */
    public BigDecimal getTotalAllocatedRatio() {
        return totalAllocatedRatio;
    }

    /**
     * 累计分摊比例
     */
    public void setTotalAllocatedRatio(BigDecimal totalAllocatedRatio) {
        this.totalAllocatedRatio = totalAllocatedRatio;
    }
    
     /**
      * 零星费用分配子表
      */
      public List<OddAllocationDetailVO> getOddAllocationDetailList() {
         return oddAllocationDetailList;
      }
     /**
      * 零星费用分配子表
      */
     public void setOddAllocationDetailList(List<OddAllocationDetailVO> oddAllocationDetailList) {
         this.oddAllocationDetailList = oddAllocationDetailList;
     }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public BigDecimal getDetailAllocatedTaxMny() {
        return detailAllocatedTaxMny;
    }

    public void setDetailAllocatedTaxMny(BigDecimal detailAllocatedTaxMny) {
        this.detailAllocatedTaxMny = detailAllocatedTaxMny;
    }

    public BigDecimal getDetailAllocatedMny() {
        return detailAllocatedMny;
    }

    public void setDetailAllocatedMny(BigDecimal detailAllocatedMny) {
        this.detailAllocatedMny = detailAllocatedMny;
    }

    public BigDecimal getDetailAllocatedRatio() {
        return detailAllocatedRatio;
    }

    public void setDetailAllocatedRatio(BigDecimal detailAllocatedRatio) {
        this.detailAllocatedRatio = detailAllocatedRatio;
    }

    public String getEmployOAAccount() {
        return employOAAccount;
    }

    public void setEmployOAAccount(String employOAAccount) {
        this.employOAAccount = employOAAccount;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getCreateDateStr() {
        return createDateStr;
    }

    public void setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
    }
}
