package com.ejianc.business.profinance.person.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 借款管理-个人还款
 * 
 * @author generator
 * 
 */
public class PersonRepayVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private String billCode; // 单据编号
    private String billName; // 单据名称
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门名称
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long repayProjectId; // 还款人所在项目id
    private String repayProjectCode; // 还款人所在项目编码
    private String repayProjectName; // 还款人所在项目名称
    private Long repayPersonId; // 还款人id
    private String repayPersonCode; // 还款人编码
    private String repayPersonName; // 还款人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date repayDate; // 还款日期
    private Long settleTypeId; // 结算方式id
    private String settleTypeCode; // 结算方式编码
    private String settleTypeName; // 结算方式名称
    private BigDecimal curTotalRepayMny; // 本次还款金额合计
    private String memo; // 备注
    private String billStateStr;


    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    private List<PersonRepayDetailVO> detailList = new ArrayList<>();

    public List<PersonRepayDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PersonRepayDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getRepayProjectId() {
        return repayProjectId;
    }
    @ReferDeserialTransfer
    public void setRepayProjectId(Long repayProjectId) {
        this.repayProjectId = repayProjectId;
    }
    public String getRepayProjectCode() {
        return repayProjectCode;
    }

    public void setRepayProjectCode(String repayProjectCode) {
        this.repayProjectCode = repayProjectCode;
    }
    public String getRepayProjectName() {
        return repayProjectName;
    }

    public void setRepayProjectName(String repayProjectName) {
        this.repayProjectName = repayProjectName;
    }
    public Long getRepayPersonId() {
        return repayPersonId;
    }
    @ReferDeserialTransfer
    public void setRepayPersonId(Long repayPersonId) {
        this.repayPersonId = repayPersonId;
    }
    public String getRepayPersonCode() {
        return repayPersonCode;
    }

    public void setRepayPersonCode(String repayPersonCode) {
        this.repayPersonCode = repayPersonCode;
    }
    public String getRepayPersonName() {
        return repayPersonName;
    }

    public void setRepayPersonName(String repayPersonName) {
        this.repayPersonName = repayPersonName;
    }
    public Date getRepayDate() {
        return repayDate;
    }

    public void setRepayDate(Date repayDate) {
        this.repayDate = repayDate;
    }
    public Long getSettleTypeId() {
        return settleTypeId;
    }
    @ReferDeserialTransfer
    public void setSettleTypeId(Long settleTypeId) {
        this.settleTypeId = settleTypeId;
    }
    public String getSettleTypeCode() {
        return settleTypeCode;
    }

    public void setSettleTypeCode(String settleTypeCode) {
        this.settleTypeCode = settleTypeCode;
    }
    public String getSettleTypeName() {
        return settleTypeName;
    }

    public void setSettleTypeName(String settleTypeName) {
        this.settleTypeName = settleTypeName;
    }
    public BigDecimal getCurTotalRepayMny() {
        return curTotalRepayMny;
    }

    public void setCurTotalRepayMny(BigDecimal curTotalRepayMny) {
        this.curTotalRepayMny = curTotalRepayMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
