package com.ejianc.business.profinance.odd.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 零星费用单导入VO
 * 
 * @author generator
 * 
 */
@ApiModel("零星费用单")
public class ImportOddFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部所属组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("无合同费用类型ID")
    private Long noContractFeeTypeId;
    @ApiModelProperty("无合同费用类型名称")
    private String noContractFeeTypeName;
    @ApiModelProperty("无合同费用类型编码")
    private String noContractFeeTypeCode;
    @ApiModelProperty("发生日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date happenDate;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("费用金额")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("费用金额(无税)")
    private BigDecimal feeMny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门id")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("经办日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date employeeDate;
    @ApiModelProperty("业务说明")
    private String businessExplain;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("已分摊金额")
    private BigDecimal haveAllocatedTaxMny;
    @ApiModelProperty("已分摊金额(无税)")
    private BigDecimal haveAllocatedMny;
    @ApiModelProperty("剩余可分摊金额")
    private BigDecimal surplusAllocatedTaxMny;
    @ApiModelProperty("剩余可分摊金额(无税)")
    private BigDecimal surplusAllocatedMny;
    @ApiModelProperty("已支付金额")
    private BigDecimal payTaxMny;
    @ApiModelProperty("已支付金额(无税)")
    private BigDecimal payMny;
    @ApiModelProperty("剩余需支付金额")
    private BigDecimal surplusPayTaxMny;
    @ApiModelProperty("剩余需支付金额(无税)")
    private BigDecimal surplusPayMny;
    @ApiModelProperty("支付对象类型")
    private Integer payTargetType;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("内部员工id")
    private Long ownStaffId;
    @ApiModelProperty("内部员工名称")
    private String ownStaffName;

    @ApiModelProperty("I8单位编码")
    private String I8DeptCode;
    @ApiModelProperty("纳税人识别号")
    private String taxPayerNum;
    @ApiModelProperty("身份证号")
    private String idCardNum;
    @ApiModelProperty("OA账号")
    private String OAAccount;
    @ApiModelProperty("经办人OA账号")
    private String employOAAccount;

    /**
     * 导入失败原因
     */
    private String errorMessage;

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目Id
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目部id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部所属组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 无合同费用类型ID
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getNoContractFeeTypeId() {
        return noContractFeeTypeId;
    }

    /**
     * 无合同费用类型ID
     */
    @ReferDeserialTransfer
    public void setNoContractFeeTypeId(Long noContractFeeTypeId) {
        this.noContractFeeTypeId = noContractFeeTypeId;
    }
    /**
     * 无合同费用类型名称
     */
    public String getNoContractFeeTypeName() {
        return noContractFeeTypeName;
    }

    /**
     * 无合同费用类型名称
     */
    public void setNoContractFeeTypeName(String noContractFeeTypeName) {
        this.noContractFeeTypeName = noContractFeeTypeName;
    }
    /**
     * 无合同费用类型编码
     */
    public String getNoContractFeeTypeCode() {
        return noContractFeeTypeCode;
    }

    /**
     * 无合同费用类型编码
     */
    public void setNoContractFeeTypeCode(String noContractFeeTypeCode) {
        this.noContractFeeTypeCode = noContractFeeTypeCode;
    }
    /**
     * 发生日期
     */
    public Date getHappenDate() {
        return happenDate;
    }

    /**
     * 发生日期
     */
    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 费用金额
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 费用金额
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 费用金额(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 费用金额(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 经办日期
     */
    public Date getEmployeeDate() {
        return employeeDate;
    }

    /**
     * 经办日期
     */
    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }
    /**
     * 业务说明
     */
    public String getBusinessExplain() {
        return businessExplain;
    }

    /**
     * 业务说明
     */
    public void setBusinessExplain(String businessExplain) {
        this.businessExplain = businessExplain;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 已分摊金额
     */
    public BigDecimal getHaveAllocatedTaxMny() {
        return haveAllocatedTaxMny;
    }

    /**
     * 已分摊金额
     */
    public void setHaveAllocatedTaxMny(BigDecimal haveAllocatedTaxMny) {
        this.haveAllocatedTaxMny = haveAllocatedTaxMny;
    }
    /**
     * 已分摊金额(无税)
     */
    public BigDecimal getHaveAllocatedMny() {
        return haveAllocatedMny;
    }

    /**
     * 已分摊金额(无税)
     */
    public void setHaveAllocatedMny(BigDecimal haveAllocatedMny) {
        this.haveAllocatedMny = haveAllocatedMny;
    }
    /**
     * 剩余可分摊金额
     */
    public BigDecimal getSurplusAllocatedTaxMny() {
        return surplusAllocatedTaxMny;
    }

    /**
     * 剩余可分摊金额
     */
    public void setSurplusAllocatedTaxMny(BigDecimal surplusAllocatedTaxMny) {
        this.surplusAllocatedTaxMny = surplusAllocatedTaxMny;
    }
    /**
     * 剩余可分摊金额(无税)
     */
    public BigDecimal getSurplusAllocatedMny() {
        return surplusAllocatedMny;
    }

    /**
     * 剩余可分摊金额(无税)
     */
    public void setSurplusAllocatedMny(BigDecimal surplusAllocatedMny) {
        this.surplusAllocatedMny = surplusAllocatedMny;
    }
    /**
     * 已支付金额
     */
    public BigDecimal getPayTaxMny() {
        return payTaxMny;
    }

    /**
     * 已支付金额
     */
    public void setPayTaxMny(BigDecimal payTaxMny) {
        this.payTaxMny = payTaxMny;
    }
    /**
     * 已支付金额(无税)
     */
    public BigDecimal getPayMny() {
        return payMny;
    }

    /**
     * 已支付金额(无税)
     */
    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    /**
     * 剩余需支付金额
     */
    public BigDecimal getSurplusPayTaxMny() {
        return surplusPayTaxMny;
    }

    /**
     * 剩余需支付金额
     */
    public void setSurplusPayTaxMny(BigDecimal surplusPayTaxMny) {
        this.surplusPayTaxMny = surplusPayTaxMny;
    }
    /**
     * 剩余需支付金额(无税)
     */
    public BigDecimal getSurplusPayMny() {
        return surplusPayMny;
    }

    /**
     * 剩余需支付金额(无税)
     */
    public void setSurplusPayMny(BigDecimal surplusPayMny) {
        this.surplusPayMny = surplusPayMny;
    }
    /**
     * 支付对象类型
     */
    public Integer getPayTargetType() {
        return payTargetType;
    }

    /**
     * 支付对象类型
     */
    public void setPayTargetType(Integer payTargetType) {
        this.payTargetType = payTargetType;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 内部员工id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getOwnStaffId() {
        return ownStaffId;
    }

    /**
     * 内部员工id
     */
    @ReferDeserialTransfer
    public void setOwnStaffId(Long ownStaffId) {
        this.ownStaffId = ownStaffId;
    }
    /**
     * 内部员工名称
     */
    public String getOwnStaffName() {
        return ownStaffName;
    }

    /**
     * 内部员工名称
     */
    public void setOwnStaffName(String ownStaffName) {
        this.ownStaffName = ownStaffName;
    }

    public String getI8DeptCode() {
        return I8DeptCode;
    }

    public void setI8DeptCode(String i8DeptCode) {
        I8DeptCode = i8DeptCode;
    }

    public String getTaxPayerNum() {
        return taxPayerNum;
    }

    public void setTaxPayerNum(String taxPayerNum) {
        this.taxPayerNum = taxPayerNum;
    }

    public String getIdCardNum() {
        return idCardNum;
    }

    public void setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
    }

    public String getOAAccount() {
        return OAAccount;
    }

    public void setOAAccount(String OAAccount) {
        this.OAAccount = OAAccount;
    }

    public String getEmployOAAccount() {
        return employOAAccount;
    }

    public void setEmployOAAccount(String employOAAccount) {
        this.employOAAccount = employOAAccount;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
