package com.ejianc.business.profinance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 工人工资单导入模板
 */
public class ImportSalaryDetailVO extends BaseVO {

    private Long salaryId; // 工人工资单主表id
    private String workerName; // 工人
    private String workType; // 工种
    private String workerIdCard; // 工人身份证号
    private String teamName; // 队伍名称
    private String groupName; // 班组名称
    private Integer measureType; // 计量方式 （0:按天，1计件 2：按小时 3：按月）
    private BigDecimal workNum; // 工作量
    private BigDecimal price; // 单价
    private BigDecimal deductMny; // 借扣款费用
    private BigDecimal award; // 奖励
    private BigDecimal salaryMny; // 工资总额：工作量*单价+奖励-借扣款
    private String accountNum; // 银行账/卡号
    private String bankName; // 开户行
    private String bankProvince; // 开户行省份
    private String memo; // 备注

    private BigDecimal personalWorkingDayOfMonth; // 个人工日
    private BigDecimal workingDayOfMonth; // 班组工日
    private BigDecimal totalSalary; // 工资总额
    private BigDecimal otherDeduct; // 其他扣款
    private BigDecimal approvalSalaryMny; // 核定工资
    private String interBankNum; // 联行号
    private BigDecimal proposedPaymentMny; // 拟支付金额

    /**
     * 导入失败原因
     */
    private String errorMessage;

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }

    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getWorkerIdCard() {
        return workerIdCard;
    }

    public void setWorkerIdCard(String workerIdCard) {
        this.workerIdCard = workerIdCard;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getMeasureType() {
        return measureType;
    }

    public void setMeasureType(Integer measureType) {
        this.measureType = measureType;
    }

    public BigDecimal getWorkNum() {
        return workNum;
    }

    public void setWorkNum(BigDecimal workNum) {
        this.workNum = workNum;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getAward() {
        return award;
    }

    public void setAward(BigDecimal award) {
        this.award = award;
    }

    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankProvince() {
        return bankProvince;
    }

    public void setBankProvince(String bankProvince) {
        this.bankProvince = bankProvince;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public BigDecimal getPersonalWorkingDayOfMonth() {
        return personalWorkingDayOfMonth;
    }

    public void setPersonalWorkingDayOfMonth(BigDecimal personalWorkingDayOfMonth) {
        this.personalWorkingDayOfMonth = personalWorkingDayOfMonth;
    }

    public BigDecimal getWorkingDayOfMonth() {
        return workingDayOfMonth;
    }

    public void setWorkingDayOfMonth(BigDecimal workingDayOfMonth) {
        this.workingDayOfMonth = workingDayOfMonth;
    }

    public BigDecimal getTotalSalary() {
        return totalSalary;
    }

    public void setTotalSalary(BigDecimal totalSalary) {
        this.totalSalary = totalSalary;
    }

    public BigDecimal getOtherDeduct() {
        return otherDeduct;
    }

    public void setOtherDeduct(BigDecimal otherDeduct) {
        this.otherDeduct = otherDeduct;
    }

    public BigDecimal getApprovalSalaryMny() {
        return approvalSalaryMny;
    }

    public void setApprovalSalaryMny(BigDecimal approvalSalaryMny) {
        this.approvalSalaryMny = approvalSalaryMny;
    }

    public String getInterBankNum() {
        return interBankNum;
    }

    public void setInterBankNum(String interBankNum) {
        this.interBankNum = interBankNum;
    }

    public BigDecimal getProposedPaymentMny() {
        return proposedPaymentMny;
    }

    public void setProposedPaymentMny(BigDecimal proposedPaymentMny) {
        this.proposedPaymentMny = proposedPaymentMny;
    }
}
