package com.ejianc.business.receipt.api;

import com.ejianc.business.receipt.hystrix.ReceiptRegisterHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 收款登记API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = ReceiptRegisterHystrix.class)
public interface IReceiptRegisterApi {

    /**
     * 通过项目id查询相应的累计收款金额
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/receiptRegisterApi/queryRecMnyByProjectId")
    CommonResponse<BigDecimal> queryRecMnyByProjectId(@RequestParam(value = "projectId") Long projectId);
}
