package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工人工资支付申请子实体
 *
 * @author generator
 */
public class SalaryPayApplyDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    // 消息队列routingKey
    public static final String ROUTING_KEY = "updateDetailTaxMnyAfterConfirmPayResult";

    private String createUserName; // 创建者名称
    private String updateUserName; // 修改者名称
    private Long salaryId; // 工人工资单主表ID（工人工资单也有主子表，子表存储具体的工人的工资单），跳转工资单详情时的参数id就是此值
    private Long sourceId; // 来源id，存的是选择的工资单的子表的id（工人工资单也有主子表，子表存储具体的工人的工资单）
    private Integer sourceType; // 数据来源方式 （0-同步劳务实名系统新增 1-直接新增）
    private String payResSource; // 支付结果来源，0-系统自动推送，1-手动确认
    private Long pid; // 当前表的主表ID，主表：ejc_profinance_salary_pay_apply
    private String workerBillCode; // 工人工资单号，存的是选择的工人工资单的主表的billCoded
    private Long workerId; // 工人ID
    private String workerCode; // 工人编码
    private String workerName; // 工人名称
    private String workerIdCard; // 工人身份证号已脱敏-默认展示已脱敏
    private String workerIdCardUnSensitive; // 工人身份证号未脱敏
    private Long teamId; // 队伍ID
    private String teamCode; // 队伍编码
    private String teamName; // 队伍名称
    private Long groupId; // 班组ID
    private String groupCode; // 班组编码
    private String groupName; // 班组名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date statisticalDate; // 统计日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date workerPayDate; // 支付日期
    @ReferDeserialTransfer
    private Long workerAccountId; // 银行账号id
    private String workerAccountNum; // 银行账号
    private String workerAccountName; // 银行账户名称
    private String workerBankName; // 开户行
    private Integer workerPayState; // 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
    private BigDecimal workerShouldPayTaxMny; // 应发金额（有税）
    private BigDecimal workerShouldPayMny; // 应发金额（无税）
    private BigDecimal workerShouldPayTax; // 应发金额（税额）
    private BigDecimal workerRemainderTaxMny; // 剩余可发金额（有税）
    private BigDecimal workerRemainderMny; // 剩余可发金额（无税）
    private BigDecimal workerRemainderTax; // 剩余可发金额（税额）
    private BigDecimal workerTotalApplyTaxMny; // 累计本期申请金额（有税）
    private BigDecimal workerTotalApplyMny; // 累计本期申请金额（无税）
    private BigDecimal workerTotalApplyTax; // 累计本期申请金额（税额）
    private BigDecimal workerApplyTaxMny; // 本期申请金额（有税）
    private BigDecimal workerApplyMny; // 本期申请金额（无税）
    private BigDecimal workerApplyTax; // 本期申请金额（税额）
    private BigDecimal workerActualPaidTaxMny; // 实际支付金额（有税）
    private BigDecimal workerActualPaidMny; // 实际支付金额（无税）
    private BigDecimal workerActualPaidTax; // 实际支付金额（税额）
    private Integer workerIsRepeatBill; // 是否重发：1-是，0-否
    private Long idOld; // 原申请单子表ID
    private BigDecimal workerApplyTaxMnyOld; // 原申请子表金额
    private String workerMemo; // 备注
    private String pmPayApplyDetailId; // 中间库工资支付申请子表id
    private String workerInterBankNum; // 联行号
    private String workerBankProvince; // 开户行省份
    private BigDecimal proposedPaymentMny; // 拟支付金额

    public Integer getWorkerIsRepeatBill() {
        return workerIsRepeatBill;
    }

    public void setWorkerIsRepeatBill(Integer workerIsRepeatBill) {
        this.workerIsRepeatBill = workerIsRepeatBill;
    }

    public Long getIdOld() {
        return idOld;
    }

    public void setIdOld(Long idOld) {
        this.idOld = idOld;
    }

    public BigDecimal getWorkerApplyTaxMnyOld() {
        return workerApplyTaxMnyOld;
    }

    public void setWorkerApplyTaxMnyOld(BigDecimal workerApplyTaxMnyOld) {
        this.workerApplyTaxMnyOld = workerApplyTaxMnyOld;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @Override
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getPayResSource() {
        return payResSource;
    }

    public void setPayResSource(String payResSource) {
        this.payResSource = payResSource;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }

    public String getWorkerCode() {
        return workerCode;
    }

    public void setWorkerCode(String workerCode) {
        this.workerCode = workerCode;
    }

    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    public String getWorkerIdCard() {
        return workerIdCard;
    }

    public void setWorkerIdCard(String workerIdCard) {
        this.workerIdCard = workerIdCard;
    }

    public String getWorkerIdCardUnSensitive() {
        return workerIdCardUnSensitive;
    }

    public void setWorkerIdCardUnSensitive(String workerIdCardUnSensitive) {
        this.workerIdCardUnSensitive = workerIdCardUnSensitive;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Date getStatisticalDate() {
        return statisticalDate;
    }

    public void setStatisticalDate(Date statisticalDate) {
        this.statisticalDate = statisticalDate;
    }

    public String getWorkerBillCode() {
        return workerBillCode;
    }

    public void setWorkerBillCode(String workerBillCode) {
        this.workerBillCode = workerBillCode;
    }

    public Date getWorkerPayDate() {
        return workerPayDate;
    }

    public void setWorkerPayDate(Date workerPayDate) {
        this.workerPayDate = workerPayDate;
    }

    public Long getWorkerAccountId() {
        return workerAccountId;
    }

    public void setWorkerAccountId(Long workerAccountId) {
        this.workerAccountId = workerAccountId;
    }

    public String getWorkerAccountNum() {
        return workerAccountNum;
    }

    public void setWorkerAccountNum(String workerAccountNum) {
        this.workerAccountNum = workerAccountNum;
    }

    public String getWorkerAccountName() {
        return workerAccountName;
    }

    public void setWorkerAccountName(String workerAccountName) {
        this.workerAccountName = workerAccountName;
    }

    public String getWorkerBankName() {
        return workerBankName;
    }

    public void setWorkerBankName(String workerBankName) {
        this.workerBankName = workerBankName;
    }

    public Integer getWorkerPayState() {
        return workerPayState;
    }

    public void setWorkerPayState(Integer workerPayState) {
        this.workerPayState = workerPayState;
    }

    public BigDecimal getWorkerShouldPayTaxMny() {
        return workerShouldPayTaxMny;
    }

    public void setWorkerShouldPayTaxMny(BigDecimal workerShouldPayTaxMny) {
        this.workerShouldPayTaxMny = workerShouldPayTaxMny;
    }

    public BigDecimal getWorkerShouldPayMny() {
        return workerShouldPayMny;
    }

    public void setWorkerShouldPayMny(BigDecimal workerShouldPayMny) {
        this.workerShouldPayMny = workerShouldPayMny;
    }

    public BigDecimal getWorkerShouldPayTax() {
        return workerShouldPayTax;
    }

    public void setWorkerShouldPayTax(BigDecimal workerShouldPayTax) {
        this.workerShouldPayTax = workerShouldPayTax;
    }

    public BigDecimal getWorkerRemainderTaxMny() {
        return workerRemainderTaxMny;
    }

    public void setWorkerRemainderTaxMny(BigDecimal workerRemainderTaxMny) {
        this.workerRemainderTaxMny = workerRemainderTaxMny;
    }

    public BigDecimal getWorkerRemainderMny() {
        return workerRemainderMny;
    }

    public void setWorkerRemainderMny(BigDecimal workerRemainderMny) {
        this.workerRemainderMny = workerRemainderMny;
    }

    public BigDecimal getWorkerRemainderTax() {
        return workerRemainderTax;
    }

    public void setWorkerRemainderTax(BigDecimal workerRemainderTax) {
        this.workerRemainderTax = workerRemainderTax;
    }

    public BigDecimal getWorkerTotalApplyTaxMny() {
        return workerTotalApplyTaxMny;
    }

    public void setWorkerTotalApplyTaxMny(BigDecimal workerTotalApplyTaxMny) {
        this.workerTotalApplyTaxMny = workerTotalApplyTaxMny;
    }

    public BigDecimal getWorkerTotalApplyMny() {
        return workerTotalApplyMny;
    }

    public void setWorkerTotalApplyMny(BigDecimal workerTotalApplyMny) {
        this.workerTotalApplyMny = workerTotalApplyMny;
    }

    public BigDecimal getWorkerTotalApplyTax() {
        return workerTotalApplyTax;
    }

    public void setWorkerTotalApplyTax(BigDecimal workerTotalApplyTax) {
        this.workerTotalApplyTax = workerTotalApplyTax;
    }

    public BigDecimal getWorkerApplyTaxMny() {
        return workerApplyTaxMny;
    }

    public void setWorkerApplyTaxMny(BigDecimal workerApplyTaxMny) {
        this.workerApplyTaxMny = workerApplyTaxMny;
    }

    public BigDecimal getWorkerApplyMny() {
        return workerApplyMny;
    }

    public void setWorkerApplyMny(BigDecimal workerApplyMny) {
        this.workerApplyMny = workerApplyMny;
    }

    public BigDecimal getWorkerApplyTax() {
        return workerApplyTax;
    }

    public void setWorkerApplyTax(BigDecimal workerApplyTax) {
        this.workerApplyTax = workerApplyTax;
    }

    public BigDecimal getWorkerActualPaidTaxMny() {
        return workerActualPaidTaxMny;
    }

    public void setWorkerActualPaidTaxMny(BigDecimal workerActualPaidTaxMny) {
        this.workerActualPaidTaxMny = workerActualPaidTaxMny;
    }

    public BigDecimal getWorkerActualPaidMny() {
        return workerActualPaidMny;
    }

    public void setWorkerActualPaidMny(BigDecimal workerActualPaidMny) {
        this.workerActualPaidMny = workerActualPaidMny;
    }

    public BigDecimal getWorkerActualPaidTax() {
        return workerActualPaidTax;
    }

    public void setWorkerActualPaidTax(BigDecimal workerActualPaidTax) {
        this.workerActualPaidTax = workerActualPaidTax;
    }

    public String getWorkerMemo() {
        return workerMemo;
    }

    public void setWorkerMemo(String workerMemo) {
        this.workerMemo = workerMemo;
    }

    public String getPmPayApplyDetailId() {
        return pmPayApplyDetailId;
    }

    public void setPmPayApplyDetailId(String pmPayApplyDetailId) {
        this.pmPayApplyDetailId = pmPayApplyDetailId;
    }

    public String getWorkerInterBankNum() {
        return workerInterBankNum;
    }

    public void setWorkerInterBankNum(String workerInterBankNum) {
        this.workerInterBankNum = workerInterBankNum;
    }

    public String getWorkerBankProvince() {
        return workerBankProvince;
    }

    public void setWorkerBankProvince(String workerBankProvince) {
        this.workerBankProvince = workerBankProvince;
    }

    public BigDecimal getProposedPaymentMny() {
        return proposedPaymentMny;
    }

    public void setProposedPaymentMny(BigDecimal proposedPaymentMny) {
        this.proposedPaymentMny = proposedPaymentMny;
    }
}
