package com.ejianc.business.profinance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
//    private Integer paymentStatus; // 支付状态 1-未支付 2-已支付 3-申请中 4 推送异常 5 支付中 6 支付成功 7支付失败 8 退票

public enum PayStatusEnum {

    未支付(1, "未支付"),
    已支付(2, "已支付"),
    申请中(3, "申请中"),
    推送异常(4, "推送异常"),
    支付中(5, "支付中"),
    支付成功(6, "支付成功"),
    支付失败(7, "支付失败"),
    退票(8, "退票");

    private Integer code;
    private String name;
    private static Map<Integer, PayStatusEnum> enumMap = new HashMap<>();

    PayStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        enumMap = EnumSet.allOf(PayStatusEnum.class)
                .stream().collect(Collectors.toMap(PayStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static PayStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
